/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.common;

import java.util.Objects;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Value;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.ValueType;

final class ValueBoolean
implements Value<Boolean> {
    private final boolean value;

    private ValueBoolean(boolean value) {
        this.value = value;
    }

    static Value<Boolean> create(boolean value) {
        return new ValueBoolean(value);
    }

    @Override
    public ValueType getType() {
        return ValueType.BOOLEAN;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    public String toString() {
        return "ValueBoolean{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Value && Objects.equals(this.value, ((Value)o).getValue());
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }
}

