/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.protobuf.services.internal;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Throwables;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.protobuf.services.HealthCheckingLoadBalancerUtil;

@Internal
public final class HealthCheckingRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    private final LoadBalancerProvider rrProvider = HealthCheckingRoundRobinLoadBalancerProvider.newRoundRobinProvider();

    @Override
    public boolean isAvailable() {
        return this.rrProvider.isAvailable();
    }

    @Override
    public int getPriority() {
        return this.rrProvider.getPriority() + 1;
    }

    @Override
    public String getPolicyName() {
        return this.rrProvider.getPolicyName();
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return HealthCheckingLoadBalancerUtil.newHealthCheckingLoadBalancer(this.rrProvider, helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return this.rrProvider.parseLoadBalancingPolicyConfig(rawLoadBalancingPolicyConfig);
    }

    @VisibleForTesting
    static LoadBalancerProvider newRoundRobinProvider() {
        try {
            Class<LoadBalancerProvider> rrProviderClass = Class.forName("net.snowflake.client.jdbc.internal.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider").asSubclass(LoadBalancerProvider.class);
            return rrProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

