/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.internal;

import java.util.Set;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Objects;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;

@Immutable
final class RetryPolicy {
    final int maxAttempts;
    final long initialBackoffNanos;
    final long maxBackoffNanos;
    final double backoffMultiplier;
    @Nullable
    final Long perAttemptRecvTimeoutNanos;
    final Set<Status.Code> retryableStatusCodes;

    RetryPolicy(int maxAttempts, long initialBackoffNanos, long maxBackoffNanos, double backoffMultiplier, @Nullable Long perAttemptRecvTimeoutNanos, @Nonnull Set<Status.Code> retryableStatusCodes) {
        this.maxAttempts = maxAttempts;
        this.initialBackoffNanos = initialBackoffNanos;
        this.maxBackoffNanos = maxBackoffNanos;
        this.backoffMultiplier = backoffMultiplier;
        this.perAttemptRecvTimeoutNanos = perAttemptRecvTimeoutNanos;
        this.retryableStatusCodes = ImmutableSet.copyOf(retryableStatusCodes);
    }

    public int hashCode() {
        return Objects.hashCode(this.maxAttempts, this.initialBackoffNanos, this.maxBackoffNanos, this.backoffMultiplier, this.perAttemptRecvTimeoutNanos, this.retryableStatusCodes);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RetryPolicy)) {
            return false;
        }
        RetryPolicy that = (RetryPolicy)other;
        return this.maxAttempts == that.maxAttempts && this.initialBackoffNanos == that.initialBackoffNanos && this.maxBackoffNanos == that.maxBackoffNanos && Double.compare(this.backoffMultiplier, that.backoffMultiplier) == 0 && Objects.equal(this.perAttemptRecvTimeoutNanos, that.perAttemptRecvTimeoutNanos) && Objects.equal(this.retryableStatusCodes, that.retryableStatusCodes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxAttempts", this.maxAttempts).add("initialBackoffNanos", this.initialBackoffNanos).add("maxBackoffNanos", this.maxBackoffNanos).add("backoffMultiplier", this.backoffMultiplier).add("perAttemptRecvTimeoutNanos", this.perAttemptRecvTimeoutNanos).add("retryableStatusCodes", this.retryableStatusCodes).toString();
    }
}

