/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.core;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.api.gax.core.AutoValue_InstantiatingExecutorProvider;
import net.snowflake.client.jdbc.internal.google.api.gax.core.ExecutorProvider;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;

@AutoValue
public abstract class InstantiatingExecutorProvider
implements ExecutorProvider {
    private static final Logger LOGGER = Logger.getLogger(InstantiatingExecutorProvider.class.getName());
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger threadCount = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("Gax-" + this.threadCount.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    };
    private static final int MIN_THREAD_AMOUNT = 4;
    private static final int IO_THREAD_MULTIPLIER = 50;

    InstantiatingExecutorProvider() {
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return new ScheduledThreadPoolExecutor(this.getExecutorThreadCount(), this.getThreadFactory());
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    public abstract int getExecutorThreadCount();

    public abstract ThreadFactory getThreadFactory();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        int numCpus = Runtime.getRuntime().availableProcessors();
        int numThreads = Math.max(4, numCpus);
        return new AutoValue_InstantiatingExecutorProvider.Builder().setExecutorThreadCount(numThreads).setThreadFactory(DEFAULT_THREAD_FACTORY);
    }

    public static Builder newIOBuilder() {
        int numCpus = Runtime.getRuntime().availableProcessors();
        int numThreads = 50 * Math.max(4, numCpus);
        LOGGER.log(Level.CONFIG, String.format("Thread Pool for requests has Core Pool Size: %d", numThreads));
        return new AutoValue_InstantiatingExecutorProvider.Builder().setExecutorThreadCount(numThreads).setThreadFactory(DEFAULT_THREAD_FACTORY);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setExecutorThreadCount(int var1);

        public abstract int getExecutorThreadCount();

        public abstract Builder setThreadFactory(ThreadFactory var1);

        public abstract ThreadFactory getThreadFactory();

        public abstract InstantiatingExecutorProvider build();
    }
}

