/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BigIntWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.BigIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBigIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;

public class BigIntHolderReaderImpl
extends AbstractFieldReader {
    private BigIntHolder holder;

    public BigIntHolderReaderImpl(BigIntHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.BIGINT;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(BigIntHolder h2) {
        h2.value = this.holder.value;
    }

    @Override
    public void read(NullableBigIntHolder h2) {
        h2.value = this.holder.value;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Long readLong() {
        Long value = new Long(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readLong();
    }

    @Override
    public void copyAsValue(BigIntWriter writer) {
        writer.write(this.holder);
    }
}

