/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.transform;

import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.transform.JsonUnmarshallerContext;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;

@SdkInternalApi
public class UnknownMemberJsonUnmarshaller
implements Unmarshaller<Void, JsonUnmarshallerContext> {
    private static final UnknownMemberJsonUnmarshaller INSTANCE = new UnknownMemberJsonUnmarshaller();

    @Override
    public Void unmarshall(JsonUnmarshallerContext ctx) throws Exception {
        UnknownMemberJsonUnmarshaller.consumeValue(ctx, true);
        return null;
    }

    public static UnknownMemberJsonUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static void consumeValue(JsonUnmarshallerContext ctx, boolean isRoot) throws Exception {
        JsonToken token = ctx.getCurrentToken();
        if (token == null) {
            token = ctx.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return;
        }
        switch (token) {
            case START_ARRAY: {
                ctx.nextToken();
                UnknownMemberJsonUnmarshaller.consumeArray(ctx);
                break;
            }
            case START_OBJECT: {
                ctx.nextToken();
                UnknownMemberJsonUnmarshaller.consumeObject(ctx);
                break;
            }
        }
        if (!isRoot) {
            ctx.nextToken();
        }
    }

    private static void consumeArray(JsonUnmarshallerContext ctx) throws Exception {
        JsonToken token;
        while ((token = ctx.getCurrentToken()) != null) {
            if (token == JsonToken.END_ARRAY) {
                return;
            }
            UnknownMemberJsonUnmarshaller.consumeValue(ctx, false);
        }
        return;
    }

    private static void consumeObject(JsonUnmarshallerContext ctx) throws Exception {
        JsonToken token;
        block4: while (true) {
            if ((token = ctx.getCurrentToken()) == null) {
                return;
            }
            switch (token) {
                case END_OBJECT: {
                    return;
                }
                case FIELD_NAME: {
                    ctx.nextToken();
                    UnknownMemberJsonUnmarshaller.consumeValue(ctx, false);
                    continue block4;
                }
            }
            break;
        }
        throw new RuntimeException("Expected either a field name or end of the object, but got " + (Object)((Object)token));
    }
}

