/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.jmespath;

import java.util.Arrays;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.jmespath.InvalidTypeException;
import net.snowflake.client.jdbc.internal.amazonaws.jmespath.JmesPathExpression;
import net.snowflake.client.jdbc.internal.amazonaws.jmespath.JmesPathFunction;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.IntNode;

public class JmesPathLengthFunction
extends JmesPathFunction {
    public JmesPathLengthFunction(JmesPathExpression ... expressions) {
        this(Arrays.asList(expressions));
    }

    public JmesPathLengthFunction(List<JmesPathExpression> arguments) {
        super(arguments);
    }

    @Override
    public JsonNode evaluate(List<JsonNode> evaluatedArgs) throws InvalidTypeException {
        JsonNode arg = evaluatedArgs.get(0);
        if (arg.isTextual()) {
            return JmesPathLengthFunction.getStringLength(arg);
        }
        if (arg.isArray() || arg.isObject()) {
            return new IntNode(arg.size());
        }
        throw new InvalidTypeException("Type mismatch. Expecting a string or an array or an object.");
    }

    private static IntNode getStringLength(JsonNode arg) {
        return new IntNode(arg.asText().length());
    }
}

