/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarBinaryVector;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;

public class VarBinaryToBinaryConverter
extends AbstractArrowVectorConverter {
    private VarBinaryVector varBinaryVector;

    public VarBinaryToBinaryConverter(ValueVector valueVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.BINARY.name(), valueVector, columnIndex, context);
        this.varBinaryVector = (VarBinaryVector)valueVector;
    }

    @Override
    public String toString(int index) {
        byte[] bytes = this.toBytes(index);
        SFBinary binary = new SFBinary(bytes);
        return bytes == null ? null : this.context.getBinaryFormatter().format(binary);
    }

    @Override
    public byte[] toBytes(int index) {
        return this.varBinaryVector.getObject(index);
    }

    @Override
    public Object toObject(int index) {
        return this.toBytes(index);
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        String str = this.toString(index);
        if (str == null) {
            return false;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Boolean", str);
    }
}

