/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.queue;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.queue.CloudQueueMessage;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.queue.QueueMessageType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class QueueMessageHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ArrayList<CloudQueueMessage> messages = new ArrayList();
    private final boolean shouldEncodeMessage;
    private CloudQueueMessage message = new CloudQueueMessage();

    private QueueMessageHandler(boolean shouldEncodeMessage) {
        this.shouldEncodeMessage = shouldEncodeMessage;
    }

    public static ArrayList<CloudQueueMessage> readMessages(InputStream stream, boolean shouldEncodeMessage) throws SAXException, IOException, ParserConfigurationException {
        SAXParser saxParser = Utility.getSAXParser();
        QueueMessageHandler handler = new QueueMessageHandler(shouldEncodeMessage);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.messages;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("QueueMessage".equals(localName)) {
            this.message = new CloudQueueMessage();
            this.message.setMessageType(this.shouldEncodeMessage ? QueueMessageType.BASE_64_ENCODED : QueueMessageType.RAW_STRING);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String value = this.bld.toString();
        if (value.isEmpty()) {
            value = null;
        }
        if ("QueueMessage".equals(localName)) {
            this.messages.add(this.message);
        } else if ("MessageId".equals(currentNode)) {
            this.message.setMessageId(value);
        } else if ("InsertionTime".equals(currentNode)) {
            try {
                this.message.setInsertionTime(Utility.parseRFC1123DateFromStringInGMT(value));
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("ExpirationTime".equals(currentNode)) {
            try {
                this.message.setExpirationTime(Utility.parseRFC1123DateFromStringInGMT(value));
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("PopReceipt".equals(currentNode)) {
            this.message.setPopReceipt(value);
        } else if ("TimeNextVisible".equals(currentNode)) {
            try {
                this.message.setNextVisibleTime(Utility.parseRFC1123DateFromStringInGMT(value));
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("DequeueCount".equals(currentNode)) {
            this.message.setDequeueCount(Integer.parseInt(value));
        } else if ("MessageText".equals(currentNode)) {
            this.message.messageContent = value;
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

