/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.re2j;

import net.snowflake.client.jdbc.internal.google.re2j.Unicode;

abstract class Utils {
    static final int[] EMPTY_INTS = new int[0];
    private static final String METACHARACTERS = "\\.+*?()|[]{}^$";
    static final int EMPTY_BEGIN_LINE = 1;
    static final int EMPTY_END_LINE = 2;
    static final int EMPTY_BEGIN_TEXT = 4;
    static final int EMPTY_END_TEXT = 8;
    static final int EMPTY_WORD_BOUNDARY = 16;
    static final int EMPTY_NO_WORD_BOUNDARY = 32;
    static final int EMPTY_ALL = -1;

    static boolean isalnum(int c) {
        return 48 <= c && c <= 57 || 65 <= c && c <= 90 || 97 <= c && c <= 122;
    }

    static int unhex(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        return -1;
    }

    static void escapeRune(StringBuilder out, int rune) {
        if (Unicode.isPrint(rune)) {
            if (METACHARACTERS.indexOf((char)rune) >= 0) {
                out.append('\\');
            }
            out.appendCodePoint(rune);
            return;
        }
        switch (rune) {
            case 34: {
                out.append("\\\"");
                break;
            }
            case 92: {
                out.append("\\\\");
                break;
            }
            case 9: {
                out.append("\\t");
                break;
            }
            case 10: {
                out.append("\\n");
                break;
            }
            case 13: {
                out.append("\\r");
                break;
            }
            case 8: {
                out.append("\\b");
                break;
            }
            case 12: {
                out.append("\\f");
                break;
            }
            default: {
                String s2 = Integer.toHexString(rune);
                if (rune < 256) {
                    out.append("\\x");
                    if (s2.length() == 1) {
                        out.append('0');
                    }
                    out.append(s2);
                    break;
                }
                out.append("\\x{").append(s2).append('}');
                break;
            }
        }
    }

    static int[] stringToRunes(String str) {
        int rune;
        int charlen = str.length();
        int runelen = str.codePointCount(0, charlen);
        int[] runes = new int[runelen];
        int r = 0;
        for (int c = 0; c < charlen; c += Character.charCount(rune)) {
            rune = str.codePointAt(c);
            runes[r++] = rune;
        }
        return runes;
    }

    static String runeToString(int r) {
        char c = (char)r;
        return r == c ? String.valueOf(c) : new String(Character.toChars(c));
    }

    static int[] subarray(int[] array, int start, int end) {
        int[] r = new int[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    static byte[] subarray(byte[] array, int start, int end) {
        byte[] r = new byte[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    static int indexOf(byte[] source, byte[] target, int fromIndex) {
        if (fromIndex >= source.length) {
            return target.length == 0 ? source.length : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (target.length == 0) {
            return fromIndex;
        }
        byte first = target[0];
        int max = source.length - target.length;
        for (int i = fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    static boolean isWordRune(int r) {
        return 65 <= r && r <= 90 || 97 <= r && r <= 122 || 48 <= r && r <= 57 || r == 95;
    }

    static int emptyOpContext(int r1, int r2) {
        int op = 0;
        if (r1 < 0) {
            op |= 5;
        }
        if (r1 == 10) {
            op |= 1;
        }
        if (r2 < 0) {
            op |= 0xA;
        }
        if (r2 == 10) {
            op |= 2;
        }
        op = Utils.isWordRune(r1) != Utils.isWordRune(r2) ? (op |= 0x10) : (op |= 0x20);
        return op;
    }

    private Utils() {
    }
}

