/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.SettableApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.BidiStreamingCallable;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BidiResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BidiWriteCtx;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferedWritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteStringStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ChunkSegmenter;
import net.snowflake.client.jdbc.internal.google.cloud.storage.DefaultBufferedWritableByteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GapicBidiUnbufferedWritableByteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Hasher;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Retrying;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageByteChannels;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnbufferedWritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.storage.v2.BidiWriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.BidiWriteObjectResponse;

final class GapicBidiWritableByteChannelSessionBuilder {
    private final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write;
    private Hasher hasher;
    private ByteStringStrategy byteStringStrategy;

    GapicBidiWritableByteChannelSessionBuilder(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write) {
        this.write = write;
        this.hasher = Hasher.noop();
        this.byteStringStrategy = ByteStringStrategy.copy();
    }

    GapicBidiWritableByteChannelSessionBuilder setHasher(Hasher hasher) {
        this.hasher = Objects.requireNonNull(hasher, "hasher must be non null");
        return this;
    }

    GapicBidiWritableByteChannelSessionBuilder setByteStringStrategy(ByteStringStrategy byteStringStrategy) {
        this.byteStringStrategy = Objects.requireNonNull(byteStringStrategy, "byteStringStrategy must be non null");
        return this;
    }

    ResumableUploadBuilder resumable() {
        return new ResumableUploadBuilder();
    }

    final class ResumableUploadBuilder {
        private Retrying.RetryingDependencies deps = Retrying.RetryingDependencies.attemptOnce();
        private ResultRetryAlgorithm<?> alg = Retrying.neverRetry();

        ResumableUploadBuilder() {
        }

        ResumableUploadBuilder withRetryConfig(Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg) {
            this.deps = Objects.requireNonNull(deps, "deps must be non null");
            this.alg = Objects.requireNonNull(alg, "alg must be non null");
            return this;
        }

        BufferedResumableUploadBuilder buffered(ByteBuffer byteBuffer) {
            return this.buffered(BufferHandle.handleOf(byteBuffer));
        }

        BufferedResumableUploadBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedResumableUploadBuilder(bufferHandle);
        }

        final class BufferedResumableUploadBuilder {
            private final BufferHandle bufferHandle;
            private ApiFuture<BidiResumableWrite> start;

            BufferedResumableUploadBuilder(BufferHandle bufferHandle) {
                this.bufferHandle = bufferHandle;
            }

            BufferedResumableUploadBuilder setStartAsync(ApiFuture<BidiResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            BufferedWritableByteChannelSession<BidiWriteObjectResponse> build() {
                ByteStringStrategy boundStrategy = GapicBidiWritableByteChannelSessionBuilder.this.byteStringStrategy;
                Hasher boundHasher = GapicBidiWritableByteChannelSessionBuilder.this.hasher;
                return new ChannelSession.BufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), ((BiFunction<BidiResumableWrite, SettableApiFuture, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel>)(start, resultFuture) -> new GapicBidiUnbufferedWritableByteChannel(GapicBidiWritableByteChannelSessionBuilder.this.write, ResumableUploadBuilder.this.deps, ResumableUploadBuilder.this.alg, (SettableApiFuture<BidiWriteObjectResponse>)resultFuture, new ChunkSegmenter(boundHasher, boundStrategy, 0x200000), new BidiWriteCtx<BidiResumableWrite>((BidiResumableWrite)start), Retrying::newCallContext)).andThen(c -> new DefaultBufferedWritableByteChannel(this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }
    }
}

