/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.StorageObject;
import net.snowflake.client.jdbc.internal.google.cloud.ReadChannel;
import net.snowflake.client.jdbc.internal.google.cloud.RestorableState;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ApiaryUnbufferedReadableByteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BaseStorageReadChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpClientContext;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpDownloadSessionBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpRetryAlgorithmManager;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpStorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.LazyReadChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ReadableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableMedia;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.StorageRpc;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;

final class BlobReadChannelV2
extends BaseStorageReadChannel<StorageObject> {
    private final StorageObject storageObject;
    private final Map<StorageRpc.Option, ?> opts;
    private final BlobReadChannelContext blobReadChannelContext;
    private final boolean autoGzipDecompression;

    BlobReadChannelV2(StorageObject storageObject, Map<StorageRpc.Option, ?> opts, BlobReadChannelContext blobReadChannelContext) {
        super(Conversions.json().blobInfo());
        this.storageObject = storageObject;
        this.opts = opts;
        this.blobReadChannelContext = blobReadChannelContext;
        this.autoGzipDecompression = Boolean.FALSE.equals(opts.get((Object)StorageRpc.Option.RETURN_RAW_INPUT_STREAM));
    }

    @Override
    public RestorableState<ReadChannel> capture() {
        this.lock.lock();
        try {
            ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest apiaryReadRequest = this.getApiaryReadRequest();
            BlobReadChannelV2State blobReadChannelV2State = new BlobReadChannelV2State(apiaryReadRequest, this.blobReadChannelContext.getStorageOptions(), this.getChunkSize());
            return blobReadChannelV2State;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected LazyReadChannel<?, StorageObject> newLazyReadChannel() {
        return new LazyReadChannel(() -> {
            HttpDownloadSessionBuilder.ReadableByteChannelSessionBuilder b = ResumableMedia.http().read().byteChannel(this.blobReadChannelContext).setAutoGzipDecompression(this.autoGzipDecompression);
            BufferHandle bufferHandle = this.getBufferHandle();
            ReadableByteChannelSession session = bufferHandle.capacity() > 0 ? b.buffered(bufferHandle).setApiaryReadRequest(this.getApiaryReadRequest()).build() : b.unbuffered().setApiaryReadRequest(this.getApiaryReadRequest()).build();
            return session;
        });
    }

    private ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest getApiaryReadRequest() {
        StorageObject object = this.getResolvedObject() != null ? (StorageObject)this.getResolvedObject() : this.storageObject;
        return new ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest(object, this.opts, this.getByteRangeSpec());
    }

    static final class BlobReadChannelContext {
        private final HttpStorageOptions storageOptions;
        private final HttpRetryAlgorithmManager retryAlgorithmManager;
        private final HttpClientContext httpClientContext;
        private final net.snowflake.client.jdbc.internal.google.api.services.storage.Storage apiaryClient;

        private BlobReadChannelContext(HttpStorageOptions storageOptions, HttpRetryAlgorithmManager retryAlgorithmManager, HttpClientContext httpClientContext, net.snowflake.client.jdbc.internal.google.api.services.storage.Storage apiaryClient) {
            this.storageOptions = storageOptions;
            this.retryAlgorithmManager = retryAlgorithmManager;
            this.httpClientContext = httpClientContext;
            this.apiaryClient = apiaryClient;
        }

        public HttpStorageOptions getStorageOptions() {
            return this.storageOptions;
        }

        public HttpRetryAlgorithmManager getRetryAlgorithmManager() {
            return this.retryAlgorithmManager;
        }

        public HttpClientContext getHttpClientContext() {
            return this.httpClientContext;
        }

        public net.snowflake.client.jdbc.internal.google.api.services.storage.Storage getApiaryClient() {
            return this.apiaryClient;
        }

        static BlobReadChannelContext from(HttpStorageOptions options) {
            return new BlobReadChannelContext(options, options.getRetryAlgorithmManager(), HttpClientContext.from(options.getStorageRpcV1()), options.getStorageRpcV1().getStorage());
        }

        static BlobReadChannelContext from(Storage s2) {
            StorageOptions options = (StorageOptions)s2.getOptions();
            if (options instanceof HttpStorageOptions) {
                HttpStorageOptions httpStorageOptions = (HttpStorageOptions)options;
                return BlobReadChannelContext.from(httpStorageOptions);
            }
            throw new IllegalArgumentException("Only HttpStorageOptions based instance supported");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobReadChannelContext)) {
                return false;
            }
            BlobReadChannelContext that = (BlobReadChannelContext)o;
            return Objects.equals(this.storageOptions, that.storageOptions) && Objects.equals(this.retryAlgorithmManager, that.retryAlgorithmManager);
        }

        public int hashCode() {
            return Objects.hash(this.storageOptions, this.retryAlgorithmManager);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("storageOptions", this.storageOptions).toString();
        }
    }

    static final class BlobReadChannelV2State
    implements RestorableState<ReadChannel>,
    Serializable {
        private static final long serialVersionUID = -7595661593080505431L;
        private final ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request;
        private final HttpStorageOptions options;
        private final Integer chunkSize;

        private BlobReadChannelV2State(ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request, HttpStorageOptions options, Integer chunkSize) {
            this.request = request;
            this.options = options;
            this.chunkSize = chunkSize;
        }

        @Override
        public ReadChannel restore() {
            BlobReadChannelV2 channel = new BlobReadChannelV2(this.request.getObject(), this.request.getOptions(), BlobReadChannelContext.from(this.options));
            channel.setByteRangeSpec(this.request.getByteRangeSpec());
            if (this.chunkSize != null) {
                channel.setChunkSize(this.chunkSize);
            }
            return channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobReadChannelV2State)) {
                return false;
            }
            BlobReadChannelV2State that = (BlobReadChannelV2State)o;
            return Objects.equals(this.request, that.request) && Objects.equals(this.options, that.options) && Objects.equals(this.chunkSize, that.chunkSize);
        }

        public int hashCode() {
            return Objects.hash(this.request, this.options, this.chunkSize);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("request", this.request).add("options", this.options).add("chunkSize", this.chunkSize).toString();
        }
    }
}

