/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcCallContext;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BidiResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteStringStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.DefaultBlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GrpcStorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Hasher;
import net.snowflake.client.jdbc.internal.google.cloud.storage.LazyWriteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableMedia;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageInternal;
import net.snowflake.client.jdbc.internal.google.cloud.storage.TransportCompatibility;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnifiedOpts;
import net.snowflake.client.jdbc.internal.google.cloud.storage.WritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.storage.v2.BidiWriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.BidiWriteObjectResponse;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
@Immutable
public final class BidiBlobWriteSessionConfig
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.GrpcCompatible {
    private static final long serialVersionUID = -903533790705476197L;
    private final int bufferSize;

    @InternalApi
    BidiBlobWriteSessionConfig(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BidiBlobWriteSessionConfig)) {
            return false;
        }
        BidiBlobWriteSessionConfig that = (BidiBlobWriteSessionConfig)o;
        return this.bufferSize == that.bufferSize;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.bufferSize);
    }

    @Override
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        return new Factory(this.bufferSize);
    }

    @BetaApi
    public BidiBlobWriteSessionConfig withBufferSize(int bufferSize) {
        Preconditions.checkArgument(bufferSize >= 262144, "bufferSize must be >= %d", 262144);
        return new BidiBlobWriteSessionConfig(bufferSize);
    }

    @InternalApi
    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private static final Conversions.Decoder<BidiWriteObjectResponse, BlobInfo> WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER = Conversions.grpc().blobInfo().compose(BidiWriteObjectResponse::getResource);
        private final int bufferSize;

        private Factory(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s2, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            if (s2 instanceof GrpcStorageImpl) {
                return new DefaultBlobWriteSessionConfig.DecoratedWritableByteChannelSession(new DefaultBlobWriteSessionConfig.LazySession(new LazyWriteChannel(() -> {
                    GrpcStorageImpl grpc = (GrpcStorageImpl)s2;
                    GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
                    BidiWriteObjectRequest req = grpc.getBidiWriteObjectRequest(info, opts);
                    ApiFuture<BidiResumableWrite> startResumableWrite = grpc.startResumableWrite(grpcCallContext, req, opts);
                    return ResumableMedia.gapic().write().bidiByteChannel(grpc.storageClient.bidiWriteObjectCallable()).setHasher(Hasher.noop()).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(grpc.getOptions(), grpc.retryAlgorithmManager.idempotent()).buffered(BufferHandle.allocate(this.bufferSize)).setStartAsync(startResumableWrite).build();
                })), WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER);
            }
            throw new IllegalStateException("Unknown Storage implementation: " + s2.getClass().getName());
        }
    }
}

