/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.retrying;

import java.time.Duration;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetrySettings;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.TimedAttemptSettings;

final class AutoValue_TimedAttemptSettings
extends TimedAttemptSettings {
    private final RetrySettings globalSettings;
    private final Duration retryDelayDuration;
    private final Duration rpcTimeoutDuration;
    private final Duration randomizedRetryDelayDuration;
    private final int attemptCount;
    private final int overallAttemptCount;
    private final long firstAttemptStartTimeNanos;

    private AutoValue_TimedAttemptSettings(RetrySettings globalSettings, Duration retryDelayDuration, Duration rpcTimeoutDuration, Duration randomizedRetryDelayDuration, int attemptCount, int overallAttemptCount, long firstAttemptStartTimeNanos) {
        this.globalSettings = globalSettings;
        this.retryDelayDuration = retryDelayDuration;
        this.rpcTimeoutDuration = rpcTimeoutDuration;
        this.randomizedRetryDelayDuration = randomizedRetryDelayDuration;
        this.attemptCount = attemptCount;
        this.overallAttemptCount = overallAttemptCount;
        this.firstAttemptStartTimeNanos = firstAttemptStartTimeNanos;
    }

    @Override
    public RetrySettings getGlobalSettings() {
        return this.globalSettings;
    }

    @Override
    public Duration getRetryDelayDuration() {
        return this.retryDelayDuration;
    }

    @Override
    public Duration getRpcTimeoutDuration() {
        return this.rpcTimeoutDuration;
    }

    @Override
    public Duration getRandomizedRetryDelayDuration() {
        return this.randomizedRetryDelayDuration;
    }

    @Override
    public int getAttemptCount() {
        return this.attemptCount;
    }

    @Override
    public int getOverallAttemptCount() {
        return this.overallAttemptCount;
    }

    @Override
    public long getFirstAttemptStartTimeNanos() {
        return this.firstAttemptStartTimeNanos;
    }

    public String toString() {
        return "TimedAttemptSettings{globalSettings=" + this.globalSettings + ", retryDelayDuration=" + this.retryDelayDuration + ", rpcTimeoutDuration=" + this.rpcTimeoutDuration + ", randomizedRetryDelayDuration=" + this.randomizedRetryDelayDuration + ", attemptCount=" + this.attemptCount + ", overallAttemptCount=" + this.overallAttemptCount + ", firstAttemptStartTimeNanos=" + this.firstAttemptStartTimeNanos + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TimedAttemptSettings) {
            TimedAttemptSettings that = (TimedAttemptSettings)o;
            return this.globalSettings.equals(that.getGlobalSettings()) && this.retryDelayDuration.equals(that.getRetryDelayDuration()) && this.rpcTimeoutDuration.equals(that.getRpcTimeoutDuration()) && this.randomizedRetryDelayDuration.equals(that.getRandomizedRetryDelayDuration()) && this.attemptCount == that.getAttemptCount() && this.overallAttemptCount == that.getOverallAttemptCount() && this.firstAttemptStartTimeNanos == that.getFirstAttemptStartTimeNanos();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.globalSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.retryDelayDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.rpcTimeoutDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.randomizedRetryDelayDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.attemptCount;
        h$ *= 1000003;
        h$ ^= this.overallAttemptCount;
        h$ *= 1000003;
        return h$ ^= (int)(this.firstAttemptStartTimeNanos >>> 32 ^ this.firstAttemptStartTimeNanos);
    }

    @Override
    public TimedAttemptSettings.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TimedAttemptSettings.Builder {
        private RetrySettings globalSettings;
        private Duration retryDelayDuration;
        private Duration rpcTimeoutDuration;
        private Duration randomizedRetryDelayDuration;
        private int attemptCount;
        private int overallAttemptCount;
        private long firstAttemptStartTimeNanos;
        private byte set$0;

        Builder() {
        }

        Builder(TimedAttemptSettings source) {
            this.globalSettings = source.getGlobalSettings();
            this.retryDelayDuration = source.getRetryDelayDuration();
            this.rpcTimeoutDuration = source.getRpcTimeoutDuration();
            this.randomizedRetryDelayDuration = source.getRandomizedRetryDelayDuration();
            this.attemptCount = source.getAttemptCount();
            this.overallAttemptCount = source.getOverallAttemptCount();
            this.firstAttemptStartTimeNanos = source.getFirstAttemptStartTimeNanos();
            this.set$0 = (byte)7;
        }

        @Override
        public TimedAttemptSettings.Builder setGlobalSettings(RetrySettings globalSettings) {
            if (globalSettings == null) {
                throw new NullPointerException("Null globalSettings");
            }
            this.globalSettings = globalSettings;
            return this;
        }

        @Override
        public TimedAttemptSettings.Builder setRetryDelayDuration(Duration retryDelayDuration) {
            if (retryDelayDuration == null) {
                throw new NullPointerException("Null retryDelayDuration");
            }
            this.retryDelayDuration = retryDelayDuration;
            return this;
        }

        @Override
        public TimedAttemptSettings.Builder setRpcTimeoutDuration(Duration rpcTimeoutDuration) {
            if (rpcTimeoutDuration == null) {
                throw new NullPointerException("Null rpcTimeoutDuration");
            }
            this.rpcTimeoutDuration = rpcTimeoutDuration;
            return this;
        }

        @Override
        public TimedAttemptSettings.Builder setRandomizedRetryDelayDuration(Duration randomizedRetryDelayDuration) {
            if (randomizedRetryDelayDuration == null) {
                throw new NullPointerException("Null randomizedRetryDelayDuration");
            }
            this.randomizedRetryDelayDuration = randomizedRetryDelayDuration;
            return this;
        }

        @Override
        public TimedAttemptSettings.Builder setAttemptCount(int attemptCount) {
            this.attemptCount = attemptCount;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public TimedAttemptSettings.Builder setOverallAttemptCount(int overallAttemptCount) {
            this.overallAttemptCount = overallAttemptCount;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public TimedAttemptSettings.Builder setFirstAttemptStartTimeNanos(long firstAttemptStartTimeNanos) {
            this.firstAttemptStartTimeNanos = firstAttemptStartTimeNanos;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public TimedAttemptSettings build() {
            if (this.set$0 != 7 || this.globalSettings == null || this.retryDelayDuration == null || this.rpcTimeoutDuration == null || this.randomizedRetryDelayDuration == null) {
                StringBuilder missing = new StringBuilder();
                if (this.globalSettings == null) {
                    missing.append(" globalSettings");
                }
                if (this.retryDelayDuration == null) {
                    missing.append(" retryDelayDuration");
                }
                if (this.rpcTimeoutDuration == null) {
                    missing.append(" rpcTimeoutDuration");
                }
                if (this.randomizedRetryDelayDuration == null) {
                    missing.append(" randomizedRetryDelayDuration");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" attemptCount");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" overallAttemptCount");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" firstAttemptStartTimeNanos");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TimedAttemptSettings(this.globalSettings, this.retryDelayDuration, this.rpcTimeoutDuration, this.randomizedRetryDelayDuration, this.attemptCount, this.overallAttemptCount, this.firstAttemptStartTimeNanos);
        }
    }
}

