/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.FieldsExtractor;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpRequestFormatter;
import net.snowflake.client.jdbc.internal.google.api.pathtemplate.PathTemplate;
import net.snowflake.client.jdbc.internal.google.protobuf.Message;

public class ProtoMessageRequestFormatter<RequestT extends Message>
implements HttpRequestFormatter<RequestT> {
    private final FieldsExtractor<RequestT, String> requestBodyExtractor;
    private final FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor;
    private final String rawPath;
    private final PathTemplate pathTemplate;
    private final FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor;
    private final List<String> additionalRawPaths;
    private final List<PathTemplate> additionalPathTemplates;

    private ProtoMessageRequestFormatter(FieldsExtractor<RequestT, String> requestBodyExtractor, FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor, String rawPath, PathTemplate pathTemplate, FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor, List<String> additionalRawPaths, List<PathTemplate> additionalPathTemplates) {
        this.requestBodyExtractor = requestBodyExtractor;
        this.queryParamsExtractor = queryParamsExtractor;
        this.rawPath = rawPath;
        this.pathTemplate = pathTemplate;
        this.pathVarsExtractor = pathVarsExtractor;
        this.additionalRawPaths = additionalRawPaths;
        this.additionalPathTemplates = additionalPathTemplates;
    }

    public static <RequestT extends Message> Builder<RequestT> newBuilder() {
        return new Builder().setAdditionalPaths(new String[0]);
    }

    public Builder<RequestT> toBuilder() {
        return new Builder<RequestT>().setPath(this.rawPath, this.pathVarsExtractor).setAdditionalPaths(this.additionalRawPaths.toArray(new String[0])).setQueryParamsExtractor(this.queryParamsExtractor).setRequestBodyExtractor(this.requestBodyExtractor);
    }

    @Override
    public Map<String, List<String>> getQueryParamNames(RequestT apiMessage) {
        return this.queryParamsExtractor.extract(apiMessage);
    }

    @Override
    public String getRequestBody(RequestT apiMessage) {
        return this.requestBodyExtractor.extract(apiMessage);
    }

    @Override
    public String getPath(RequestT apiMessage) {
        Map<String, String> pathVarsMap = this.pathVarsExtractor.extract(apiMessage);
        String path = this.pathTemplate.instantiate(pathVarsMap);
        if (this.pathTemplate.matches(path)) {
            return path;
        }
        for (PathTemplate additionalPathTemplate : this.additionalPathTemplates) {
            String additionalPath;
            if (!additionalPathTemplate.matches(additionalPath = additionalPathTemplate.instantiate(pathVarsMap))) continue;
            return additionalPath;
        }
        return path;
    }

    @Override
    public List<PathTemplate> getAdditionalPathTemplates() {
        return this.additionalPathTemplates;
    }

    @Override
    public PathTemplate getPathTemplate() {
        return this.pathTemplate;
    }

    public static class Builder<RequestT extends Message> {
        private FieldsExtractor<RequestT, String> requestBodyExtractor;
        private FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor;
        private String rawPath;
        private FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor;
        private List<String> rawAdditionalPaths;

        public Builder<RequestT> setRequestBodyExtractor(FieldsExtractor<RequestT, String> requestBodyExtractor) {
            this.requestBodyExtractor = requestBodyExtractor;
            return this;
        }

        public Builder<RequestT> setQueryParamsExtractor(FieldsExtractor<RequestT, Map<String, List<String>>> queryParamsExtractor) {
            this.queryParamsExtractor = queryParamsExtractor;
            return this;
        }

        public Builder<RequestT> setPath(String rawPath, FieldsExtractor<RequestT, Map<String, String>> pathVarsExtractor) {
            this.rawPath = rawPath;
            this.pathVarsExtractor = pathVarsExtractor;
            return this;
        }

        public Builder<RequestT> setAdditionalPaths(String ... rawAdditionalPaths) {
            this.rawAdditionalPaths = Arrays.asList(rawAdditionalPaths);
            return this;
        }

        @InternalApi
        public Builder<RequestT> updateRawPath(String rawPath) {
            this.rawPath = rawPath;
            return this;
        }

        @InternalApi
        public Builder<RequestT> updateRawPath(String target, String replacement) {
            this.rawPath = this.rawPath.replace(target, replacement);
            return this;
        }

        public ProtoMessageRequestFormatter<RequestT> build() {
            return new ProtoMessageRequestFormatter(this.requestBodyExtractor, this.queryParamsExtractor, this.rawPath, PathTemplate.create(this.rawPath), this.pathVarsExtractor, this.rawAdditionalPaths, this.rawAdditionalPaths.stream().map(PathTemplate::create).collect(Collectors.toList()));
        }
    }
}

