/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.grpc;

import java.util.Set;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcCallSettings;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcDirectBidiStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcDirectCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcDirectClientStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcDirectServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcExceptionBidiStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcExceptionCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcExceptionClientStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcExceptionServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcServerStreamingRequestParamCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcUnaryRequestParamCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.BidiStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ClientStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.StatusCode;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;

@InternalApi(value="For internal use by google-cloud-java clients only")
public class GrpcRawCallableFactory {
    private GrpcRawCallableFactory() {
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, Set<StatusCode.Code> retryableCodes) {
        UnaryCallable callable = new GrpcDirectCallable<RequestT, ResponseT>(grpcCallSettings.getMethodDescriptor(), grpcCallSettings.shouldAwaitTrailers());
        if (grpcCallSettings.getParamsExtractor() != null) {
            callable = new GrpcUnaryRequestParamCallable<RequestT, ResponseT>(callable, grpcCallSettings.getParamsExtractor());
        }
        return new GrpcExceptionCallable<RequestT, ResponseT>(callable, retryableCodes);
    }

    public static <RequestT, ResponseT> BidiStreamingCallable<RequestT, ResponseT> createBidiStreamingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, Set<StatusCode.Code> retryableCodes) {
        GrpcDirectBidiStreamingCallable<RequestT, ResponseT> callable = new GrpcDirectBidiStreamingCallable<RequestT, ResponseT>(grpcCallSettings.getMethodDescriptor());
        return new GrpcExceptionBidiStreamingCallable<RequestT, ResponseT>(callable, retryableCodes);
    }

    public static <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> createServerStreamingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, Set<StatusCode.Code> retryableCodes) {
        ServerStreamingCallable callable = new GrpcDirectServerStreamingCallable<RequestT, ResponseT>(grpcCallSettings.getMethodDescriptor());
        if (grpcCallSettings.getParamsExtractor() != null) {
            callable = new GrpcServerStreamingRequestParamCallable<RequestT, ResponseT>(callable, grpcCallSettings.getParamsExtractor());
        }
        return new GrpcExceptionServerStreamingCallable<RequestT, ResponseT>(callable, retryableCodes);
    }

    public static <RequestT, ResponseT> ClientStreamingCallable<RequestT, ResponseT> createClientStreamingCallable(GrpcCallSettings<RequestT, ResponseT> grpcCallSettings, Set<StatusCode.Code> retryableCodes) {
        GrpcDirectClientStreamingCallable<RequestT, ResponseT> callable = new GrpcDirectClientStreamingCallable<RequestT, ResponseT>(grpcCallSettings.getMethodDescriptor());
        return new GrpcExceptionClientStreamingCallable<RequestT, ResponseT>(callable, retryableCodes);
    }
}

