/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.SecurityContext;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.BadJWTException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Issuer;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class LogoutTokenClaimsVerifier
extends DefaultJWTClaimsVerifier {
    private final Issuer expectedIssuer;
    private final ClientID expectedClientID;

    public LogoutTokenClaimsVerifier(Issuer issuer, ClientID clientID) {
        super(Collections.singleton(clientID.getValue()), new JWTClaimsSet.Builder().issuer(issuer.getValue()).build(), new HashSet<String>(Arrays.asList("iat", "exp", "jti", "events")), Collections.singleton("nonce"));
        this.expectedIssuer = issuer;
        this.expectedClientID = clientID;
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.expectedClientID;
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, SecurityContext ctx) throws BadJWTException {
        super.verify(claimsSet, ctx);
        try {
            Map<String, Object> events = claimsSet.getJSONObjectClaim("events");
            if (events == null) {
                throw new BadJWTException("Missing / invalid JWT events (events) claim");
            }
            if (JSONObjectUtils.getJSONObject(events, "http://schemas.openid.net/event/backchannel-logout") == null) {
                throw new BadJWTException("Missing event type, required http://schemas.openid.net/event/backchannel-logout");
            }
        }
        catch (ParseException e) {
            throw new BadJWTException("Invalid JWT events (events) claim", e);
        }
        try {
            if (claimsSet.getSubject() == null && claimsSet.getStringClaim("sid") == null) {
                throw new BadJWTException("Missing subject (sub) and / or session ID (sid) claim(s)");
            }
        }
        catch (ParseException e) {
            throw new BadJWTException("Invalid session ID (sid) claim");
        }
    }
}

