/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Message;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.ArrowBuf;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ReadChannel;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageMetadataResult;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageResult;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageSerializer;

public class MessageChannelReader
implements AutoCloseable {
    protected ReadChannel in;
    protected BufferAllocator allocator;

    public MessageChannelReader(ReadChannel in, BufferAllocator allocator) {
        this.in = in;
        this.allocator = allocator;
    }

    public MessageResult readNext() throws IOException {
        MessageMetadataResult result = MessageSerializer.readMessage(this.in);
        if (result == null) {
            return null;
        }
        Message message = result.getMessage();
        ArrowBuf bodyBuffer = null;
        if (result.messageHasBody()) {
            long bodyLength = result.getMessageBodyLength();
            bodyBuffer = MessageSerializer.readMessageBody(this.in, bodyLength, this.allocator);
        }
        return new MessageResult(message, bodyBuffer);
    }

    public long bytesRead() {
        return this.in.bytesRead();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

