/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Iterator;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummary;
import net.snowflake.client.jdbc.internal.google.api.gax.paging.Page;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Blob;

public class GcsObjectSummariesIterator
implements Iterator<StorageObjectSummary> {
    private final Iterator<Blob> blobIterator;

    public GcsObjectSummariesIterator(Page<Blob> blobs) {
        this.blobIterator = blobs.iterateAll().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.blobIterator.hasNext();
    }

    @Override
    public StorageObjectSummary next() {
        Blob blob = this.blobIterator.next();
        return StorageObjectSummary.createFromGcsBlob(blob);
    }
}

