/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.sql.Date;
import java.util.TimeZone;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class StringConverter {
    private static final SFLogger logger = SFLoggerFactory.getLogger(StringConverter.class);
    private final TimeZone sessionTimeZone;
    private final SFBinaryFormat binaryFormatter;
    private final SnowflakeDateTimeFormat dateFormatter;
    private final SnowflakeDateTimeFormat timeFormatter;
    private final SnowflakeDateTimeFormat timestampNTZFormatter;
    private final SnowflakeDateTimeFormat timestampLTZFormatter;
    private final SnowflakeDateTimeFormat timestampTZFormatter;
    private final long resultVersion;
    private final SFBaseSession session;
    private final Converters converters;

    public StringConverter(TimeZone sessionTimeZone, SFBinaryFormat binaryFormatter, SnowflakeDateTimeFormat dateFormatter, SnowflakeDateTimeFormat timeFormatter, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter, long resultVersion, SFBaseSession session, Converters converters) {
        this.sessionTimeZone = sessionTimeZone;
        this.binaryFormatter = binaryFormatter;
        this.dateFormatter = dateFormatter;
        this.timeFormatter = timeFormatter;
        this.timestampNTZFormatter = timestampNTZFormatter;
        this.timestampLTZFormatter = timestampLTZFormatter;
        this.timestampTZFormatter = timestampTZFormatter;
        this.resultVersion = resultVersion;
        this.session = session;
        this.converters = converters;
    }

    public String getString(Object obj, int columnType, int columnSubType, int scale) throws SFException {
        if (obj == null) {
            return null;
        }
        switch (columnType) {
            case 16: {
                return ResultUtil.getBooleanAsString(ResultUtil.getBoolean(obj.toString()));
            }
            case 93: 
            case 50000: 
            case 50001: {
                return this.timestampToString(obj, columnType, columnSubType, scale);
            }
            case 91: {
                return this.dateToString(obj, columnType, columnSubType, scale);
            }
            case 92: {
                return this.timeToString(obj, scale);
            }
            case -2: {
                return this.binaryToString(obj, columnType, columnSubType, scale);
            }
        }
        return obj.toString();
    }

    private String timestampToString(Object obj, int columnType, int columnSubType, int scale) throws SFException {
        SFTimestamp sfTS = ResultUtil.getSFTimestamp(obj.toString(), scale, columnSubType, this.resultVersion, this.sessionTimeZone, this.session);
        String timestampStr = ResultUtil.getSFTimestampAsString(sfTS, columnType, scale, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
        Object[] objectArray = new Object[2];
        objectArray[0] = obj::toString;
        objectArray[1] = timestampStr;
        logger.debug("Converting timestamp to string from: {} to: {}", objectArray);
        return timestampStr;
    }

    private String dateToString(Object obj, int columnType, int columnSubType, int scale) throws SFException {
        Date date = this.converters.getDateTimeConverter().getDate(obj, columnType, columnSubType, TimeZone.getDefault(), scale);
        if (this.dateFormatter == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "missing date formatter");
        }
        String dateStr = ResultUtil.getDateAsString(date, this.dateFormatter);
        Object[] objectArray = new Object[2];
        objectArray[0] = obj::toString;
        objectArray[1] = dateStr;
        logger.debug("Converting date to string from: {} to: {}", objectArray);
        return dateStr;
    }

    private String timeToString(Object obj, int scale) throws SFException {
        SFTime sfTime = ResultUtil.getSFTime(obj.toString(), scale, this.session);
        if (this.timeFormatter == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "missing time formatter");
        }
        String timeStr = ResultUtil.getSFTimeAsString(sfTime, scale, this.timeFormatter);
        Object[] objectArray = new Object[2];
        objectArray[0] = obj::toString;
        objectArray[1] = timeStr;
        logger.debug("Converting time to string from: {} to: {}", objectArray);
        return timeStr;
    }

    private String binaryToString(Object obj, int columnType, int columnSubType, int scale) throws SFException {
        if (this.binaryFormatter == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "missing binary formatter");
        }
        if (this.binaryFormatter == SFBinaryFormat.HEX) {
            return obj.toString();
        }
        SFBinary sfb = new SFBinary(this.converters.getBytesConverter().getBytes(obj, columnType, columnSubType, scale));
        return this.binaryFormatter.format(sfb);
    }
}

