/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.RedshiftProperty;
import java.sql.SQLWarning;
import java.util.Properties;

public class RedshiftWarningWrapper {
    private SQLWarning firstWarning;
    private SQLWarning lastWarning;
    private int maxWarningCount;
    private int count;
    private SQLWarning finalWarning;

    public RedshiftWarningWrapper(SQLWarning warning, Properties props) {
        String warningCountStr = props != null ? RedshiftProperty.MAX_WARNING_COUNT.get(props) : RedshiftProperty.MAX_WARNING_COUNT.getDefaultValue();
        try {
            this.maxWarningCount = Integer.parseInt(warningCountStr);
        }
        catch (NumberFormatException e) {
            this.maxWarningCount = Integer.parseInt(RedshiftProperty.MAX_WARNING_COUNT.getDefaultValue());
        }
        if (this.maxWarningCount >= 0) {
            this.firstWarning = null;
            this.lastWarning = null;
            this.count = 0;
            this.finalWarning = new SQLWarning("[Redshift JDBC Driver] Additional warnings are truncated when the number of all warnings exceeds " + this.maxWarningCount + ". The maximum number of warnings can be set using \"" + RedshiftProperty.MAX_WARNING_COUNT.getName() + "\" through driver connection option.", "00000", 0);
        }
        this.appendWarning(warning);
    }

    private int getWarningChainSize(SQLWarning head) {
        int chainSize = 0;
        for (SQLWarning next = head; next != null; next = next.getNextWarning()) {
            ++chainSize;
        }
        return chainSize;
    }

    private void addFinalWarning() {
        if (this.firstWarning == null) {
            this.firstWarning = this.finalWarning;
        } else {
            this.lastWarning.setNextWarning(this.finalWarning);
        }
        this.lastWarning = this.finalWarning;
        this.count = this.maxWarningCount;
    }

    public void appendWarning(SQLWarning sqlWarning) {
        if (sqlWarning == null || this.maxWarningCount >= 0 && this.count >= this.maxWarningCount) {
            return;
        }
        int newWarningSize = this.getWarningChainSize(sqlWarning);
        if (this.count + newWarningSize < this.maxWarningCount || this.maxWarningCount < 0) {
            if (this.firstWarning == null) {
                this.firstWarning = sqlWarning;
            } else {
                this.lastWarning.setNextWarning(sqlWarning);
            }
            for (SQLWarning tmpWarning = this.lastWarning = sqlWarning; tmpWarning != null; tmpWarning = tmpWarning.getNextWarning()) {
                this.lastWarning = tmpWarning;
            }
            this.count += newWarningSize;
        } else {
            this.addFinalWarning();
        }
    }

    public SQLWarning getFirstWarning() {
        return this.firstWarning;
    }

    public void clearWarning() {
        this.firstWarning = null;
        this.lastWarning = null;
        this.count = 0;
    }
}

