/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.geometric;

import com.amazon.redshift.geometric.RedshiftPoint;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftBinaryObject;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftBox
extends RedshiftObject
implements RedshiftBinaryObject,
Serializable,
Cloneable {
    public RedshiftPoint[] point = new RedshiftPoint[2];

    public RedshiftBox(double x1, double y1, double x2, double y2) {
        this();
        this.point[0] = new RedshiftPoint(x1, y1);
        this.point[1] = new RedshiftPoint(x2, y2);
    }

    public RedshiftBox(RedshiftPoint p1, RedshiftPoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public RedshiftBox(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public RedshiftBox() {
        this.setType("box");
    }

    @Override
    public void setValue(String value) throws SQLException {
        RedshiftTokenizer t = new RedshiftTokenizer(value, ',');
        if (t.getSize() != 2) {
            throw new RedshiftException(GT.tr("Conversion to type {0} failed: {1}.", this.type, value), RedshiftState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new RedshiftPoint(t.getToken(0));
        this.point[1] = new RedshiftPoint(t.getToken(1));
    }

    @Override
    public void setByteValue(byte[] b, int offset) {
        this.point[0] = new RedshiftPoint();
        this.point[0].setByteValue(b, offset);
        this.point[1] = new RedshiftPoint();
        this.point[1].setByteValue(b, offset + this.point[0].lengthInBytes());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedshiftBox) {
            RedshiftBox p = (RedshiftBox)obj;
            if (p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1])) {
                return true;
            }
            if (p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0])) {
                return true;
            }
            if (p.point[0].x == this.point[0].x && p.point[0].y == this.point[1].y && p.point[1].x == this.point[1].x && p.point[1].y == this.point[0].y) {
                return true;
            }
            if (p.point[0].x == this.point[1].x && p.point[0].y == this.point[0].y && p.point[1].x == this.point[0].x && p.point[1].y == this.point[1].y) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RedshiftBox newRSbox = (RedshiftBox)super.clone();
        if (newRSbox.point != null) {
            newRSbox.point = (RedshiftPoint[])newRSbox.point.clone();
            for (int i = 0; i < newRSbox.point.length; ++i) {
                if (newRSbox.point[i] == null) continue;
                newRSbox.point[i] = (RedshiftPoint)newRSbox.point[i].clone();
            }
        }
        return newRSbox;
    }

    @Override
    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }

    @Override
    public int lengthInBytes() {
        return this.point[0].lengthInBytes() + this.point[1].lengthInBytes();
    }

    @Override
    public void toBytes(byte[] bytes, int offset) {
        this.point[0].toBytes(bytes, offset);
        this.point[1].toBytes(bytes, offset + this.point[0].lengthInBytes());
    }
}

