/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.QueryExecutor;
import com.amazon.redshift.core.ResultCursor;
import com.amazon.redshift.core.ResultHandlerBase;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Properties;

public class SetupQueryRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple run(QueryExecutor executor, String queryString, boolean wantResults) throws SQLException {
        Query query = executor.createSimpleQuery(queryString);
        SimpleResultHandler handler = new SimpleResultHandler();
        int flags = 1041;
        if (!wantResults) {
            flags |= 6;
        }
        try {
            executor.execute(query, null, handler, 0, 0, flags);
        }
        finally {
            query.close();
        }
        if (!wantResults) {
            return null;
        }
        List<Tuple> tuples = handler.getResults();
        if (tuples == null || tuples.size() != 1) {
            throw new RedshiftException(GT.tr("An unexpected result was returned by a query.", new Object[0]), RedshiftState.CONNECTION_UNABLE_TO_CONNECT);
        }
        return tuples.get(0);
    }

    private static class SimpleResultHandler
    extends ResultHandlerBase {
        private List<Tuple> tuples;

        SimpleResultHandler() {
            super(new Properties());
        }

        List<Tuple> getResults() {
            return this.tuples;
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) {
            this.tuples = tuples;
        }

        @Override
        public void handleWarning(SQLWarning warning) {
        }
    }
}

