/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.AbstractWithoutTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBTimestampField
extends AbstractWithoutTimeZoneField {
    FBTimestampField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getTimestamp();
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getTimestamp());
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.getDatatypeCoder().decodeTimestampCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    LocalDate getLocalDate() throws SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        return localDateTime != null ? localDateTime.toLocalDate() : null;
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Time(this.getDatatypeCoder().decodeTimestampCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    LocalTime getLocalTime() throws SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime();
        return localDateTime != null ? localDateTime.toLocalTime() : null;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimestampCalendar(this.getFieldData(), cal);
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeLocalDateTime(this.getFieldData());
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setTimestamp(this.fromString(value, Timestamp::valueOf));
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampCalendar(new Timestamp(value.getTime()), cal));
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampCalendar(new Timestamp(value.getTime()), cal));
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampCalendar(value, cal));
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeLocalDateTime(value));
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimestampRaw(this.getFieldData());
    }

    @Override
    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        if (this.setWhenNull(raw)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampRaw(raw));
    }
}

