/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.sql.ConverterArchive;
import oracle.sql.converter.JdbcCharacterConverters;

public abstract class CharacterConverterJDBC
implements JdbcCharacterConverters,
Serializable {
    static final long serialVersionUID = 5948085171100875165L;
    static final String CONVERTERNAMEPREFIX = "converter_xcharset/lx2";
    static final String CONVERTERIDPREFIX = "0000";
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int STORE_INCREMENT = 10;
    static final int INVALID_ORA_CHAR = -1;
    static final int FIRSTBSHIFT = 24;
    static final int SECONDBSHIFT = 16;
    static final int THIRDBSHIFT = 8;
    static final int UB2MASK = 65535;
    static final int UB4MASK = 65535;
    static final ConcurrentHashMap<String, CharacterConverterJDBC> m_converterStore;
    public int m_groupId;
    public int m_oracleId;
    public int[][] extraUnicodeToOracleMapping = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    @Override
    public int getGroupId() {
        return this.m_groupId;
    }

    @Override
    public int getOracleId() {
        return this.m_oracleId;
    }

    @Override
    public char[] getLeadingCodes() {
        return null;
    }

    public static JdbcCharacterConverters getInstance(int oracleId) {
        CharacterConverterJDBC charConverter = null;
        boolean storeIndex = false;
        boolean storeSize = false;
        String numStr = Integer.toHexString(oracleId);
        charConverter = m_converterStore.get(numStr);
        if (charConverter != null) {
            return charConverter;
        }
        ConverterArchive ca = new ConverterArchive();
        String charConvClassName = CONVERTERNAMEPREFIX + CONVERTERIDPREFIX.substring(0, 4 - numStr.length()) + numStr;
        charConverter = (CharacterConverterJDBC)ca.readObj(charConvClassName + ".glb");
        if (charConverter == null) {
            return null;
        }
        charConverter.buildUnicodeToOracleMapping();
        m_converterStore.putIfAbsent(numStr, charConverter);
        return charConverter;
    }

    protected void storeMappingRange(int ucsCodePt, Hashtable htable, Hashtable htable2) {
        char[] range;
        int l1Key = ucsCodePt >> 24 & 0xFF;
        int l2Key = ucsCodePt >> 16 & 0xFF;
        int l3Key = ucsCodePt >> 8 & 0xFF;
        int l4Key = ucsCodePt & 0xFF;
        Integer int1Key = l1Key;
        Integer int12Key = ucsCodePt >> 16 & 0xFFFF;
        Integer int123Key = ucsCodePt >> 8 & 0xFFFFFF;
        if (ucsCodePt >>> 26 == 54) {
            range = (char[])htable.get(int1Key);
            if (range == null) {
                range = new char[]{'\u00ff', '\u0000'};
            }
            if (range[0] == '\u00ff' && range[1] == '\u0000') {
                range[0] = (char)l2Key;
                range[1] = (char)l2Key;
            } else {
                if (l2Key < (range[0] & 0xFFFF)) {
                    range[0] = (char)l2Key;
                }
                if (l2Key > (range[0] & 0xFFFF)) {
                    range[1] = (char)l2Key;
                }
            }
            htable.put(int1Key, range);
            range = (char[])htable.get(int12Key);
            if (range == null) {
                range = new char[]{'\u00ff', '\u0000'};
            }
            if (range[0] == '\u00ff' && range[1] == '\u0000') {
                range[0] = (char)l3Key;
                range[1] = (char)l3Key;
            } else {
                if (l3Key < (range[0] & 0xFFFF)) {
                    range[0] = (char)l3Key;
                }
                if (l3Key > (range[0] & 0xFFFF)) {
                    range[1] = (char)l3Key;
                }
            }
            htable.put(int12Key, range);
        }
        if ((range = (char[])htable2.get(int123Key)) == null) {
            range = new char[]{'\u00ff', '\u0000'};
        }
        if (range[0] == '\u00ff' && range[1] == '\u0000') {
            range[0] = (char)l4Key;
            range[1] = (char)l4Key;
        } else {
            if (l4Key < (range[0] & 0xFFFF)) {
                range[0] = (char)l4Key;
            }
            if (l4Key > (range[0] & 0xFFFF)) {
                range[1] = (char)l4Key;
            }
        }
        htable2.put(int123Key, range);
    }

    static {
        try {
            $$$methodRef$$$5 = CharacterConverterJDBC.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CharacterConverterJDBC.class.getDeclaredMethod("storeMappingRange", Integer.TYPE, Hashtable.class, Hashtable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CharacterConverterJDBC.class.getDeclaredMethod("getInstance", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CharacterConverterJDBC.class.getDeclaredMethod("getLeadingCodes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CharacterConverterJDBC.class.getDeclaredMethod("getOracleId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CharacterConverterJDBC.class.getDeclaredMethod("getGroupId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        m_converterStore = new ConcurrentHashMap();
    }
}

