/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CMAREngineNIO
extends T4CMAREngine {
    private NIONSDataChannel dataChannel;
    SessionAtts sAtts;
    private boolean bytesReadyToGo;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;

    T4CMAREngineNIO(Communication net) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$33, null, net);
            }
            this.bytesReadyToGo = false;
            if (net == null) {
                if (bl) {
                    this.debug($$$loggerRef$$$33, Level.FINEST, $$$methodRef$$$33, "T4CMAREngineNIO: net == null");
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            this.net = net;
            this.sAtts = net.getSessionAttributes();
            this.dataChannel = this.sAtts.dataChannel;
            this.types = new T4CTypeRep(this, true);
            this.types.setRep((byte)1, (byte)2);
            this.sAtts.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            this.sAtts.payloadDataBufferForRead.order(ByteOrder.LITTLE_ENDIAN);
            this.sAtts.payloadDataBufferForWrite.order(ByteOrder.LITTLE_ENDIAN);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$33, null);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$33, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void prepareForUnmarshalAsync(Consumer<Throwable> consumer) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void consumer2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$0, this, consumer);
            }
            if (this.bytesReadyToGo) {
                this.flush();
            }
            if (this.sAtts.readBuffer.remaining() > 0) {
                consumer2.accept(null);
            } else {
                this.sAtts.getNTAdapter().registerForNonBlockingRead((Consumer<Throwable>)consumer2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void valueToUNV(long l2, byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$1, null, l2, byArray);
            }
            buffer[0] = false;
            if (value == 0L) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$1, null);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$1, null, null);
                }
                return;
            }
            int indexInBuffer = 0;
            boolean zeros = true;
            boolean negative = value < 0L;
            long absoluteValue = negative ? -value : value;
            for (int i2 = 0; i2 < 8; ++i2) {
                byte b2 = (byte)(absoluteValue >>> 8 * (7 - i2) & 0xFFL);
                if (zeros && b2 == 0) continue;
                zeros = false;
                buffer[++indexInBuffer] = b2;
            }
            buffer[0] = (byte)indexInBuffer;
            if (negative) {
                void buffer;
                void v0 = buffer;
                v0[0] = (byte)(v0[0] | 0xFFFFFF80);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB1(byte by) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$2, this, by);
            }
            this.prepareForMarshall(1);
            this.sAtts.payloadDataBufferForWrite.put((byte)value);
            this.bytesReadyToGo = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB1(short s2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$3, this, s2);
            }
            this.marshalSB1((byte)value);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB2(short s2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$4, this, s2);
            }
            this.prepareForMarshall(3);
            if (this.types.rep[1] != 1) {
                this.sAtts.payloadDataBufferForWrite.putShort((short)value);
            } else if (value == false) {
                this.sAtts.payloadDataBufferForWrite.put((byte)0);
            } else {
                boolean negative = value < 0;
                short absoluteValue = (short)(negative ? -value : value);
                if (absoluteValue <= 255) {
                    if (negative) {
                        this.sAtts.payloadDataBufferForWrite.put((byte)-127);
                    } else {
                        this.sAtts.payloadDataBufferForWrite.put((byte)1);
                    }
                    this.sAtts.payloadDataBufferForWrite.put((byte)absoluteValue);
                } else {
                    if (negative) {
                        this.sAtts.payloadDataBufferForWrite.put((byte)-126);
                    } else {
                        this.sAtts.payloadDataBufferForWrite.put((byte)2);
                    }
                    this.sAtts.payloadDataBufferForWrite.putShort(absoluteValue);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB2(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$5, this, n2);
            }
            this.prepareForMarshall(3);
            if (this.types.rep[1] != 1) {
                this.sAtts.payloadDataBufferForWrite.putShort((short)value);
            } else if (value == false) {
                this.sAtts.payloadDataBufferForWrite.put((byte)0);
            } else if (value <= 255) {
                this.sAtts.payloadDataBufferForWrite.put((byte)1);
                this.sAtts.payloadDataBufferForWrite.put((byte)value);
            } else {
                this.sAtts.payloadDataBufferForWrite.put((byte)2);
                this.sAtts.payloadDataBufferForWrite.putShort((short)value);
            }
            this.bytesReadyToGo = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void marshalNativeUB2(short s2, boolean bl) throws IOException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$6, this, s2, bl);
            }
            try {
                void value;
                void isLSB;
                byte rep = this.types.getRep((byte)1);
                byte newRep = (byte)(0 | (isLSB != false ? 2 : 0));
                this.types.setRep((byte)1, newRep);
                this.marshalUB2((int)value);
                this.types.setRep((byte)1, rep);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB4(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$7, this, n2);
            }
            this.prepareForMarshall(5);
            if (this.types.rep[2] != 1) {
                this.sAtts.payloadDataBufferForWrite.putInt((int)value);
            } else if (value == false) {
                this.sAtts.payloadDataBufferForWrite.put((byte)0);
            } else {
                void absoluteValue;
                boolean negative = value < 0;
                void v0 = absoluteValue = negative ? -value : value;
                if (absoluteValue <= 255) {
                    if (!negative) {
                        this.sAtts.payloadDataBufferForWrite.put((byte)1);
                    } else {
                        this.sAtts.payloadDataBufferForWrite.put((byte)-127);
                    }
                    this.sAtts.payloadDataBufferForWrite.put((byte)absoluteValue);
                } else if (absoluteValue <= 65535) {
                    if (!negative) {
                        this.sAtts.payloadDataBufferForWrite.put((byte)2);
                    } else {
                        this.sAtts.payloadDataBufferForWrite.put((byte)-126);
                    }
                    this.sAtts.payloadDataBufferForWrite.putShort((short)absoluteValue);
                } else if (absoluteValue < 26) {
                    T4CMAREngineNIO.valueToUNV((long)value, this.tmpBuffer10);
                    this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
                } else {
                    if (!negative) {
                        this.sAtts.payloadDataBufferForWrite.put((byte)4);
                    } else {
                        this.sAtts.payloadDataBufferForWrite.put((byte)-124);
                    }
                    this.sAtts.payloadDataBufferForWrite.putInt((int)absoluteValue);
                }
            }
            this.bytesReadyToGo = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB4(long l2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$8, this, l2);
            }
            this.prepareForMarshall(5);
            if (this.types.rep[2] != 1) {
                this.sAtts.payloadDataBufferForWrite.putInt((int)value);
            } else {
                void absoluteValue;
                boolean negative = value < 0L;
                void v0 = absoluteValue = negative ? -value : value;
                if (absoluteValue == 0L) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)0);
                } else if (absoluteValue <= 255L) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)1);
                    this.sAtts.payloadDataBufferForWrite.put((byte)absoluteValue);
                } else if (absoluteValue <= 65535L) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)2);
                    this.sAtts.payloadDataBufferForWrite.putShort((short)absoluteValue);
                } else if (absoluteValue <= 0xFFFFFFL) {
                    T4CMAREngineNIO.valueToUNV((long)absoluteValue, this.tmpBuffer10);
                    this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)4);
                    this.sAtts.payloadDataBufferForWrite.putInt((int)absoluteValue);
                }
            }
            this.bytesReadyToGo = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalSB8(long l2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$9, this, l2);
            }
            this.prepareForMarshall(9);
            if (this.types.rep[3] != 1) {
                IOException iOException = new IOException("TODO: SB8 in UNV representation only");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$9, this, iOException);
                }
                throw iOException;
            }
            T4CMAREngineNIO.valueToUNV((long)value, this.tmpBuffer10);
            this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalUB8(long l2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$10, this, l2);
            }
            this.prepareForMarshall(9);
            if (this.types.rep[3] != 1) {
                this.sAtts.payloadDataBufferForWrite.putLong((long)value);
            } else if (value == 0L) {
                this.sAtts.payloadDataBufferForWrite.put((byte)0);
            } else {
                boolean zeros = true;
                int indexInBuffer = 0;
                for (int i2 = 0; i2 < 8; ++i2) {
                    byte b2 = (byte)(value >>> 8 * (7 - i2) & 0xFFL);
                    if (zeros && b2 == 0) continue;
                    zeros = false;
                    this.tmpBuffer10[++indexInBuffer] = b2;
                }
                this.tmpBuffer10[0] = (byte)indexInBuffer;
                this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            }
            this.bytesReadyToGo = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalB1Array(byte[] byArray) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$11, this, new Object[]{byArray});
            }
            this.marshalB1Array((byte[])value, 0, ((void)value).length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$12, this, byArray, n2, n3);
            }
            this.prepareForMarshall(1);
            int bytesToWriteInNextCall = 0;
            for (int bytesWrittenSoFar = 0; bytesWrittenSoFar < len; bytesWrittenSoFar += bytesToWriteInNextCall) {
                void off;
                void value;
                this.prepareForMarshall((int)(len - bytesWrittenSoFar));
                bytesToWriteInNextCall = Math.min(this.sAtts.payloadDataBufferForWrite.remaining(), (int)(len - bytesWrittenSoFar));
                this.sAtts.payloadDataBufferForWrite.put((byte[])value, (int)(off + bytesWrittenSoFar), bytesToWriteInNextCall);
                this.bytesReadyToGo = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$13, this, new Object[0]);
            }
            byte by = result = (byte)this.unmarshalSB2();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$13, this, by);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$13, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            short value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$14, this, new Object[0]);
            }
            this.prepareForUnmarshall();
            short s2 = value = (short)(this.sAtts.payloadDataBufferForRead.get() & 0xFF);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$14, this, s2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$14, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            short result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$15, this, new Object[0]);
            }
            this.prepareForUnmarshall();
            if (this.types.rep[1] != 1 && this.sAtts.payloadDataBufferForRead.remaining() >= 2) {
                short s2 = this.sAtts.payloadDataBufferForRead.getShort();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$15, this, s2);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$15, this, null);
                }
                return s2;
            }
            short s3 = result = (short)this.unmarshalUB2();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$15, this, s3);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$15, this, null);
            }
            return s3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$16, this, new Object[0]);
            }
            int value = (int)this.buffer2Value((byte)1);
            int n2 = value & 0xFFFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$16, this, n2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$16, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$17, this, new Object[0]);
            }
            this.prepareForUnmarshall();
            if (this.types.rep[2] != 1 && this.sAtts.payloadDataBufferForRead.remaining() >= 4) {
                int n2 = this.sAtts.payloadDataBufferForRead.getInt();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$17, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$17, this, null);
                }
                return n2;
            }
            int n3 = (int)this.buffer2Value((byte)2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$17, this, n3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$17, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$18, this, new Object[0]);
            }
            long l2 = (long)this.unmarshalSB4() & 0xFFFFFFFFL;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$18, this, l2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$18, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$19, this, n2);
            }
            byte[] tmpBuffer = new byte[n3];
            this.getNBytes(tmpBuffer, 0, (int)n3);
            byte[] byArray = tmpBuffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$19, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$19, this, null);
            }
            return tmpBuffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void n4;
            void off;
            void buf;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$20, this, byArray, n2, n3);
            }
            int n5 = this.getNBytes((byte[])buf, (int)off, (int)n4);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$20, this, n5);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$20, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int bytesReadSoFar;
            int pos;
            void buf;
            int len;
            void off;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$21, this, byArray, n2, n3);
            }
            if (off + len > ((void)buf).length) {
                len = ((void)buf).length - off;
            }
            boolean cnt = false;
            for (bytesReadSoFar = 0; bytesReadSoFar < len; bytesReadSoFar += this.sAtts.payloadDataBufferForRead.position() - pos) {
                if (!this.sAtts.payloadDataBufferForRead.hasRemaining()) {
                    this.prepareForUnmarshall();
                }
                pos = this.sAtts.payloadDataBufferForRead.position();
                this.sAtts.payloadDataBufferForRead.get((byte[])buf, (int)(off + bytesReadSoFar), Math.min(len - bytesReadSoFar, this.sAtts.payloadDataBufferForRead.remaining()));
            }
            int n4 = bytesReadSoFar;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$21, this, n4);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$21, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getNBytes(int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$22, this, n2);
            }
            byte[] byArray = this.unmarshalNBytes((int)n3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$22, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$22, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] buffer;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$23, this, n2);
            }
            int offset = 0;
            byte[] tmpBuffer = new byte[bytes];
            while (offset < bytes) {
                this.prepareForUnmarshall();
                tmpBuffer[offset] = this.sAtts.payloadDataBufferForRead.get();
                if (tmpBuffer[offset++] != 0) continue;
            }
            if (tmpBuffer.length == --offset) {
                buffer = tmpBuffer;
            } else {
                buffer = new byte[offset];
                System.arraycopy(tmpBuffer, 0, buffer, 0, offset);
            }
            byte[] byArray = buffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$23, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$23, this, null);
            }
            return buffer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final long buffer2Value(byte by) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void repOffset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$24, this, by);
            }
            long returnValue = 0L;
            byte rep = this.types.rep[repOffset];
            int numberOfBytes = 0;
            boolean negativeUNV = false;
            if (rep == 1) {
                this.prepareForUnmarshall();
                numberOfBytes = this.sAtts.payloadDataBufferForRead.get();
                if (numberOfBytes == 0) {
                    long l2 = 0L;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$24, this, l2);
                        ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$24, this, null);
                    }
                    return 0L;
                }
                if ((numberOfBytes & 0x80) > 0) {
                    numberOfBytes &= 0x7F;
                    negativeUNV = true;
                }
            } else {
                switch (repOffset) {
                    case 1: {
                        numberOfBytes = 2;
                        break;
                    }
                    case 2: {
                        numberOfBytes = 4;
                        break;
                    }
                    case 3: {
                        numberOfBytes = 8;
                    }
                }
            }
            if (this.sAtts.payloadDataBufferForRead.remaining() >= numberOfBytes && (numberOfBytes == 1 || numberOfBytes == 2 || numberOfBytes == 4 || numberOfBytes == 8)) {
                this.prepareForUnmarshall();
                returnValue = numberOfBytes == 1 ? (long)this.sAtts.payloadDataBufferForRead.get() & 0xFFL : (numberOfBytes == 2 ? (long)this.sAtts.payloadDataBufferForRead.getShort() & 0xFFFFL : (numberOfBytes == 4 ? (long)this.sAtts.payloadDataBufferForRead.getInt() & 0xFFFFFFFFL : this.sAtts.payloadDataBufferForRead.getLong()));
            } else {
                this.unmarshalNBytes(this.tmpBuffer8, 0, numberOfBytes);
                for (int byteOffset = 0; byteOffset < numberOfBytes; ++byteOffset) {
                    if (rep == 1 || rep != 2) {
                        returnValue |= ((long)this.tmpBuffer8[byteOffset] & 0xFFL) << 8 * (numberOfBytes - byteOffset - 1);
                        continue;
                    }
                    returnValue |= ((long)this.tmpBuffer8[byteOffset] & 0xFFL) << 8 * byteOffset;
                }
            }
            if (negativeUNV) {
                returnValue *= -1L;
            }
            long l3 = returnValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$24, this, l3);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$24, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setByteOrder(byte by) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void rep;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$25, this, by);
            }
            if (rep == 2) {
                this.sAtts.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.sAtts.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            if (this.sAtts.payloadDataBufferForRead != null) {
                this.sAtts.payloadDataBufferForRead.order(this.sAtts.getByteOrder());
            }
            if (this.sAtts.payloadDataBufferForWrite != null) {
                this.sAtts.payloadDataBufferForWrite.order(this.sAtts.getByteOrder());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void flush() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$26, this, new Object[0]);
            }
            try {
                if (!this.sAtts.isConnected()) {
                    NetException netException = new NetException(200);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$26, this, netException);
                    }
                    throw netException;
                }
                if (this.bytesReadyToGo) {
                    this.dataChannel.writeDataToSocketChannel();
                }
                this.bytesReadyToGo = false;
            }
            catch (NetException ne) {
                ne.setNetConnectionId(this.sAtts.getNetConnectionId());
                NetException netException = ne;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$26, this, netException);
                }
                throw netException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    private void prepareForUnmarshall() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, new Object[0]);
            }
            if (this.bytesReadyToGo) {
                this.flush();
            }
            if (this.sAtts.payloadDataBufferForRead.hasRemaining()) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this);
                    ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, null);
                }
                return;
            }
            if (!this.sAtts.isConnected()) {
                NetException netException = new NetException(200);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, netException);
                }
                throw netException;
            }
            try {
                while (!this.sAtts.payloadDataBufferForRead.hasRemaining()) {
                    this.dataChannel.readDataFromSocketChannel();
                }
            }
            catch (BreakNetException e2) {
                if (bl) {
                    this.debug($$$loggerRef$$$27, Level.FINEST, $$$methodRef$$$27, "T4CMAREngineNIO.unmarshalUB1: BreakNetException. resetting");
                }
                this.net.sendReset();
                BreakNetException breakNetException = e2;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, breakNetException);
                }
                throw breakNetException;
            }
            catch (NetException ne) {
                ne.setNetConnectionId(this.sAtts.getNetConnectionId());
                if (ne.isNSControlCommandError()) {
                    this.clearWriteBuffer();
                }
                switch (ne.getErrorNumber()) {
                    case 0: 
                    case 202: {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                NetException netException = ne;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, netException);
                }
                throw netException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareForMarshall(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void numberBytesToBeWritten;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$28, this, n2);
            }
            if (this.sAtts.payloadDataBufferForWrite.remaining() < numberBytesToBeWritten) {
                if (this.bytesReadyToGo) {
                    this.flush();
                }
                this.sAtts.prepareWriteBuffer();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$29, this, byArray, n2, n3);
            }
            try {
                void length;
                void offset;
                void userBuffer;
                this.flush();
                this.net.writeZeroCopyIO((byte[])userBuffer, (int)offset, (int)length);
            }
            catch (NetException ne) {
                ne.setNetConnectionId(this.sAtts.getNetConnectionId());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeZeroCopyIOHeader(boolean bl, int n2, boolean bl2) throws IOException {
        boolean bl3 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$30, this, bl, n2, bl2);
            }
            try {
                void isLastDD;
                void lengthInDD;
                void flushBuffer;
                if (flushBuffer != false) {
                    this.flush();
                }
                this.net.writeZeroCopyIOHeader((boolean)flushBuffer, (int)lengthInDD, (boolean)isLastDD);
            }
            catch (NetException ne) {
                ne.setNetConnectionId(this.sAtts.getNetConnectionId());
            }
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeZeroCopyIOData(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$31, this, byArray, n2, n3);
            }
            try {
                void length;
                void offset;
                void userBuffer;
                this.net.writeZeroCopyIOData((byte[])userBuffer, (int)offset, (int)length);
            }
            catch (NetException ne) {
                ne.setNetConnectionId(this.sAtts.getNetConnectionId());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void clearWriteBuffer() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$32, this, new Object[0]);
            }
            this.sAtts.prepareWriteBuffer();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T4CMAREngineNIO.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$33 = T4CMAREngineNIO.class.getDeclaredConstructor(Communication.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T4CMAREngineNIO.class.getDeclaredMethod("clearWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T4CMAREngineNIO.class.getDeclaredMethod("writeZeroCopyIOData", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T4CMAREngineNIO.class.getDeclaredMethod("writeZeroCopyIOHeader", Boolean.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CMAREngineNIO.class.getDeclaredMethod("writeZeroCopyIO", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CMAREngineNIO.class.getDeclaredMethod("prepareForMarshall", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CMAREngineNIO.class.getDeclaredMethod("prepareForUnmarshall", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CMAREngineNIO.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CMAREngineNIO.class.getDeclaredMethod("setByteOrder", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CMAREngineNIO.class.getDeclaredMethod("buffer2Value", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalTEXT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CMAREngineNIO.class.getDeclaredMethod("getNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CMAREngineNIO.class.getDeclaredMethod("getNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalUB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalSB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalSB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalUB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalSB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CMAREngineNIO.class.getDeclaredMethod("marshalB1Array", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CMAREngineNIO.class.getDeclaredMethod("marshalB1Array", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB4", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CMAREngineNIO.class.getDeclaredMethod("marshalNativeUB2", Short.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB2", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB1", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB1", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CMAREngineNIO.class.getDeclaredMethod("valueToUNV", Long.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CMAREngineNIO.class.getDeclaredMethod("prepareForUnmarshalAsync", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

