/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxShort
extends IfxObject {
    private short value;
    public static final short IFX_SMINT_NULL = Short.MIN_VALUE;

    IfxShort() throws SQLException {
        this.setIfxType(1);
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[]{-128, 0};
            return b;
        }
        return JavaToIfxType.JavaToIfxSmallInt(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        this.value = IfxToJavaType.IfxToJavaSmallInt(b, offset);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public void fromByte(byte val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromShort(short val) throws SQLException {
        this.value = val;
        this.unnullify();
    }

    @Override
    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val;
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromInt(int val) throws SQLException {
        if (val > Short.MAX_VALUE || val < Short.MIN_VALUE) {
            this.nullify();
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else if (val <= Short.MAX_VALUE && val >= Short.MIN_VALUE) {
            this.value = val.shortValue();
            this.unnullify();
        } else {
            this.nullify();
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void fromLong(long val) throws SQLException {
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromLong(Long val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(float val) throws SQLException {
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double val) throws SQLException {
        this.value = (short)val;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = val.shortValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    @Override
    public void fromDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = (short)val.intValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    @Override
    public void fromBoolean(boolean val) throws SQLException {
        this.value = (short)(val ? 1 : 0);
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.value = (short)(val == true ? 1 : 0);
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            this.value = Short.valueOf(str.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxShort && this.value == ((IfxShort)other).value;
    }

    @Override
    public short getEncodedLength() {
        short encodedLength = 1280;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(3, "IfxShort ecodedLength = " + encodedLength);
        }
        return encodedLength;
    }

    public boolean isIfxNull() {
        return this.value == Short.MIN_VALUE;
    }
}

