/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.SQLException;

public class IfxIntervalYM
extends IfxObject {
    private static final Object logger = Trace.getLoggerForClass(IfxIntervalYM.class);
    private IntervalYM value = null;

    public IfxIntervalYM() throws SQLException {
        this.setIfxType(14);
    }

    IfxIntervalYM(IntervalYM YM) throws SQLException {
        this.setIfxType(14);
        this.value = YM;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.setEncodedLength(this.value.getQualifier());
        }
    }

    public IntervalYM value() {
        return this.value;
    }

    @Override
    public byte[] toIfx() {
        byte[] b = JavaToIfxType.JavaToIfxInterval(this.value);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   IfxIntervalYM.toIfx() data:");
            this.trace.writeTrace(logger, 2, b, 'H');
        }
        return b;
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] b = JavaToIfxType.JavaToIfxInterval(this.value);
        return Decimal.fromBindToTuple(b, IfxDecimal.decLength(this.encodedLength));
    }

    @Override
    public void fromIfx(byte[] b, short prec) throws SQLException {
        this.fromIfx(b, 0, b.length, prec);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length, short prec) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   IfxIntervalYM.fromIfx() data:");
            this.trace.writeTrace(logger, 2, b, offset, 'H', length);
        }
        this.value = (IntervalYM)IfxToJavaType.IfxToJavaInterval(b, offset, length, prec);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value.setQualifier((short)this.encodedLength);
        }
    }

    @Override
    public String toString() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxIntervalYM.toString(): entered");
        }
        if (this.isNull() || this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxIntervalYM.fromString(): entered");
        }
        if (str == null) {
            this.nullify();
            this.value = null;
            return;
        }
        if (this.value == null) {
            this.value = new IntervalYM();
            this.value.setQualifier(super.getEncodedLength());
        }
        this.value.fromString(str);
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxIntervalYM.fromString(): exited");
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public Interval toInterval() throws SQLException {
        return this.toIntervalYM();
    }

    @Override
    public IntervalYM toIntervalYM() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromIntervalYM(IntervalYM YM) throws SQLException {
        if (YM == null) {
            this.nullify();
        } else {
            this.value = YM;
            this.unnullify();
        }
    }

    @Override
    public short getEncodedLength() {
        if (this.value == null) {
            return (short)this.encodedLength;
        }
        return this.value.getQualifier();
    }

    @Override
    public String toUnloadString() {
        return this.toString();
    }
}

