/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxDataOutputStream
extends FilterOutputStream {
    protected int written = 0;
    private int byteCountAtEOT;
    private OutputStream os;
    private boolean usestrenc = false;
    protected static final int one = 1;
    private JavaToIfxType javatoifx = new JavaToIfxType();

    public IfxDataOutputStream(OutputStream s) {
        super(s);
        this.os = s;
    }

    public IfxDataOutputStream(OutputStream s, boolean encoption) {
        super(s);
        this.os = s;
        this.usestrenc = encoption;
    }

    @Override
    public void write(int i) throws IOException {
        this.os.write(i);
        ++this.written;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
        this.written += length;
    }

    public void writeWithoutTrace(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
        this.written += length;
    }

    public void writePadded(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
        this.written += length;
        if ((length & 1) >= 1) {
            this.write(0);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writeWithMangledTrace(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writePadded(byte[] b) throws IOException {
        this.write(b, 0, b.length);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInt(int i) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxInt(i);
        this.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    public void writeByte(int i) throws IOException {
        this.write(i);
    }

    public void writeBytes(byte[] b) throws IOException {
        this.write(b, 2, b.length - 2);
    }

    public void writeBytesConstant(String s) throws IOException, SQLException {
        byte[] b = this.javatoifx.JavaToIfxChar(s, this.usestrenc);
        this.write(b, 2, b.length - 2);
    }

    public byte[] getJavaToIfxChar(String s, String dbEnc) throws IOException, SQLException {
        return this.javatoifx.JavaToIfxChar(s, dbEnc, this.usestrenc);
    }

    public byte[] getJavaToIfxChar(String s) throws IOException, SQLException {
        return this.javatoifx.JavaToIfxChar(s, this.usestrenc);
    }

    public byte[] getJavaToIfx4BytesChar(String s) throws IOException, SQLException {
        return this.javatoifx.JavaToIfx4BytesChar(s, this.usestrenc);
    }

    public byte[] getJavaToIfx4BytesChar(String s, String dbenc) throws IOException, SQLException {
        return this.javatoifx.JavaToIfx4BytesChar(s, dbenc, this.usestrenc);
    }

    public void writeChar(byte[] b) throws IOException {
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDate(Date d) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDate(d);
        this.write(b);
    }

    public void writeDateTime(Timestamp t) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDateTime(t);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInterval(IntervalDF i) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxInterval(i);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInterval(IntervalYM i) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxInterval(i);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDecimal(BigDecimal n) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDecimal(n);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDouble(double d) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxDouble(d);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeReal(float f) throws IOException {
        byte[] b = JavaToIfxType.JavaToIfxReal(f);
        this.write(b);
        if ((b.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeSmallInt(short s) throws IOException {
        this.write(JavaToIfxType.JavaToIfxSmallInt(s));
    }

    public void writeShort(int i) throws IOException {
        this.writeSmallInt((short)i);
    }

    public void writeShort(short s) throws IOException {
        this.writeSmallInt(s);
    }

    public void writeLongInt(long s) throws IOException {
        this.write(JavaToIfxType.JavaToIfxLongInt(s));
    }

    public void writeLongBigint(long s) throws IOException {
        this.write(JavaToIfxType.JavaToIfxLongBigInt(s));
    }

    public void setByteCntAtEOT() {
        this.byteCountAtEOT = this.written;
    }

    public int getBytesSentSinceLastEOT() {
        return this.written - this.byteCountAtEOT;
    }
}

