/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.SimpleTypeCachedState;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=SimpleTypeCachedState.class)
final class SimpleTypeCachedStateFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<BackendNativePointerLibrary> BACKEND_NATIVE_POINTER_LIBRARY_ = LibraryFactory.resolve(BackendNativePointerLibrary.class);
    private static final LibraryFactory<SerializableLibrary> SERIALIZABLE_LIBRARY_ = LibraryFactory.resolve(SerializableLibrary.class);

    SimpleTypeCachedStateFactory() {
    }

    public static List<NodeFactory<? extends ConvertTypeNode>> getFactories() {
        return List.of(NopConvertFactory.getInstance(), NothingFactory.getInstance(), InjectedFactory.getInstance(), NullableToNativeFactory.getInstance(), PointerFromNativeFactory.getInstance(), ToInt8Factory.getInstance(), FromUInt8Factory.getInstance(), ToInt16Factory.getInstance(), FromUInt16Factory.getInstance(), ToInt32Factory.getInstance(), FromUInt32Factory.getInstance(), ToInt64Factory.getInstance(), ToFloatFactory.getInstance(), ToDoubleFactory.getInstance(), ToFP80Factory.getInstance(), FromFP80Factory.getInstance(), ToFP128Factory.getInstance(), FromFP128Factory.getInstance());
    }

    @GeneratedBy(value=SimpleTypeCachedState.NopConvert.class)
    static final class NopConvertFactory
    implements NodeFactory<SimpleTypeCachedState.NopConvert> {
        private static final NopConvertFactory NOP_CONVERT_FACTORY_INSTANCE = new NopConvertFactory();

        private NopConvertFactory() {
        }

        public Class<SimpleTypeCachedState.NopConvert> getNodeClass() {
            return SimpleTypeCachedState.NopConvert.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.NopConvert createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NopConvertFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.NopConvert getUncachedInstance() {
            return NopConvertNodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.NopConvert> getInstance() {
            return NOP_CONVERT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.NopConvert create() {
            return new NopConvertNodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.NopConvert getUncached() {
            return NopConvertNodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.NopConvert.class)
        static final class NopConvertNodeGen
        extends SimpleTypeCachedState.NopConvert
        implements GenerateAOT.Provider {
            private static final Uncached UNCACHED = new Uncached();

            private NopConvertNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                return this.doConvert(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            }

            @GeneratedBy(value=SimpleTypeCachedState.NopConvert.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.NopConvert
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    return this.doConvert(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.Nothing.class)
    static final class NothingFactory
    implements NodeFactory<SimpleTypeCachedState.Nothing> {
        private static final NothingFactory NOTHING_FACTORY_INSTANCE = new NothingFactory();

        private NothingFactory() {
        }

        public Class<SimpleTypeCachedState.Nothing> getNodeClass() {
            return SimpleTypeCachedState.Nothing.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.Nothing createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NothingFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.Nothing getUncachedInstance() {
            return NothingNodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.Nothing> getInstance() {
            return NOTHING_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.Nothing create() {
            return new NothingNodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.Nothing getUncached() {
            return NothingNodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.Nothing.class)
        static final class NothingNodeGen
        extends SimpleTypeCachedState.Nothing
        implements GenerateAOT.Provider {
            private static final Uncached UNCACHED = new Uncached();

            private NothingNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                return this.doConvert(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            }

            @GeneratedBy(value=SimpleTypeCachedState.Nothing.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.Nothing
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    return this.doConvert(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.Injected.class)
    static final class InjectedFactory
    implements NodeFactory<SimpleTypeCachedState.Injected> {
        private static final InjectedFactory INJECTED_FACTORY_INSTANCE = new InjectedFactory();

        private InjectedFactory() {
        }

        public Class<SimpleTypeCachedState.Injected> getNodeClass() {
            return SimpleTypeCachedState.Injected.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.Injected createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return InjectedFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.Injected getUncachedInstance() {
            return InjectedNodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.Injected> getInstance() {
            return INJECTED_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.Injected create() {
            return new InjectedNodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.Injected getUncached() {
            return InjectedNodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.Injected.class)
        static final class InjectedNodeGen
        extends SimpleTypeCachedState.Injected
        implements GenerateAOT.Provider {
            private static final Uncached UNCACHED = new Uncached();

            private InjectedNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                return this.doConvert(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            }

            @GeneratedBy(value=SimpleTypeCachedState.Injected.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.Injected
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    return this.doConvert(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.NullableToNative.class)
    static final class NullableToNativeFactory
    implements NodeFactory<SimpleTypeCachedState.NullableToNative> {
        private static final NullableToNativeFactory NULLABLE_TO_NATIVE_FACTORY_INSTANCE = new NullableToNativeFactory();

        private NullableToNativeFactory() {
        }

        public Class<SimpleTypeCachedState.NullableToNative> getNodeClass() {
            return SimpleTypeCachedState.NullableToNative.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.NullableToNative createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NullableToNativeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.NullableToNative getUncachedInstance() {
            return NullableToNativeNodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.NullableToNative> getInstance() {
            return NULLABLE_TO_NATIVE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.NullableToNative create() {
            return new NullableToNativeNodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.NullableToNative getUncached() {
            return NullableToNativeNodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.NullableToNative.class)
        static final class NullableToNativeNodeGen
        extends SimpleTypeCachedState.NullableToNative
        implements GenerateAOT.Provider {
            static final InlineSupport.ReferenceField<Null0Data> NULL0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"null0_cache", Null0Data.class);
            static final InlineSupport.ReferenceField<Object0Data> OBJECT0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"object0_cache", Object0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Null0Data null0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Object0Data object0_cache;

            private NullableToNativeNodeGen() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x1E) != 0) {
                    Node prev_;
                    EncapsulatingNodeReference encapsulating_;
                    if ((state_0 & 2) != 0) {
                        Null0Data s0_ = this.null0_cache;
                        while (s0_ != null) {
                            if (s0_.interop_.accepts(arg1Value) && s0_.interop_.isNull(arg1Value)) {
                                return this.doNull(arg0Value, arg1Value, s0_.interop_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (interop__.isNull(arg1Value)) {
                                Object object = this.null1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        Object0Data s2_ = this.object0_cache;
                        while (s2_ != null) {
                            if (s2_.interop_.accepts(arg1Value) && !s2_.interop_.isNull(arg1Value)) {
                                return this.doObject(arg0Value, arg1Value, s2_.interop_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (!interop__1.isNull(arg1Value)) {
                                Object object = this.object1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object null1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doNull(arg0Value, arg1Value, interop__);
            }

            @CompilerDirectives.TruffleBoundary
            private Object object1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doObject(arg0Value, arg1Value, interop__1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                Object interop__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 4) == 0) {
                    Null0Data s0_;
                    block17: {
                        Null0Data s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = (Null0Data)((Object)NULL0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s0_ == null || s0_.interop_.accepts(arg1Value) && s0_.interop_.isNull(arg1Value))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNull(arg1Value) || count0_ >= 3) break block17;
                            s0_ = (Null0Data)this.insert(new Null0Data(s0_original));
                            Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                        } while (!NULL0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s0_ != null) {
                        return this.doNull(arg0Value, arg1Value, s0_.interop_);
                    }
                }
                InteropLibrary interop__2 = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__2 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__2.isNull(arg1Value)) {
                        this.null0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        interop__ = this.doNull(arg0Value, arg1Value, interop__2);
                        return interop__;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x10) == 0) {
                    Object0Data s2_;
                    block19: {
                        Object0Data s2_original;
                        do {
                            InteropLibrary interop__1;
                            int count2_ = 0;
                            s2_original = s2_ = (Object0Data)((Object)OBJECT0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s2_ != null && (!s2_.interop_.accepts(arg1Value) || s2_.interop_.isNull(arg1Value))) {
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || (interop__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNull(arg1Value) || count2_ >= 3) break block19;
                            s2_ = (Object0Data)this.insert(new Object0Data(s2_original));
                            Objects.requireNonNull((InteropLibrary)s2_.insert((Node)interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__1;
                        } while (!OBJECT0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.state_0_ = state_0 |= 8;
                    }
                    if (s2_ != null) {
                        return this.doObject(arg0Value, arg1Value, s2_.interop_);
                    }
                }
                InteropLibrary interop__1 = null;
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (!interop__1.isNull(arg1Value)) {
                        this.object0_cache = null;
                        state_0 &= 0xFFFFFFF7;
                        this.state_0_ = state_0 |= 0x10;
                        Object object = this.doObject(arg0Value, arg1Value, interop__1);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value});
            }

            @GeneratedBy(value=SimpleTypeCachedState.NullableToNative.class)
            @DenyReplace
            private static final class Null0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Null0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Null0Data(Null0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.NullableToNative.class)
            @DenyReplace
            private static final class Object0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Object0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Object0Data(Object0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.NullableToNative.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.NullableToNative
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNull(arg1Value)) {
                        return this.doNull(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNull(arg1Value)) {
                        return this.doObject(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    throw NullableToNativeNodeGen.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.PointerFromNative.class)
    static final class PointerFromNativeFactory
    implements NodeFactory<SimpleTypeCachedState.PointerFromNative> {
        private static final PointerFromNativeFactory POINTER_FROM_NATIVE_FACTORY_INSTANCE = new PointerFromNativeFactory();

        private PointerFromNativeFactory() {
        }

        public Class<SimpleTypeCachedState.PointerFromNative> getNodeClass() {
            return SimpleTypeCachedState.PointerFromNative.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.PointerFromNative createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return PointerFromNativeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.PointerFromNative getUncachedInstance() {
            return PointerFromNativeNodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.PointerFromNative> getInstance() {
            return POINTER_FROM_NATIVE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.PointerFromNative create() {
            return new PointerFromNativeNodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.PointerFromNative getUncached() {
            return PointerFromNativeNodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.PointerFromNative.class)
        static final class PointerFromNativeNodeGen
        extends SimpleTypeCachedState.PointerFromNative
        implements GenerateAOT.Provider {
            private static final InlineSupport.StateField STATE_0_PointerFromNative_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedConditionProfile INLINED_OBJECT_IS_POINTER_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_PointerFromNative_UPDATER.subUpdater(4, 2)}));
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private BackendNativePointerLibrary object_library_;

            private PointerFromNativeNodeGen() {
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0xE) != 0) {
                    BackendNativePointerLibrary library__;
                    if ((state_0 & 2) != 0 && arg1Value == null) {
                        return this.doNull(arg0Value, arg1Value);
                    }
                    if ((state_0 & 4) != 0 && arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        return this.doLong(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 8) != 0 && (library__ = this.object_library_) != null && arg1Value != null) {
                        PointerFromNativeNodeGen node__ = this;
                        return this.doObject(arg0Value, arg1Value, library__, node__, INLINED_OBJECT_IS_POINTER_PROFILE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value == null) {
                    this.state_0_ = state_0 |= 2;
                    return this.doNull(arg0Value, arg1Value);
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doLong(arg0Value, arg1Value_);
                }
                PointerFromNativeNodeGen node__ = null;
                if (arg1Value != null) {
                    BackendNativePointerLibrary library__ = (BackendNativePointerLibrary)this.insert((Node)((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(library__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.object_library_ = library__;
                    node__ = this;
                    this.state_0_ = state_0 |= 8;
                    return this.doObject(arg0Value, arg1Value, library__, node__, INLINED_OBJECT_IS_POINTER_PROFILE_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 4;
                BackendNativePointerLibrary library__ = (BackendNativePointerLibrary)this.insert((Node)((BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(library__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.object_library_ = library__;
                INLINED_OBJECT_IS_POINTER_PROFILE_.disable((Node)this);
                if (this.object_library_ instanceof GenerateAOT.Provider) {
                    assert (NodeUtil.assertRecursion((Node)this.object_library_, (int)1));
                    ((GenerateAOT.Provider)this.object_library_).prepareForAOT(language, root);
                }
                this.state_0_ |= 8;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.object_library_ = null;
                INLINED_OBJECT_IS_POINTER_PROFILE_.reset((Node)this);
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value});
            }

            @GeneratedBy(value=SimpleTypeCachedState.PointerFromNative.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.PointerFromNative
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value == null) {
                        return this.doNull(arg0Value, arg1Value);
                    }
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        return this.doLong(arg0Value, arg1Value_);
                    }
                    if (arg1Value != null) {
                        return this.doObject(arg0Value, arg1Value, (BackendNativePointerLibrary)BACKEND_NATIVE_POINTER_LIBRARY_.getUncached(), this, InlinedConditionProfile.getUncached());
                    }
                    throw PointerFromNativeNodeGen.newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToInt8.class)
    static final class ToInt8Factory
    implements NodeFactory<SimpleTypeCachedState.ToInt8> {
        private static final ToInt8Factory TO_INT8FACTORY_INSTANCE = new ToInt8Factory();

        private ToInt8Factory() {
        }

        public Class<SimpleTypeCachedState.ToInt8> getNodeClass() {
            return SimpleTypeCachedState.ToInt8.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToInt8 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToInt8Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToInt8 getUncachedInstance() {
            return ToInt8NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToInt8> getInstance() {
            return TO_INT8FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt8 create() {
            return new ToInt8NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt8 getUncached() {
            return ToInt8NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToInt8.class)
        static final class ToInt8NodeGen
        extends SimpleTypeCachedState.ToInt8
        implements GenerateAOT.Provider {
            private static final InlineSupport.StateField NUMBER0_TO_INT8_NUMBER0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Number0Data.lookup_(), (String)"number0_state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NUMBER0_TO_INT8_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField STATE_0_ToInt8_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToInt8_UPDATER.subUpdater(10, 1)}));
            static final InlineSupport.ReferenceField<ByteData> BYTE_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"byte_cache", ByteData.class);
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private ByteData byte_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Boolean0Data boolean0_cache;

            private ToInt8NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 0x40) == 0 && arg1Value instanceof Character) {
                    return false;
                }
                if ((state_0 & 0x20) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x100) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x3F6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Byte) {
                        byte arg1Value_ = (Byte)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x40) != 0 && arg1Value instanceof Character) {
                        char arg1Value_ = ((Character)arg1Value).charValue();
                        return this.doChar(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x3B4) != 0) {
                        Node prev_;
                        EncapsulatingNodeReference encapsulating_;
                        if ((state_0 & 4) != 0) {
                            ByteData s2_ = this.byte_cache;
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.fitsInByte(arg1Value)) {
                                    try {
                                        return this.doByte(arg0Value, arg1Value, s2_.interop_);
                                    }
                                    catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        this.byte_cache = null;
                                        return this.executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0x10) != 0) {
                            Number0Data s3_ = this.number0_cache;
                            while (s3_ != null) {
                                if (s3_.interop_.accepts(arg1Value) && s3_.interop_.isNumber(arg1Value)) {
                                    Number0Data node__ = s3_;
                                    return SimpleTypeCachedState.ToInt8.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s3_ = s3_.next_;
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__.isNumber(arg1Value)) {
                                    Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x80) != 0) {
                            Boolean0Data s5_ = this.boolean0_cache;
                            while (s5_ != null) {
                                if (s5_.interop_.accepts(arg1Value) && s5_.interop_.isBoolean(arg1Value)) {
                                    return this.doBoolean(arg0Value, arg1Value, s5_.interop_);
                                }
                                s5_ = s5_.next_;
                            }
                        }
                        if ((state_0 & 0x100) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__1.isBoolean(arg1Value)) {
                                    Object object = this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x200) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return this.doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                ToInt8NodeGen node__ = this;
                return SimpleTypeCachedState.ToInt8.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
            }

            @CompilerDirectives.TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doBoolean(arg0Value, arg1Value, interop__1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 0x34) == 0 && arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Character) {
                    char arg1Value_ = ((Character)arg1Value).charValue();
                    this.state_0_ = state_0 |= 0x40;
                    return this.doChar(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x30) == 0 && (state_0 & 8) == 0) {
                    ByteData s2_;
                    block26: {
                        ByteData s2_original;
                        do {
                            InteropLibrary interop__2;
                            int count2_ = 0;
                            s2_original = s2_ = (ByteData)((Object)BYTE_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s2_ == null || s2_.interop_.accepts(arg1Value) && s2_.interop_.fitsInByte(arg1Value))) {
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(interop__2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).fitsInByte(arg1Value) || count2_ >= 3) break block26;
                            s2_ = (ByteData)this.insert(new ByteData(s2_original));
                            Objects.requireNonNull((InteropLibrary)s2_.insert((Node)interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__2;
                        } while (!BYTE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s2_ != null) {
                        try {
                            return this.doByte(arg0Value, arg1Value, s2_.interop_);
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.byte_cache = null;
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                }
                Node node__ = null;
                if ((state_0 & 0x20) == 0) {
                    Number0Data s3_;
                    block27: {
                        Number0Data s3_original;
                        do {
                            InteropLibrary interop__;
                            int count3_ = 0;
                            s3_original = s3_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s3_ != null) {
                                if (s3_.interop_.accepts(arg1Value) && s3_.interop_.isNumber(arg1Value)) {
                                    node__ = s3_;
                                    break;
                                }
                                ++count3_;
                                s3_ = s3_.next_;
                            }
                            if (s3_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count3_ >= 3) break block27;
                            s3_ = (Number0Data)this.insert(new Number0Data(s3_original));
                            Objects.requireNonNull((InteropLibrary)s3_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s3_.interop_ = interop__;
                            node__ = s3_;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s3_original, (Object)s3_));
                        this.byte_cache = null;
                        state_0 &= 0xFFFFFFF9;
                        this.state_0_ = state_0 |= 0x10;
                    }
                    if (s3_ != null) {
                        return SimpleTypeCachedState.ToInt8.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                    }
                }
                node__ = null;
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.isNumber(arg1Value)) {
                        node__ = this;
                        this.byte_cache = null;
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFE9;
                        this.state_0_ = state_0 |= 0x20;
                        byte by = SimpleTypeCachedState.ToInt8.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                        return by;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x100) == 0) {
                    Boolean0Data s5_;
                    block29: {
                        Boolean0Data s5_original;
                        do {
                            InteropLibrary interop__1;
                            int count5_ = 0;
                            s5_original = s5_ = (Boolean0Data)((Object)BOOLEAN0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s5_ == null || s5_.interop_.accepts(arg1Value) && s5_.interop_.isBoolean(arg1Value))) {
                                ++count5_;
                                s5_ = s5_.next_;
                            }
                            if (s5_ != null || !(interop__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isBoolean(arg1Value) || count5_ >= 3) break block29;
                            s5_ = (Boolean0Data)this.insert(new Boolean0Data(s5_original));
                            Objects.requireNonNull((InteropLibrary)s5_.insert((Node)interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s5_.interop_ = interop__1;
                        } while (!BOOLEAN0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s5_original, (Object)s5_));
                        this.state_0_ = state_0 |= 0x80;
                    }
                    if (s5_ != null) {
                        return this.doBoolean(arg0Value, arg1Value, s5_.interop_);
                    }
                }
                InteropLibrary interop__1 = null;
                EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                Node prev_2 = encapsulating_2.set((Node)this);
                try {
                    interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__1.isBoolean(arg1Value)) {
                        this.boolean0_cache = null;
                        state_0 &= 0xFFFFFF7F;
                        this.state_0_ = state_0 |= 0x100;
                        byte by = this.doBoolean(arg0Value, arg1Value, interop__1);
                        return by;
                    }
                }
                finally {
                    encapsulating_2.set(prev_2);
                }
                this.state_0_ = state_0 |= 0x200;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 0x40;
                this.state_0_ |= 0x200;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt8.class)
            @DenyReplace
            private static final class ByteData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ByteData next_;
                @Node.Child
                InteropLibrary interop_;

                ByteData(ByteData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt8.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int number0_state_0_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt8.class)
            @DenyReplace
            private static final class Boolean0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Boolean0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt8.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToInt8
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Byte) {
                        byte arg1Value_ = (Byte)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if (arg1Value instanceof Character) {
                        char arg1Value_ = ((Character)arg1Value).charValue();
                        return this.doChar(arg0Value, arg1Value_);
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return SimpleTypeCachedState.ToInt8.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this, InlinedBranchProfile.getUncached());
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value)) {
                        return this.doBoolean(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.FromUInt8.class)
    static final class FromUInt8Factory
    implements NodeFactory<SimpleTypeCachedState.FromUInt8> {
        private static final FromUInt8Factory FROM_UINT8FACTORY_INSTANCE = new FromUInt8Factory();

        private FromUInt8Factory() {
        }

        public Class<SimpleTypeCachedState.FromUInt8> getNodeClass() {
            return SimpleTypeCachedState.FromUInt8.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.FromUInt8 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FromUInt8Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.FromUInt8 getUncachedInstance() {
            return FromUInt8NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.FromUInt8> getInstance() {
            return FROM_UINT8FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromUInt8 create() {
            return new FromUInt8NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromUInt8 getUncached() {
            return FromUInt8NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.FromUInt8.class)
        static final class FromUInt8NodeGen
        extends SimpleTypeCachedState.FromUInt8
        implements GenerateAOT.Provider {
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private FromUInt8NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                return (state_0 & 2) != 0 || !(arg1Value instanceof Byte);
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Byte) {
                        byte arg1Value_ = (Byte)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return this.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (Byte)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 4;
                return this.doOther(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 4;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.FromUInt8.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.FromUInt8
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Byte) {
                        byte arg1Value_ = (Byte)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    return this.doOther(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToInt16.class)
    static final class ToInt16Factory
    implements NodeFactory<SimpleTypeCachedState.ToInt16> {
        private static final ToInt16Factory TO_INT16FACTORY_INSTANCE = new ToInt16Factory();

        private ToInt16Factory() {
        }

        public Class<SimpleTypeCachedState.ToInt16> getNodeClass() {
            return SimpleTypeCachedState.ToInt16.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToInt16 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToInt16Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToInt16 getUncachedInstance() {
            return ToInt16NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToInt16> getInstance() {
            return TO_INT16FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt16 create() {
            return new ToInt16NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt16 getUncached() {
            return ToInt16NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToInt16.class)
        static final class ToInt16NodeGen
        extends SimpleTypeCachedState.ToInt16
        implements GenerateAOT.Provider {
            private static final InlineSupport.StateField NUMBER0_TO_INT16_NUMBER0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Number0Data.lookup_(), (String)"number0_state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NUMBER0_TO_INT16_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField STATE_0_ToInt16_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToInt16_UPDATER.subUpdater(9, 1)}));
            static final InlineSupport.ReferenceField<ShortData> SHORT_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"short_cache", ShortData.class);
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private ShortData short_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Boolean0Data boolean0_cache;

            private ToInt16NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 0x20) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x80) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x1F6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Short) {
                        short arg1Value_ = (Short)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x1F4) != 0) {
                        Node prev_;
                        EncapsulatingNodeReference encapsulating_;
                        if ((state_0 & 4) != 0) {
                            ShortData s1_ = this.short_cache;
                            while (s1_ != null) {
                                if (s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInShort(arg1Value)) {
                                    try {
                                        return this.doShort(arg0Value, arg1Value, s1_.interop_);
                                    }
                                    catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        this.short_cache = null;
                                        return this.executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0x10) != 0) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    Number0Data node__ = s2_;
                                    return SimpleTypeCachedState.ToInt16.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__.isNumber(arg1Value)) {
                                    Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x40) != 0) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if (s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value)) {
                                    return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0x80) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__1.isBoolean(arg1Value)) {
                                    Object object = this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x100) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return this.doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                ToInt16NodeGen node__ = this;
                return SimpleTypeCachedState.ToInt16.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
            }

            @CompilerDirectives.TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doBoolean(arg0Value, arg1Value, interop__1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 0x34) == 0 && arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x30) == 0 && (state_0 & 8) == 0) {
                    ShortData s1_;
                    block25: {
                        ShortData s1_original;
                        do {
                            InteropLibrary interop__2;
                            int count1_ = 0;
                            s1_original = s1_ = (ShortData)((Object)SHORT_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s1_ == null || s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInShort(arg1Value))) {
                                ++count1_;
                                s1_ = s1_.next_;
                            }
                            if (s1_ != null || !(interop__2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).fitsInShort(arg1Value) || count1_ >= 3) break block25;
                            s1_ = (ShortData)this.insert(new ShortData(s1_original));
                            Objects.requireNonNull((InteropLibrary)s1_.insert((Node)interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.interop_ = interop__2;
                        } while (!SHORT_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s1_ != null) {
                        try {
                            return this.doShort(arg0Value, arg1Value, s1_.interop_);
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.short_cache = null;
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                }
                Node node__ = null;
                if ((state_0 & 0x20) == 0) {
                    Number0Data s2_;
                    block26: {
                        Number0Data s2_original;
                        do {
                            InteropLibrary interop__;
                            int count2_ = 0;
                            s2_original = s2_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    node__ = s2_;
                                    break;
                                }
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count2_ >= 3) break block26;
                            s2_ = (Number0Data)this.insert(new Number0Data(s2_original));
                            Objects.requireNonNull((InteropLibrary)s2_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__;
                            node__ = s2_;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.short_cache = null;
                        state_0 &= 0xFFFFFFF9;
                        this.state_0_ = state_0 |= 0x10;
                    }
                    if (s2_ != null) {
                        return SimpleTypeCachedState.ToInt16.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                    }
                }
                node__ = null;
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.isNumber(arg1Value)) {
                        node__ = this;
                        this.short_cache = null;
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFE9;
                        this.state_0_ = state_0 |= 0x20;
                        Short s = SimpleTypeCachedState.ToInt16.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                        return s;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x80) == 0) {
                    Boolean0Data s4_;
                    block28: {
                        Boolean0Data s4_original;
                        do {
                            InteropLibrary interop__1;
                            int count4_ = 0;
                            s4_original = s4_ = (Boolean0Data)((Object)BOOLEAN0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s4_ == null || s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value))) {
                                ++count4_;
                                s4_ = s4_.next_;
                            }
                            if (s4_ != null || !(interop__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isBoolean(arg1Value) || count4_ >= 3) break block28;
                            s4_ = (Boolean0Data)this.insert(new Boolean0Data(s4_original));
                            Objects.requireNonNull((InteropLibrary)s4_.insert((Node)interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s4_.interop_ = interop__1;
                        } while (!BOOLEAN0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s4_original, (Object)s4_));
                        this.state_0_ = state_0 |= 0x40;
                    }
                    if (s4_ != null) {
                        return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                    }
                }
                InteropLibrary interop__1 = null;
                EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                Node prev_2 = encapsulating_2.set((Node)this);
                try {
                    interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__1.isBoolean(arg1Value)) {
                        this.boolean0_cache = null;
                        state_0 &= 0xFFFFFFBF;
                        this.state_0_ = state_0 |= 0x80;
                        Short s = this.doBoolean(arg0Value, arg1Value, interop__1);
                        return s;
                    }
                }
                finally {
                    encapsulating_2.set(prev_2);
                }
                this.state_0_ = state_0 |= 0x100;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 0x100;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt16.class)
            @DenyReplace
            private static final class ShortData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ShortData next_;
                @Node.Child
                InteropLibrary interop_;

                ShortData(ShortData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt16.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int number0_state_0_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt16.class)
            @DenyReplace
            private static final class Boolean0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Boolean0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt16.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToInt16
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Short) {
                        short arg1Value_ = (Short)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return SimpleTypeCachedState.ToInt16.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this, InlinedBranchProfile.getUncached());
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value)) {
                        return this.doBoolean(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.FromUInt16.class)
    static final class FromUInt16Factory
    implements NodeFactory<SimpleTypeCachedState.FromUInt16> {
        private static final FromUInt16Factory FROM_UINT16FACTORY_INSTANCE = new FromUInt16Factory();

        private FromUInt16Factory() {
        }

        public Class<SimpleTypeCachedState.FromUInt16> getNodeClass() {
            return SimpleTypeCachedState.FromUInt16.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.FromUInt16 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FromUInt16Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.FromUInt16 getUncachedInstance() {
            return FromUInt16NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.FromUInt16> getInstance() {
            return FROM_UINT16FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromUInt16 create() {
            return new FromUInt16NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromUInt16 getUncached() {
            return FromUInt16NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.FromUInt16.class)
        static final class FromUInt16NodeGen
        extends SimpleTypeCachedState.FromUInt16
        implements GenerateAOT.Provider {
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private FromUInt16NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                return (state_0 & 2) != 0 || !(arg1Value instanceof Short);
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Short) {
                        short arg1Value_ = (Short)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return this.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (Short)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 4;
                return this.doOther(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 4;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.FromUInt16.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.FromUInt16
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Short) {
                        short arg1Value_ = (Short)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    return this.doOther(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToInt32.class)
    static final class ToInt32Factory
    implements NodeFactory<SimpleTypeCachedState.ToInt32> {
        private static final ToInt32Factory TO_INT32FACTORY_INSTANCE = new ToInt32Factory();

        private ToInt32Factory() {
        }

        public Class<SimpleTypeCachedState.ToInt32> getNodeClass() {
            return SimpleTypeCachedState.ToInt32.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToInt32 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToInt32Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToInt32 getUncachedInstance() {
            return ToInt32NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToInt32> getInstance() {
            return TO_INT32FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt32 create() {
            return new ToInt32NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt32 getUncached() {
            return ToInt32NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToInt32.class)
        static final class ToInt32NodeGen
        extends SimpleTypeCachedState.ToInt32
        implements GenerateAOT.Provider {
            private static final InlineSupport.StateField NUMBER0_TO_INT32_NUMBER0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Number0Data.lookup_(), (String)"number0_state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NUMBER0_TO_INT32_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField STATE_0_ToInt32_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToInt32_UPDATER.subUpdater(9, 1)}));
            static final InlineSupport.ReferenceField<IntData> INT_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"int_cache", IntData.class);
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private IntData int_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Boolean0Data boolean0_cache;

            private ToInt32NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 0x20) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x80) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x1F6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Integer) {
                        int arg1Value_ = (Integer)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x1F4) != 0) {
                        Node prev_;
                        EncapsulatingNodeReference encapsulating_;
                        if ((state_0 & 4) != 0) {
                            IntData s1_ = this.int_cache;
                            while (s1_ != null) {
                                if (s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInInt(arg1Value)) {
                                    try {
                                        return this.doInt(arg0Value, arg1Value, s1_.interop_);
                                    }
                                    catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        this.int_cache = null;
                                        return this.executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0x10) != 0) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    Number0Data node__ = s2_;
                                    return SimpleTypeCachedState.ToInt32.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__.isNumber(arg1Value)) {
                                    Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x40) != 0) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if (s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value)) {
                                    return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0x80) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__1.isBoolean(arg1Value)) {
                                    Object object = this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x100) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return this.doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                ToInt32NodeGen node__ = this;
                return SimpleTypeCachedState.ToInt32.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
            }

            @CompilerDirectives.TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doBoolean(arg0Value, arg1Value, interop__1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 0x34) == 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x30) == 0 && (state_0 & 8) == 0) {
                    IntData s1_;
                    block25: {
                        IntData s1_original;
                        do {
                            InteropLibrary interop__2;
                            int count1_ = 0;
                            s1_original = s1_ = (IntData)((Object)INT_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s1_ == null || s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInInt(arg1Value))) {
                                ++count1_;
                                s1_ = s1_.next_;
                            }
                            if (s1_ != null || !(interop__2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).fitsInInt(arg1Value) || count1_ >= 3) break block25;
                            s1_ = (IntData)this.insert(new IntData(s1_original));
                            Objects.requireNonNull((InteropLibrary)s1_.insert((Node)interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.interop_ = interop__2;
                        } while (!INT_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s1_ != null) {
                        try {
                            return this.doInt(arg0Value, arg1Value, s1_.interop_);
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.int_cache = null;
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                }
                Node node__ = null;
                if ((state_0 & 0x20) == 0) {
                    Number0Data s2_;
                    block26: {
                        Number0Data s2_original;
                        do {
                            InteropLibrary interop__;
                            int count2_ = 0;
                            s2_original = s2_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    node__ = s2_;
                                    break;
                                }
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count2_ >= 3) break block26;
                            s2_ = (Number0Data)this.insert(new Number0Data(s2_original));
                            Objects.requireNonNull((InteropLibrary)s2_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__;
                            node__ = s2_;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.int_cache = null;
                        state_0 &= 0xFFFFFFF9;
                        this.state_0_ = state_0 |= 0x10;
                    }
                    if (s2_ != null) {
                        return SimpleTypeCachedState.ToInt32.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                    }
                }
                node__ = null;
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.isNumber(arg1Value)) {
                        node__ = this;
                        this.int_cache = null;
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFE9;
                        this.state_0_ = state_0 |= 0x20;
                        Integer n = SimpleTypeCachedState.ToInt32.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                        return n;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x80) == 0) {
                    Boolean0Data s4_;
                    block28: {
                        Boolean0Data s4_original;
                        do {
                            InteropLibrary interop__1;
                            int count4_ = 0;
                            s4_original = s4_ = (Boolean0Data)((Object)BOOLEAN0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s4_ == null || s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value))) {
                                ++count4_;
                                s4_ = s4_.next_;
                            }
                            if (s4_ != null || !(interop__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isBoolean(arg1Value) || count4_ >= 3) break block28;
                            s4_ = (Boolean0Data)this.insert(new Boolean0Data(s4_original));
                            Objects.requireNonNull((InteropLibrary)s4_.insert((Node)interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s4_.interop_ = interop__1;
                        } while (!BOOLEAN0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s4_original, (Object)s4_));
                        this.state_0_ = state_0 |= 0x40;
                    }
                    if (s4_ != null) {
                        return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                    }
                }
                InteropLibrary interop__1 = null;
                EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                Node prev_2 = encapsulating_2.set((Node)this);
                try {
                    interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__1.isBoolean(arg1Value)) {
                        this.boolean0_cache = null;
                        state_0 &= 0xFFFFFFBF;
                        this.state_0_ = state_0 |= 0x80;
                        Integer n = this.doBoolean(arg0Value, arg1Value, interop__1);
                        return n;
                    }
                }
                finally {
                    encapsulating_2.set(prev_2);
                }
                this.state_0_ = state_0 |= 0x100;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 0x100;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt32.class)
            @DenyReplace
            private static final class IntData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                IntData next_;
                @Node.Child
                InteropLibrary interop_;

                IntData(IntData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt32.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int number0_state_0_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt32.class)
            @DenyReplace
            private static final class Boolean0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Boolean0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt32.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToInt32
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (Integer)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return SimpleTypeCachedState.ToInt32.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this, InlinedBranchProfile.getUncached());
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value)) {
                        return this.doBoolean(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.FromUInt32.class)
    static final class FromUInt32Factory
    implements NodeFactory<SimpleTypeCachedState.FromUInt32> {
        private static final FromUInt32Factory FROM_UINT32FACTORY_INSTANCE = new FromUInt32Factory();

        private FromUInt32Factory() {
        }

        public Class<SimpleTypeCachedState.FromUInt32> getNodeClass() {
            return SimpleTypeCachedState.FromUInt32.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.FromUInt32 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FromUInt32Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.FromUInt32 getUncachedInstance() {
            return FromUInt32NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.FromUInt32> getInstance() {
            return FROM_UINT32FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromUInt32 create() {
            return new FromUInt32NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromUInt32 getUncached() {
            return FromUInt32NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.FromUInt32.class)
        static final class FromUInt32NodeGen
        extends SimpleTypeCachedState.FromUInt32
        implements GenerateAOT.Provider {
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private FromUInt32NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                return (state_0 & 2) != 0 || !(arg1Value instanceof Integer);
            }

            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Integer) {
                        int arg1Value_ = (Integer)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return this.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 4;
                return this.doOther(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 4;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.FromUInt32.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.FromUInt32
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (Integer)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    return this.doOther(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToInt64.class)
    static final class ToInt64Factory
    implements NodeFactory<SimpleTypeCachedState.ToInt64> {
        private static final ToInt64Factory TO_INT64FACTORY_INSTANCE = new ToInt64Factory();

        private ToInt64Factory() {
        }

        public Class<SimpleTypeCachedState.ToInt64> getNodeClass() {
            return SimpleTypeCachedState.ToInt64.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToInt64 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToInt64Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToInt64 getUncachedInstance() {
            return ToInt64NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToInt64> getInstance() {
            return TO_INT64FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt64 create() {
            return new ToInt64NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToInt64 getUncached() {
            return ToInt64NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToInt64.class)
        static final class ToInt64NodeGen
        extends SimpleTypeCachedState.ToInt64
        implements GenerateAOT.Provider {
            private static final InlineSupport.StateField NUMBER0_TO_INT64_NUMBER0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Number0Data.lookup_(), (String)"number0_state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NUMBER0_TO_INT64_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField STATE_0_ToInt64_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToInt64_UPDATER.subUpdater(9, 1)}));
            static final InlineSupport.ReferenceField<LongData> LONG_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"long_cache", LongData.class);
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private LongData long_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Boolean0Data boolean0_cache;

            private ToInt64NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 0x20) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x80) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x1F6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x1F4) != 0) {
                        Node prev_;
                        EncapsulatingNodeReference encapsulating_;
                        if ((state_0 & 4) != 0) {
                            LongData s1_ = this.long_cache;
                            while (s1_ != null) {
                                if (s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInLong(arg1Value)) {
                                    try {
                                        return this.doLong(arg0Value, arg1Value, s1_.interop_);
                                    }
                                    catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        this.long_cache = null;
                                        return this.executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0x10) != 0) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    Number0Data node__ = s2_;
                                    return SimpleTypeCachedState.ToInt64.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__.isNumber(arg1Value)) {
                                    Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x40) != 0) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if (s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value)) {
                                    return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0x80) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__1.isBoolean(arg1Value)) {
                                    Object object = this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x100) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return this.doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                ToInt64NodeGen node__ = this;
                return SimpleTypeCachedState.ToInt64.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
            }

            @CompilerDirectives.TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doBoolean(arg0Value, arg1Value, interop__1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 0x34) == 0 && arg1Value instanceof Long) {
                    long arg1Value_ = (Long)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x30) == 0 && (state_0 & 8) == 0) {
                    LongData s1_;
                    block25: {
                        LongData s1_original;
                        do {
                            InteropLibrary interop__2;
                            int count1_ = 0;
                            s1_original = s1_ = (LongData)((Object)LONG_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s1_ == null || s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInLong(arg1Value))) {
                                ++count1_;
                                s1_ = s1_.next_;
                            }
                            if (s1_ != null || !(interop__2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).fitsInLong(arg1Value) || count1_ >= 3) break block25;
                            s1_ = (LongData)this.insert(new LongData(s1_original));
                            Objects.requireNonNull((InteropLibrary)s1_.insert((Node)interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.interop_ = interop__2;
                        } while (!LONG_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s1_ != null) {
                        try {
                            return this.doLong(arg0Value, arg1Value, s1_.interop_);
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.long_cache = null;
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                }
                Node node__ = null;
                if ((state_0 & 0x20) == 0) {
                    Number0Data s2_;
                    block26: {
                        Number0Data s2_original;
                        do {
                            InteropLibrary interop__;
                            int count2_ = 0;
                            s2_original = s2_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    node__ = s2_;
                                    break;
                                }
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count2_ >= 3) break block26;
                            s2_ = (Number0Data)this.insert(new Number0Data(s2_original));
                            Objects.requireNonNull((InteropLibrary)s2_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__;
                            node__ = s2_;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.long_cache = null;
                        state_0 &= 0xFFFFFFF9;
                        this.state_0_ = state_0 |= 0x10;
                    }
                    if (s2_ != null) {
                        return SimpleTypeCachedState.ToInt64.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                    }
                }
                node__ = null;
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.isNumber(arg1Value)) {
                        node__ = this;
                        this.long_cache = null;
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFE9;
                        this.state_0_ = state_0 |= 0x20;
                        Long l = SimpleTypeCachedState.ToInt64.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                        return l;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x80) == 0) {
                    Boolean0Data s4_;
                    block28: {
                        Boolean0Data s4_original;
                        do {
                            InteropLibrary interop__1;
                            int count4_ = 0;
                            s4_original = s4_ = (Boolean0Data)((Object)BOOLEAN0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s4_ == null || s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value))) {
                                ++count4_;
                                s4_ = s4_.next_;
                            }
                            if (s4_ != null || !(interop__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isBoolean(arg1Value) || count4_ >= 3) break block28;
                            s4_ = (Boolean0Data)this.insert(new Boolean0Data(s4_original));
                            Objects.requireNonNull((InteropLibrary)s4_.insert((Node)interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s4_.interop_ = interop__1;
                        } while (!BOOLEAN0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s4_original, (Object)s4_));
                        this.state_0_ = state_0 |= 0x40;
                    }
                    if (s4_ != null) {
                        return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                    }
                }
                InteropLibrary interop__1 = null;
                EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                Node prev_2 = encapsulating_2.set((Node)this);
                try {
                    interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__1.isBoolean(arg1Value)) {
                        this.boolean0_cache = null;
                        state_0 &= 0xFFFFFFBF;
                        this.state_0_ = state_0 |= 0x80;
                        Long l = this.doBoolean(arg0Value, arg1Value, interop__1);
                        return l;
                    }
                }
                finally {
                    encapsulating_2.set(prev_2);
                }
                this.state_0_ = state_0 |= 0x100;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 0x100;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt64.class)
            @DenyReplace
            private static final class LongData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                LongData next_;
                @Node.Child
                InteropLibrary interop_;

                LongData(LongData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt64.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int number0_state_0_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt64.class)
            @DenyReplace
            private static final class Boolean0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Boolean0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToInt64.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToInt64
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Long) {
                        long arg1Value_ = (Long)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return SimpleTypeCachedState.ToInt64.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this, InlinedBranchProfile.getUncached());
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value)) {
                        return this.doBoolean(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToFloat.class)
    static final class ToFloatFactory
    implements NodeFactory<SimpleTypeCachedState.ToFloat> {
        private static final ToFloatFactory TO_FLOAT_FACTORY_INSTANCE = new ToFloatFactory();

        private ToFloatFactory() {
        }

        public Class<SimpleTypeCachedState.ToFloat> getNodeClass() {
            return SimpleTypeCachedState.ToFloat.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToFloat createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToFloatFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToFloat getUncachedInstance() {
            return ToFloatNodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToFloat> getInstance() {
            return TO_FLOAT_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToFloat create() {
            return new ToFloatNodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToFloat getUncached() {
            return ToFloatNodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToFloat.class)
        static final class ToFloatNodeGen
        extends SimpleTypeCachedState.ToFloat
        implements GenerateAOT.Provider {
            private static final InlineSupport.StateField NUMBER0_TO_FLOAT_NUMBER0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Number0Data.lookup_(), (String)"number0_state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NUMBER0_TO_FLOAT_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField STATE_0_ToFloat_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToFloat_UPDATER.subUpdater(10, 1)}));
            static final InlineSupport.ReferenceField<FloatData> FLOAT_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"float_cache", FloatData.class);
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private FloatData float_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Boolean0Data boolean0_cache;

            private ToFloatNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 0x20) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x100) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x3F6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Float) {
                        float arg1Value_ = ((Float)arg1Value).floatValue();
                        return Float.valueOf(this.doPrimitive(arg0Value, arg1Value_));
                    }
                    if ((state_0 & 0x40) != 0 && arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return Float.valueOf(this.doPrimitive(arg0Value, arg1Value_));
                    }
                    if ((state_0 & 0x3B4) != 0) {
                        Node prev_;
                        EncapsulatingNodeReference encapsulating_;
                        if ((state_0 & 4) != 0) {
                            FloatData s2_ = this.float_cache;
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.fitsInFloat(arg1Value)) {
                                    try {
                                        return Float.valueOf(this.doFloat(arg0Value, arg1Value, s2_.interop_));
                                    }
                                    catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        this.float_cache = null;
                                        return this.executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0x10) != 0) {
                            Number0Data s3_ = this.number0_cache;
                            while (s3_ != null) {
                                if (s3_.interop_.accepts(arg1Value) && s3_.interop_.isNumber(arg1Value)) {
                                    Number0Data node__ = s3_;
                                    return Float.valueOf(SimpleTypeCachedState.ToFloat.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_));
                                }
                                s3_ = s3_.next_;
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__.isNumber(arg1Value)) {
                                    Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x80) != 0) {
                            Boolean0Data s5_ = this.boolean0_cache;
                            while (s5_ != null) {
                                if (s5_.interop_.accepts(arg1Value) && s5_.interop_.isBoolean(arg1Value)) {
                                    return Float.valueOf(this.doBoolean(arg0Value, arg1Value, s5_.interop_));
                                }
                                s5_ = s5_.next_;
                            }
                        }
                        if ((state_0 & 0x100) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__1.isBoolean(arg1Value)) {
                                    Object object = this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x200) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return this.doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                ToFloatNodeGen node__ = this;
                return Float.valueOf(SimpleTypeCachedState.ToFloat.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_));
            }

            @CompilerDirectives.TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return Float.valueOf(this.doBoolean(arg0Value, arg1Value, interop__1));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 0x34) == 0 && arg1Value instanceof Float) {
                    float arg1Value_ = ((Float)arg1Value).floatValue();
                    this.state_0_ = state_0 |= 2;
                    return Float.valueOf(this.doPrimitive(arg0Value, arg1Value_));
                }
                if ((state_0 & 0x34) == 0 && arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    this.state_0_ = state_0 |= 0x40;
                    return Float.valueOf(this.doPrimitive(arg0Value, arg1Value_));
                }
                if ((state_0 & 0x30) == 0 && (state_0 & 8) == 0) {
                    FloatData s2_;
                    block26: {
                        FloatData s2_original;
                        do {
                            InteropLibrary interop__2;
                            int count2_ = 0;
                            s2_original = s2_ = (FloatData)((Object)FLOAT_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s2_ == null || s2_.interop_.accepts(arg1Value) && s2_.interop_.fitsInFloat(arg1Value))) {
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(interop__2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).fitsInFloat(arg1Value) || count2_ >= 3) break block26;
                            s2_ = (FloatData)this.insert(new FloatData(s2_original));
                            Objects.requireNonNull((InteropLibrary)s2_.insert((Node)interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__2;
                        } while (!FLOAT_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        state_0 &= 0xFFFFFFBD;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s2_ != null) {
                        try {
                            return Float.valueOf(this.doFloat(arg0Value, arg1Value, s2_.interop_));
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.float_cache = null;
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                }
                Node node__ = null;
                if ((state_0 & 0x20) == 0) {
                    Number0Data s3_;
                    block27: {
                        Number0Data s3_original;
                        do {
                            InteropLibrary interop__;
                            int count3_ = 0;
                            s3_original = s3_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s3_ != null) {
                                if (s3_.interop_.accepts(arg1Value) && s3_.interop_.isNumber(arg1Value)) {
                                    node__ = s3_;
                                    break;
                                }
                                ++count3_;
                                s3_ = s3_.next_;
                            }
                            if (s3_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count3_ >= 3) break block27;
                            s3_ = (Number0Data)this.insert(new Number0Data(s3_original));
                            Objects.requireNonNull((InteropLibrary)s3_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s3_.interop_ = interop__;
                            node__ = s3_;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s3_original, (Object)s3_));
                        this.float_cache = null;
                        state_0 &= 0xFFFFFFB9;
                        this.state_0_ = state_0 |= 0x10;
                    }
                    if (s3_ != null) {
                        return Float.valueOf(SimpleTypeCachedState.ToFloat.doNumber(arg0Value, arg1Value, s3_.interop_, node__, INLINED_NUMBER0_EXCEPTION_));
                    }
                }
                node__ = null;
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.isNumber(arg1Value)) {
                        node__ = this;
                        this.float_cache = null;
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFA9;
                        this.state_0_ = state_0 |= 0x20;
                        Float f = Float.valueOf(SimpleTypeCachedState.ToFloat.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_));
                        return f;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x100) == 0) {
                    Boolean0Data s5_;
                    block29: {
                        Boolean0Data s5_original;
                        do {
                            InteropLibrary interop__1;
                            int count5_ = 0;
                            s5_original = s5_ = (Boolean0Data)((Object)BOOLEAN0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s5_ == null || s5_.interop_.accepts(arg1Value) && s5_.interop_.isBoolean(arg1Value))) {
                                ++count5_;
                                s5_ = s5_.next_;
                            }
                            if (s5_ != null || !(interop__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isBoolean(arg1Value) || count5_ >= 3) break block29;
                            s5_ = (Boolean0Data)this.insert(new Boolean0Data(s5_original));
                            Objects.requireNonNull((InteropLibrary)s5_.insert((Node)interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s5_.interop_ = interop__1;
                        } while (!BOOLEAN0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s5_original, (Object)s5_));
                        this.state_0_ = state_0 |= 0x80;
                    }
                    if (s5_ != null) {
                        return Float.valueOf(this.doBoolean(arg0Value, arg1Value, s5_.interop_));
                    }
                }
                InteropLibrary interop__1 = null;
                EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                Node prev_2 = encapsulating_2.set((Node)this);
                try {
                    interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__1.isBoolean(arg1Value)) {
                        this.boolean0_cache = null;
                        state_0 &= 0xFFFFFF7F;
                        this.state_0_ = state_0 |= 0x100;
                        Float f = Float.valueOf(this.doBoolean(arg0Value, arg1Value, interop__1));
                        return f;
                    }
                }
                finally {
                    encapsulating_2.set(prev_2);
                }
                this.state_0_ = state_0 |= 0x200;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 0x40;
                this.state_0_ |= 0x200;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFloat.class)
            @DenyReplace
            private static final class FloatData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                FloatData next_;
                @Node.Child
                InteropLibrary interop_;

                FloatData(FloatData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFloat.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int number0_state_0_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFloat.class)
            @DenyReplace
            private static final class Boolean0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Boolean0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFloat.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToFloat
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Float) {
                        float arg1Value_ = ((Float)arg1Value).floatValue();
                        return Float.valueOf(this.doPrimitive(arg0Value, arg1Value_));
                    }
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return Float.valueOf(this.doPrimitive(arg0Value, arg1Value_));
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return Float.valueOf(SimpleTypeCachedState.ToFloat.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this, InlinedBranchProfile.getUncached()));
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value)) {
                        return Float.valueOf(this.doBoolean(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToDouble.class)
    static final class ToDoubleFactory
    implements NodeFactory<SimpleTypeCachedState.ToDouble> {
        private static final ToDoubleFactory TO_DOUBLE_FACTORY_INSTANCE = new ToDoubleFactory();

        private ToDoubleFactory() {
        }

        public Class<SimpleTypeCachedState.ToDouble> getNodeClass() {
            return SimpleTypeCachedState.ToDouble.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToDouble createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToDoubleFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToDouble getUncachedInstance() {
            return ToDoubleNodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToDouble> getInstance() {
            return TO_DOUBLE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToDouble create() {
            return new ToDoubleNodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToDouble getUncached() {
            return ToDoubleNodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToDouble.class)
        static final class ToDoubleNodeGen
        extends SimpleTypeCachedState.ToDouble
        implements GenerateAOT.Provider {
            private static final InlineSupport.StateField NUMBER0_TO_DOUBLE_NUMBER0_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Number0Data.lookup_(), (String)"number0_state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER0_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NUMBER0_TO_DOUBLE_NUMBER0_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField STATE_0_ToDouble_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_NUMBER1_EXCEPTION_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToDouble_UPDATER.subUpdater(9, 1)}));
            static final InlineSupport.ReferenceField<DoubleData> DOUBLE_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"double_cache", DoubleData.class);
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Boolean0Data> BOOLEAN0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"boolean0_cache", Boolean0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private DoubleData double_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Boolean0Data boolean0_cache;

            private ToDoubleNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 0x20) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x80) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isBoolean(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x1F6) != 0) {
                    if ((state_0 & 2) != 0 && arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0x1F4) != 0) {
                        Node prev_;
                        EncapsulatingNodeReference encapsulating_;
                        if ((state_0 & 4) != 0) {
                            DoubleData s1_ = this.double_cache;
                            while (s1_ != null) {
                                if (s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInDouble(arg1Value)) {
                                    try {
                                        return this.doDouble(arg0Value, arg1Value, s1_.interop_);
                                    }
                                    catch (UnsupportedMessageException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        this.double_cache = null;
                                        return this.executeAndSpecialize(arg0Value, arg1Value);
                                    }
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 0x10) != 0) {
                            Number0Data s2_ = this.number0_cache;
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    Number0Data node__ = s2_;
                                    return SimpleTypeCachedState.ToDouble.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__.isNumber(arg1Value)) {
                                    Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x40) != 0) {
                            Boolean0Data s4_ = this.boolean0_cache;
                            while (s4_ != null) {
                                if (s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value)) {
                                    return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                                }
                                s4_ = s4_.next_;
                            }
                        }
                        if ((state_0 & 0x80) != 0) {
                            encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            prev_ = encapsulating_.set((Node)this);
                            try {
                                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                                if (interop__1.isBoolean(arg1Value)) {
                                    Object object = this.boolean1Boundary(state_0, arg0Value, arg1Value);
                                    return object;
                                }
                            }
                            finally {
                                encapsulating_.set(prev_);
                            }
                        }
                        if ((state_0 & 0x100) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return this.doFail(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                ToDoubleNodeGen node__ = this;
                return SimpleTypeCachedState.ToDouble.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
            }

            @CompilerDirectives.TruffleBoundary
            private Object boolean1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doBoolean(arg0Value, arg1Value, interop__1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 0x34) == 0 && arg1Value instanceof Double) {
                    double arg1Value_ = (Double)arg1Value;
                    this.state_0_ = state_0 |= 2;
                    return this.doPrimitive(arg0Value, arg1Value_);
                }
                if ((state_0 & 0x30) == 0 && (state_0 & 8) == 0) {
                    DoubleData s1_;
                    block25: {
                        DoubleData s1_original;
                        do {
                            InteropLibrary interop__2;
                            int count1_ = 0;
                            s1_original = s1_ = (DoubleData)((Object)DOUBLE_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s1_ == null || s1_.interop_.accepts(arg1Value) && s1_.interop_.fitsInDouble(arg1Value))) {
                                ++count1_;
                                s1_ = s1_.next_;
                            }
                            if (s1_ != null || !(interop__2 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).fitsInDouble(arg1Value) || count1_ >= 3) break block25;
                            s1_ = (DoubleData)this.insert(new DoubleData(s1_original));
                            Objects.requireNonNull((InteropLibrary)s1_.insert((Node)interop__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.interop_ = interop__2;
                        } while (!DOUBLE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s1_ != null) {
                        try {
                            return this.doDouble(arg0Value, arg1Value, s1_.interop_);
                        }
                        catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_ = state_0 |= 8;
                            this.double_cache = null;
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                }
                Node node__ = null;
                if ((state_0 & 0x20) == 0) {
                    Number0Data s2_;
                    block26: {
                        Number0Data s2_original;
                        do {
                            InteropLibrary interop__;
                            int count2_ = 0;
                            s2_original = s2_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (s2_ != null) {
                                if (s2_.interop_.accepts(arg1Value) && s2_.interop_.isNumber(arg1Value)) {
                                    node__ = s2_;
                                    break;
                                }
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count2_ >= 3) break block26;
                            s2_ = (Number0Data)this.insert(new Number0Data(s2_original));
                            Objects.requireNonNull((InteropLibrary)s2_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.interop_ = interop__;
                            node__ = s2_;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.double_cache = null;
                        state_0 &= 0xFFFFFFF9;
                        this.state_0_ = state_0 |= 0x10;
                    }
                    if (s2_ != null) {
                        return SimpleTypeCachedState.ToDouble.doNumber(arg0Value, arg1Value, s2_.interop_, node__, INLINED_NUMBER0_EXCEPTION_);
                    }
                }
                node__ = null;
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.isNumber(arg1Value)) {
                        node__ = this;
                        this.double_cache = null;
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFE9;
                        this.state_0_ = state_0 |= 0x20;
                        Double d = SimpleTypeCachedState.ToDouble.doNumber(arg0Value, arg1Value, interop__, node__, INLINED_NUMBER1_EXCEPTION_);
                        return d;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x80) == 0) {
                    Boolean0Data s4_;
                    block28: {
                        Boolean0Data s4_original;
                        do {
                            InteropLibrary interop__1;
                            int count4_ = 0;
                            s4_original = s4_ = (Boolean0Data)((Object)BOOLEAN0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s4_ == null || s4_.interop_.accepts(arg1Value) && s4_.interop_.isBoolean(arg1Value))) {
                                ++count4_;
                                s4_ = s4_.next_;
                            }
                            if (s4_ != null || !(interop__1 = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isBoolean(arg1Value) || count4_ >= 3) break block28;
                            s4_ = (Boolean0Data)this.insert(new Boolean0Data(s4_original));
                            Objects.requireNonNull((InteropLibrary)s4_.insert((Node)interop__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s4_.interop_ = interop__1;
                        } while (!BOOLEAN0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s4_original, (Object)s4_));
                        this.state_0_ = state_0 |= 0x40;
                    }
                    if (s4_ != null) {
                        return this.doBoolean(arg0Value, arg1Value, s4_.interop_);
                    }
                }
                InteropLibrary interop__1 = null;
                EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                Node prev_2 = encapsulating_2.set((Node)this);
                try {
                    interop__1 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__1.isBoolean(arg1Value)) {
                        this.boolean0_cache = null;
                        state_0 &= 0xFFFFFFBF;
                        this.state_0_ = state_0 |= 0x80;
                        Double d = this.doBoolean(arg0Value, arg1Value, interop__1);
                        return d;
                    }
                }
                finally {
                    encapsulating_2.set(prev_2);
                }
                this.state_0_ = state_0 |= 0x100;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 2;
                this.state_0_ |= 0x100;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToDouble.class)
            @DenyReplace
            private static final class DoubleData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                DoubleData next_;
                @Node.Child
                InteropLibrary interop_;

                DoubleData(DoubleData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToDouble.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int number0_state_0_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToDouble.class)
            @DenyReplace
            private static final class Boolean0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Boolean0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Boolean0Data(Boolean0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToDouble.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToDouble
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return this.doPrimitive(arg0Value, arg1Value_);
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return SimpleTypeCachedState.ToDouble.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), this, InlinedBranchProfile.getUncached());
                    }
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isBoolean(arg1Value)) {
                        return this.doBoolean(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToFP80.class)
    static final class ToFP80Factory
    implements NodeFactory<SimpleTypeCachedState.ToFP80> {
        private static final ToFP80Factory TO_FP80FACTORY_INSTANCE = new ToFP80Factory();

        private ToFP80Factory() {
        }

        public Class<SimpleTypeCachedState.ToFP80> getNodeClass() {
            return SimpleTypeCachedState.ToFP80.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToFP80 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToFP80Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToFP80 getUncachedInstance() {
            return ToFP80NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToFP80> getInstance() {
            return TO_FP80FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToFP80 create() {
            return new ToFP80NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToFP80 getUncached() {
            return ToFP80NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToFP80.class)
        static final class ToFP80NodeGen
        extends SimpleTypeCachedState.ToFP80
        implements GenerateAOT.Provider {
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Serializable0Data> SERIALIZABLE0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"serializable0_cache", Serializable0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Serializable0Data serializable0_cache;

            private ToFP80NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 4) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x10) != 0 || !((SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached()).isSerializable(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x3E) != 0) {
                    Node prev_;
                    EncapsulatingNodeReference encapsulating_;
                    if ((state_0 & 2) != 0) {
                        Number0Data s0_ = this.number0_cache;
                        while (s0_ != null) {
                            if (s0_.interop_.accepts(arg1Value) && s0_.interop_.isNumber(arg1Value)) {
                                return this.doNumber(arg0Value, arg1Value, s0_.interop_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (interop__.isNumber(arg1Value)) {
                                Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        Serializable0Data s2_ = this.serializable0_cache;
                        while (s2_ != null) {
                            if (s2_.serialize_.accepts(arg1Value) && s2_.serialize_.isSerializable(arg1Value)) {
                                return this.doSerializable(arg0Value, arg1Value, s2_.serialize_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        prev_ = encapsulating_.set((Node)this);
                        try {
                            SerializableLibrary serialize__ = (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached();
                            if (serialize__.isSerializable(arg1Value)) {
                                Object object = this.serializable1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return this.doFail(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doNumber(arg0Value, arg1Value, interop__);
            }

            @CompilerDirectives.TruffleBoundary
            private Object serializable1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                SerializableLibrary serialize__ = (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached();
                return this.doSerializable(arg0Value, arg1Value, serialize__);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                Object interop__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 4) == 0) {
                    Number0Data s0_;
                    block17: {
                        Number0Data s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s0_ == null || s0_.interop_.accepts(arg1Value) && s0_.interop_.isNumber(arg1Value))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count0_ >= 3) break block17;
                            s0_ = (Number0Data)this.insert(new Number0Data(s0_original));
                            Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s0_ != null) {
                        return this.doNumber(arg0Value, arg1Value, s0_.interop_);
                    }
                }
                InteropLibrary interop__2 = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__2 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__2.isNumber(arg1Value)) {
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        interop__ = this.doNumber(arg0Value, arg1Value, interop__2);
                        return interop__;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x10) == 0) {
                    Serializable0Data s2_;
                    block19: {
                        Serializable0Data s2_original;
                        do {
                            SerializableLibrary serialize__;
                            int count2_ = 0;
                            s2_original = s2_ = (Serializable0Data)((Object)SERIALIZABLE0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s2_ == null || s2_.serialize_.accepts(arg1Value) && s2_.serialize_.isSerializable(arg1Value))) {
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(serialize__ = (SerializableLibrary)this.insert((Node)((SerializableLibrary)SERIALIZABLE_LIBRARY_.create(arg1Value)))).isSerializable(arg1Value) || count2_ >= 3) break block19;
                            s2_ = (Serializable0Data)this.insert(new Serializable0Data(s2_original));
                            Objects.requireNonNull((SerializableLibrary)s2_.insert((Node)serialize__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.serialize_ = serialize__;
                        } while (!SERIALIZABLE0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.state_0_ = state_0 |= 8;
                    }
                    if (s2_ != null) {
                        return this.doSerializable(arg0Value, arg1Value, s2_.serialize_);
                    }
                }
                SerializableLibrary serialize__ = null;
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    serialize__ = (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached();
                    if (serialize__.isSerializable(arg1Value)) {
                        this.serializable0_cache = null;
                        state_0 &= 0xFFFFFFF7;
                        this.state_0_ = state_0 |= 0x10;
                        Object object = this.doSerializable(arg0Value, arg1Value, serialize__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                this.state_0_ = state_0 |= 0x20;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                Serializable0Data s2_ = (Serializable0Data)this.insert(new Serializable0Data(this.serializable0_cache));
                SerializableLibrary serialize__ = (SerializableLibrary)s2_.insert((Node)((SerializableLibrary)SERIALIZABLE_LIBRARY_.createDispatched(2)));
                Objects.requireNonNull(serialize__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s2_.serialize_ = serialize__;
                VarHandle.storeStoreFence();
                this.serializable0_cache = s2_;
                if (s2_.serialize_ instanceof GenerateAOT.Provider) {
                    assert (NodeUtil.assertRecursion((Node)s2_.serialize_, (int)1));
                    ((GenerateAOT.Provider)s2_.serialize_).prepareForAOT(language, root);
                }
                this.state_0_ |= 8;
                this.state_0_ |= 0x20;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.serializable0_cache = null;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFP80.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFP80.class)
            @DenyReplace
            private static final class Serializable0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Serializable0Data next_;
                @Node.Child
                SerializableLibrary serialize_;

                Serializable0Data(Serializable0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFP80.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToFP80
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return this.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    if (((SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached(arg1Value)).isSerializable(arg1Value)) {
                        return this.doSerializable(arg0Value, arg1Value, (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.FromFP80.class)
    static final class FromFP80Factory
    implements NodeFactory<SimpleTypeCachedState.FromFP80> {
        private static final FromFP80Factory FROM_FP80FACTORY_INSTANCE = new FromFP80Factory();

        private FromFP80Factory() {
        }

        public Class<SimpleTypeCachedState.FromFP80> getNodeClass() {
            return SimpleTypeCachedState.FromFP80.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.FromFP80 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FromFP80Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.FromFP80 getUncachedInstance() {
            return FromFP80NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.FromFP80> getInstance() {
            return FROM_FP80FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromFP80 create() {
            return new FromFP80NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromFP80 getUncached() {
            return FromFP80NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.FromFP80.class)
        static final class FromFP80NodeGen
        extends SimpleTypeCachedState.FromFP80
        implements GenerateAOT.Provider {
            static final InlineSupport.ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"buffer0_cache", Buffer0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Buffer0Data buffer0_cache;

            private FromFP80NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                return (state_0 & 4) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).hasBufferElements(arg1Value) || ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0xE) != 0) {
                    Buffer0Data s0_;
                    if ((state_0 & 2) != 0 && (s0_ = this.buffer0_cache) != null && s0_.interop_.accepts(arg1Value) && s0_.interop_.hasBufferElements(arg1Value) && !s0_.interop_.isNumber(arg1Value)) {
                        return this.doBuffer(arg0Value, arg1Value, s0_.interop_);
                    }
                    if ((state_0 & 4) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (interop__.hasBufferElements(arg1Value) && !interop__.isNumber(arg1Value)) {
                                Object object = this.buffer1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return this.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object buffer1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doBuffer(arg0Value, arg1Value, interop__);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 4) == 0) {
                    Buffer0Data s0_;
                    block9: {
                        Buffer0Data s0_original;
                        do {
                            InteropLibrary interop__;
                            int count0_ = 0;
                            s0_original = s0_ = (Buffer0Data)((Object)BUFFER0_CACHE_UPDATER.getVolatile((Node)this));
                            if (!(s0_ == null || s0_.interop_.accepts(arg1Value) && s0_.interop_.hasBufferElements(arg1Value) && !s0_.interop_.isNumber(arg1Value))) {
                                ++count0_;
                                s0_ = null;
                            }
                            if (s0_ != null || count0_ >= true || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).hasBufferElements(arg1Value) || interop__.isNumber(arg1Value)) break block9;
                            s0_ = (Buffer0Data)this.insert(new Buffer0Data());
                            Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                        } while (!BUFFER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s0_ != null) {
                        return this.doBuffer(arg0Value, arg1Value, s0_.interop_);
                    }
                }
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.hasBufferElements(arg1Value) && !interop__.isNumber(arg1Value)) {
                        this.buffer0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        Object object = this.doBuffer(arg0Value, arg1Value, interop__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                this.state_0_ = state_0 |= 8;
                return this.doOther(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 8;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.FromFP80.class)
            @DenyReplace
            private static final class Buffer0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                InteropLibrary interop_;

                Buffer0Data() {
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.FromFP80.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.FromFP80
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).hasBufferElements(arg1Value) && !((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return this.doBuffer(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doOther(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.ToFP128.class)
    static final class ToFP128Factory
    implements NodeFactory<SimpleTypeCachedState.ToFP128> {
        private static final ToFP128Factory TO_FP128FACTORY_INSTANCE = new ToFP128Factory();

        private ToFP128Factory() {
        }

        public Class<SimpleTypeCachedState.ToFP128> getNodeClass() {
            return SimpleTypeCachedState.ToFP128.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.ToFP128 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ToFP128Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.ToFP128 getUncachedInstance() {
            return ToFP128NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.ToFP128> getInstance() {
            return TO_FP128FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToFP128 create() {
            return new ToFP128NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.ToFP128 getUncached() {
            return ToFP128NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.ToFP128.class)
        static final class ToFP128NodeGen
        extends SimpleTypeCachedState.ToFP128
        implements GenerateAOT.Provider {
            static final InlineSupport.ReferenceField<Number0Data> NUMBER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"number0_cache", Number0Data.class);
            static final InlineSupport.ReferenceField<Serializable0Data> SERIALIZABLE0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"serializable0_cache", Serializable0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Number0Data number0_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Serializable0Data serializable0_cache;

            private ToFP128NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                if ((state_0 & 4) == 0 && ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value)) {
                    return false;
                }
                return (state_0 & 0x10) != 0 || !((SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached()).isSerializable(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @ExplodeLoop
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0x3E) != 0) {
                    Node prev_;
                    EncapsulatingNodeReference encapsulating_;
                    if ((state_0 & 2) != 0) {
                        Number0Data s0_ = this.number0_cache;
                        while (s0_ != null) {
                            if (s0_.interop_.accepts(arg1Value) && s0_.interop_.isNumber(arg1Value)) {
                                return this.doNumber(arg0Value, arg1Value, s0_.interop_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (interop__.isNumber(arg1Value)) {
                                Object object = this.number1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        Serializable0Data s2_ = this.serializable0_cache;
                        while (s2_ != null) {
                            if (s2_.serialize_.accepts(arg1Value) && s2_.serialize_.isSerializable(arg1Value)) {
                                return this.doSerializable(arg0Value, arg1Value, s2_.serialize_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        prev_ = encapsulating_.set((Node)this);
                        try {
                            SerializableLibrary serialize__ = (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached();
                            if (serialize__.isSerializable(arg1Value)) {
                                Object object = this.serializable1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return this.doFail(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object number1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doNumber(arg0Value, arg1Value, interop__);
            }

            @CompilerDirectives.TruffleBoundary
            private Object serializable1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                SerializableLibrary serialize__ = (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached();
                return this.doSerializable(arg0Value, arg1Value, serialize__);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                Object interop__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 4) == 0) {
                    Number0Data s0_;
                    block17: {
                        Number0Data s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = (Number0Data)((Object)NUMBER0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s0_ == null || s0_.interop_.accepts(arg1Value) && s0_.interop_.isNumber(arg1Value))) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).isNumber(arg1Value) || count0_ >= 3) break block17;
                            s0_ = (Number0Data)this.insert(new Number0Data(s0_original));
                            Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                        } while (!NUMBER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s0_ != null) {
                        return this.doNumber(arg0Value, arg1Value, s0_.interop_);
                    }
                }
                InteropLibrary interop__2 = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__2 = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__2.isNumber(arg1Value)) {
                        this.number0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        interop__ = this.doNumber(arg0Value, arg1Value, interop__2);
                        return interop__;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                if ((state_0 & 0x10) == 0) {
                    Serializable0Data s2_;
                    block19: {
                        Serializable0Data s2_original;
                        do {
                            SerializableLibrary serialize__;
                            int count2_ = 0;
                            s2_original = s2_ = (Serializable0Data)((Object)SERIALIZABLE0_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s2_ == null || s2_.serialize_.accepts(arg1Value) && s2_.serialize_.isSerializable(arg1Value))) {
                                ++count2_;
                                s2_ = s2_.next_;
                            }
                            if (s2_ != null || !(serialize__ = (SerializableLibrary)this.insert((Node)((SerializableLibrary)SERIALIZABLE_LIBRARY_.create(arg1Value)))).isSerializable(arg1Value) || count2_ >= 3) break block19;
                            s2_ = (Serializable0Data)this.insert(new Serializable0Data(s2_original));
                            Objects.requireNonNull((SerializableLibrary)s2_.insert((Node)serialize__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.serialize_ = serialize__;
                        } while (!SERIALIZABLE0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s2_original, (Object)s2_));
                        this.state_0_ = state_0 |= 8;
                    }
                    if (s2_ != null) {
                        return this.doSerializable(arg0Value, arg1Value, s2_.serialize_);
                    }
                }
                SerializableLibrary serialize__ = null;
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    serialize__ = (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached();
                    if (serialize__.isSerializable(arg1Value)) {
                        this.serializable0_cache = null;
                        state_0 &= 0xFFFFFFF7;
                        this.state_0_ = state_0 |= 0x10;
                        Object object = this.doSerializable(arg0Value, arg1Value, serialize__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                this.state_0_ = state_0 |= 0x20;
                return this.doFail(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                Serializable0Data s2_ = (Serializable0Data)this.insert(new Serializable0Data(this.serializable0_cache));
                SerializableLibrary serialize__ = (SerializableLibrary)s2_.insert((Node)((SerializableLibrary)SERIALIZABLE_LIBRARY_.createDispatched(2)));
                Objects.requireNonNull(serialize__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s2_.serialize_ = serialize__;
                VarHandle.storeStoreFence();
                this.serializable0_cache = s2_;
                if (s2_.serialize_ instanceof GenerateAOT.Provider) {
                    assert (NodeUtil.assertRecursion((Node)s2_.serialize_, (int)1));
                    ((GenerateAOT.Provider)s2_.serialize_).prepareForAOT(language, root);
                }
                this.state_0_ |= 8;
                this.state_0_ |= 0x20;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
                this.serializable0_cache = null;
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFP128.class)
            @DenyReplace
            private static final class Number0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Number0Data next_;
                @Node.Child
                InteropLibrary interop_;

                Number0Data(Number0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFP128.class)
            @DenyReplace
            private static final class Serializable0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Serializable0Data next_;
                @Node.Child
                SerializableLibrary serialize_;

                Serializable0Data(Serializable0Data next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.ToFP128.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.ToFP128
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return this.doNumber(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    if (((SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached(arg1Value)).isSerializable(arg1Value)) {
                        return this.doSerializable(arg0Value, arg1Value, (SerializableLibrary)SERIALIZABLE_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doFail(arg0Value, arg1Value);
                }
            }
        }
    }

    @GeneratedBy(value=SimpleTypeCachedState.FromFP128.class)
    static final class FromFP128Factory
    implements NodeFactory<SimpleTypeCachedState.FromFP128> {
        private static final FromFP128Factory FROM_FP128FACTORY_INSTANCE = new FromFP128Factory();

        private FromFP128Factory() {
        }

        public Class<SimpleTypeCachedState.FromFP128> getNodeClass() {
            return SimpleTypeCachedState.FromFP128.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public SimpleTypeCachedState.FromFP128 createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FromFP128Factory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public SimpleTypeCachedState.FromFP128 getUncachedInstance() {
            return FromFP128NodeGen.UNCACHED;
        }

        static NodeFactory<SimpleTypeCachedState.FromFP128> getInstance() {
            return FROM_FP128FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromFP128 create() {
            return new FromFP128NodeGen();
        }

        @NeverDefault
        public static SimpleTypeCachedState.FromFP128 getUncached() {
            return FromFP128NodeGen.UNCACHED;
        }

        @GeneratedBy(value=SimpleTypeCachedState.FromFP128.class)
        static final class FromFP128NodeGen
        extends SimpleTypeCachedState.FromFP128
        implements GenerateAOT.Provider {
            static final InlineSupport.ReferenceField<Buffer0Data> BUFFER0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"buffer0_cache", Buffer0Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Buffer0Data buffer0_cache;

            private FromFP128NodeGen() {
            }

            private boolean fallbackGuard_(int state_0, NFIType arg0Value, Object arg1Value) {
                return (state_0 & 4) != 0 || !((InteropLibrary)INTEROP_LIBRARY_.getUncached()).hasBufferElements(arg1Value) || ((InteropLibrary)INTEROP_LIBRARY_.getUncached()).isNumber(arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                int state_0 = this.state_0_;
                if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                    return this.executeAndSpecialize(arg0Value, arg1Value);
                }
                if ((state_0 & 0xE) != 0) {
                    Buffer0Data s0_;
                    if ((state_0 & 2) != 0 && (s0_ = this.buffer0_cache) != null && s0_.interop_.accepts(arg1Value) && s0_.interop_.hasBufferElements(arg1Value) && !s0_.interop_.isNumber(arg1Value)) {
                        return this.doBuffer(arg0Value, arg1Value, s0_.interop_);
                    }
                    if ((state_0 & 4) != 0) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                            if (interop__.hasBufferElements(arg1Value) && !interop__.isNumber(arg1Value)) {
                                Object object = this.buffer1Boundary(state_0, arg0Value, arg1Value);
                                return object;
                            }
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return this.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            private Object buffer1Boundary(int state_0, NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                return this.doBuffer(arg0Value, arg1Value, interop__);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(NFIType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    this.resetAOT_();
                    state_0 = this.state_0_;
                }
                if ((state_0 & 4) == 0) {
                    Buffer0Data s0_;
                    block9: {
                        Buffer0Data s0_original;
                        do {
                            InteropLibrary interop__;
                            int count0_ = 0;
                            s0_original = s0_ = (Buffer0Data)((Object)BUFFER0_CACHE_UPDATER.getVolatile((Node)this));
                            if (!(s0_ == null || s0_.interop_.accepts(arg1Value) && s0_.interop_.hasBufferElements(arg1Value) && !s0_.interop_.isNumber(arg1Value))) {
                                ++count0_;
                                s0_ = null;
                            }
                            if (s0_ != null || count0_ >= true || !(interop__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)))).hasBufferElements(arg1Value) || interop__.isNumber(arg1Value)) break block9;
                            s0_ = (Buffer0Data)this.insert(new Buffer0Data());
                            Objects.requireNonNull((InteropLibrary)s0_.insert((Node)interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.interop_ = interop__;
                        } while (!BUFFER0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s0_ != null) {
                        return this.doBuffer(arg0Value, arg1Value, s0_.interop_);
                    }
                }
                InteropLibrary interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                    if (interop__.hasBufferElements(arg1Value) && !interop__.isNumber(arg1Value)) {
                        this.buffer0_cache = null;
                        state_0 &= 0xFFFFFFFD;
                        this.state_0_ = state_0 |= 4;
                        Object object = this.doBuffer(arg0Value, arg1Value, interop__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                this.state_0_ = state_0 |= 8;
                return this.doOther(arg0Value, arg1Value);
            }

            public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
                if ((this.state_0_ & 1) != 0) {
                    return;
                }
                this.state_0_ |= 8;
                int state_0 = this.state_0_;
                this.state_0_ = state_0 |= 1;
            }

            private void resetAOT_() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return;
                }
                this.state_0_ = 0;
            }

            @GeneratedBy(value=SimpleTypeCachedState.FromFP128.class)
            @DenyReplace
            private static final class Buffer0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                InteropLibrary interop_;

                Buffer0Data() {
                }
            }

            @GeneratedBy(value=SimpleTypeCachedState.FromFP128.class)
            @DenyReplace
            private static final class Uncached
            extends SimpleTypeCachedState.FromFP128
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                @CompilerDirectives.TruffleBoundary
                Object execute(NFIType arg0Value, Object arg1Value) throws UnsupportedTypeException {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).hasBufferElements(arg1Value) && !((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value)).isNumber(arg1Value)) {
                        return this.doBuffer(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value));
                    }
                    return this.doOther(arg0Value, arg1Value);
                }
            }
        }
    }
}

