/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import org.bson.BsonInvalidOperationException;
import org.bson.json.StrictJsonWriter;

public final class LessSpaceStrictJsonWriter
implements StrictJsonWriter {
    private final StringBuilder stringBuilder;
    private StrictJsonContext context = new StrictJsonContext(null, JsonContextType.TOP_LEVEL);
    private State state = State.INITIAL;
    private int curLength;

    public LessSpaceStrictJsonWriter() {
        this.stringBuilder = new StringBuilder();
    }

    public int getCurrentLength() {
        return this.curLength;
    }

    public void writeStartObject(String name) {
        this.writeName(name);
        this.writeStartObject();
    }

    public void writeStartArray(String name) {
        this.writeName(name);
        this.writeStartArray();
    }

    public void writeBoolean(String name, boolean value) {
        this.writeName(name);
        this.writeBoolean(value);
    }

    public void writeNumber(String name, String value) {
        this.writeName(name);
        this.writeNumber(value);
    }

    public void writeString(String name, String value) {
        this.writeName(name);
        this.writeString(value);
    }

    public void writeRaw(String name, String value) {
        this.writeName(name);
        this.writeRaw(value);
    }

    public void writeNull(String name) {
        this.writeName(name);
        this.writeNull();
    }

    public void writeName(String name) {
        this.checkPreconditions(State.NAME);
        if (this.context.hasElements) {
            this.write(",");
        }
        this.writeStringHelper(name);
        this.write(":");
        this.state = State.VALUE;
    }

    public void writeBoolean(boolean value) {
        this.checkPreconditions(State.VALUE);
        this.preWriteValue();
        this.write(value ? "true" : "false");
        this.setNextState();
    }

    public void writeNumber(String value) {
        this.checkPreconditions(State.VALUE);
        this.preWriteValue();
        this.write(value);
        this.setNextState();
    }

    public void writeString(String value) {
        this.checkPreconditions(State.VALUE);
        this.preWriteValue();
        this.writeStringHelper(value);
        this.setNextState();
    }

    public void writeRaw(String value) {
        this.checkPreconditions(State.VALUE);
        this.preWriteValue();
        this.write(value);
        this.setNextState();
    }

    public void writeNull() {
        this.checkPreconditions(State.VALUE);
        this.preWriteValue();
        this.write("null");
        this.setNextState();
    }

    public void writeStartObject() {
        this.checkPreconditions(State.INITIAL, State.VALUE);
        this.preWriteValue();
        this.write("{");
        this.context = new StrictJsonContext(this.context, JsonContextType.DOCUMENT);
        this.state = State.NAME;
    }

    public void writeStartArray() {
        this.preWriteValue();
        this.write("[");
        this.context = new StrictJsonContext(this.context, JsonContextType.ARRAY);
        this.state = State.VALUE;
    }

    public void writeEndObject() {
        this.checkPreconditions(State.NAME);
        this.write("}");
        this.context = this.context.parentContext;
        if (this.context.contextType == JsonContextType.TOP_LEVEL) {
            this.state = State.DONE;
        } else {
            this.setNextState();
        }
    }

    public void writeEndArray() {
        this.checkPreconditions(State.VALUE);
        if (this.context.contextType != JsonContextType.ARRAY) {
            throw new BsonInvalidOperationException("Can't end an array if not in an array");
        }
        this.write("]");
        this.context = this.context.parentContext;
        if (this.context.contextType == JsonContextType.TOP_LEVEL) {
            this.state = State.DONE;
        } else {
            this.setNextState();
        }
    }

    public boolean isTruncated() {
        return false;
    }

    public String getJson() {
        return this.stringBuilder.toString();
    }

    private void preWriteValue() {
        if (this.context.contextType == JsonContextType.ARRAY && this.context.hasElements) {
            this.write(",");
        }
        this.context.hasElements = true;
    }

    private void setNextState() {
        this.state = this.context.contextType == JsonContextType.ARRAY ? State.VALUE : State.NAME;
    }

    private void writeStringHelper(String str) {
        this.write('\"');
        if (str.contains("\"") || str.contains("\n") || str.contains("\r") || str.contains("\t") || str.contains("\\") || str.contains("\b") || str.contains("\f")) {
            block9: for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                switch (c) {
                    case '\"': {
                        this.write("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        this.write("\\\\");
                        continue block9;
                    }
                    case '\b': {
                        this.write("\\b");
                        continue block9;
                    }
                    case '\f': {
                        this.write("\\f");
                        continue block9;
                    }
                    case '\n': {
                        this.write("\\n");
                        continue block9;
                    }
                    case '\r': {
                        this.write("\\r");
                        continue block9;
                    }
                    case '\t': {
                        this.write("\\t");
                        continue block9;
                    }
                    default: {
                        this.write(c);
                    }
                }
            }
        } else {
            this.write(str);
        }
        this.write('\"');
    }

    private void write(String str) {
        this.stringBuilder.append(str);
        this.curLength += str.length();
    }

    private void write(char c) {
        this.stringBuilder.append(c);
        ++this.curLength;
    }

    private void checkPreconditions(State ... validStates) {
        if (!this.checkState(validStates)) {
            throw new BsonInvalidOperationException("Invalid state " + (Object)((Object)this.state));
        }
    }

    private boolean checkState(State ... validStates) {
        for (State cur : validStates) {
            if (cur != this.state) continue;
            return true;
        }
        return false;
    }

    private static class StrictJsonContext {
        private final StrictJsonContext parentContext;
        private final JsonContextType contextType;
        private boolean hasElements;

        StrictJsonContext(StrictJsonContext parentContext, JsonContextType contextType) {
            this.parentContext = parentContext;
            this.contextType = contextType;
        }
    }

    private static enum State {
        INITIAL,
        NAME,
        VALUE,
        DONE;

    }

    private static enum JsonContextType {
        TOP_LEVEL,
        DOCUMENT,
        ARRAY;

    }
}

