/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.sst;

import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;

public abstract class PatternTy
extends SSTNode {
    PatternTy(SourceRange sourceRange) {
        super(sourceRange);
    }

    public static final class MatchOr
    extends PatternTy {
        public final PatternTy[] patterns;

        public MatchOr(PatternTy[] patterns, SourceRange sourceRange) {
            super(sourceRange);
            this.patterns = patterns;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class MatchAs
    extends PatternTy {
        public final PatternTy pattern;
        public final String name;

        public MatchAs(PatternTy pattern, String name, SourceRange sourceRange) {
            super(sourceRange);
            this.pattern = pattern;
            this.name = name;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class MatchStar
    extends PatternTy {
        public final String name;

        public MatchStar(String name, SourceRange sourceRange) {
            super(sourceRange);
            this.name = name;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class MatchClass
    extends PatternTy {
        public final ExprTy cls;
        public final PatternTy[] patterns;
        public final String[] kwdAttrs;
        public final PatternTy[] kwdPatterns;

        public MatchClass(ExprTy cls, PatternTy[] patterns, String[] kwdAttrs, PatternTy[] kwdPatterns, SourceRange sourceRange) {
            super(sourceRange);
            assert (cls != null);
            this.cls = cls;
            this.patterns = patterns;
            this.kwdAttrs = kwdAttrs;
            this.kwdPatterns = kwdPatterns;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class MatchMapping
    extends PatternTy {
        public final ExprTy[] keys;
        public final PatternTy[] patterns;
        public final String rest;

        public MatchMapping(ExprTy[] keys, PatternTy[] patterns, String rest, SourceRange sourceRange) {
            super(sourceRange);
            this.keys = keys;
            this.patterns = patterns;
            this.rest = rest;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class MatchSequence
    extends PatternTy {
        public final PatternTy[] patterns;

        public MatchSequence(PatternTy[] patterns, SourceRange sourceRange) {
            super(sourceRange);
            this.patterns = patterns;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class MatchSingleton
    extends PatternTy {
        public final ConstantValue value;

        public MatchSingleton(ConstantValue value, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class MatchValue
    extends PatternTy {
        public final ExprTy value;

        public MatchValue(ExprTy value, SourceRange sourceRange) {
            super(sourceRange);
            assert (value != null);
            this.value = value;
        }

        @Override
        public <T> T accept(SSTreeVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }
}

