/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={MathGuards.class})
public abstract class CastToJavaShortNode
extends PNodeWithContext {
    public abstract short execute(Node var1, short var2);

    public abstract short execute(Node var1, int var2);

    public abstract short execute(Node var1, long var2);

    public abstract short execute(Node var1, Object var2);

    @Specialization
    static short fromShort(short x) {
        return x;
    }

    @Specialization(rewriteOn={OverflowException.class})
    static short fromInt(int x) throws OverflowException {
        return PInt.shortValueExact(x);
    }

    @Specialization(rewriteOn={OverflowException.class})
    static short fromLong(long x) throws OverflowException {
        return PInt.shortValueExact(x);
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    static short fromPInt(PInt x) {
        return x.shortValueExact();
    }

    @Specialization(replaces={"fromInt"})
    static short fromIntErr(Node inliningTarget, int x, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
        try {
            return PInt.shortValueExact(x);
        }
        catch (OverflowException e) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.SHORT_MUST_BE_IN_RANGE);
        }
    }

    @Specialization(replaces={"fromLong"})
    static short fromLongErr(Node inliningTarget, long x, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
        try {
            return PInt.shortValueExact(x);
        }
        catch (OverflowException e) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.SHORT_MUST_BE_IN_RANGE);
        }
    }

    @Specialization(replaces={"fromPInt"})
    static short fromPIntErr(Node inliningTarget, PInt x, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
        try {
            return x.shortValueExact();
        }
        catch (ArithmeticException e) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.SHORT_MUST_BE_IN_RANGE);
        }
    }
}

