/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.builtins.BuiltinCallNode;
import com.oracle.graal.python.nodes.function.builtins.SlotWrapper;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public final class WrapperDescrCall
extends SlotWrapper {
    private final String name;
    private final PythonBuiltinClassType type;
    @Node.Child
    IsSubtypeNode isSubtypeNode = IsSubtypeNode.create();
    @Node.Child
    GetClassNode getClassNode = GetClassNode.create();

    public WrapperDescrCall(BuiltinCallNode func, String name, PythonBuiltinClassType type) {
        super(func);
        this.name = name;
        this.type = type;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        if (PArguments.getUserArgumentLength(args) <= 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_NEED_OBJ, this.name, "_");
        }
        Object self = PArguments.getArgument(args, 0);
        Object selfClass = this.getClassNode.executeCached(self);
        if (selfClass != this.type && !this.isSubtypeNode.execute(selfClass, (Object)this.type)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, new Object[]{this.name, this.type, self});
        }
        return super.execute(frame);
    }
}

