/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyAIterCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.GetAIterNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
public abstract class GetAIterNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Object var2);

    public static GetAIterNode getUncached() {
        return GetAIterNodeGen.getUncached();
    }

    @NeverDefault
    public static GetAIterNode create() {
        return GetAIterNodeGen.create();
    }

    @Specialization
    Object doGeneric(VirtualFrame frame, Object receiver, @Bind Node inliningTarget, @Cached GetClassNode getAsyncIterType, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callSlot, @Cached PRaiseNode raiseNoAIter, @Cached PRaiseNode raiseNoANext, @Cached PyAIterCheckNode checkNode) {
        Object type = getAsyncIterType.execute(inliningTarget, receiver);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.am_aiter() == null) {
            throw raiseNoAIter.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ASYNC_FOR_NO_AITER, type);
        }
        Object asyncIterator = callSlot.execute(frame, inliningTarget, slots.am_aiter(), receiver);
        if (!checkNode.execute(inliningTarget, asyncIterator)) {
            throw raiseNoANext.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ASYNC_FOR_NO_ANEXT_INITIAL, asyncIterator);
        }
        return asyncIterator;
    }
}

