/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlotKind;

public abstract class QuickeningTypes {
    public static final byte OBJECT = 1;
    public static final byte INT = 2;
    public static final byte LONG = 4;
    public static final byte DOUBLE = 8;
    public static final byte BOOLEAN = 16;

    public static byte fromFrameSlotTag(byte tag) {
        if (tag == FrameSlotKind.Object.tag) {
            return 1;
        }
        if (tag == FrameSlotKind.Int.tag) {
            return 2;
        }
        if (tag == FrameSlotKind.Long.tag) {
            return 4;
        }
        if (tag == FrameSlotKind.Double.tag) {
            return 8;
        }
        if (tag == FrameSlotKind.Boolean.tag) {
            return 16;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Unknown stack item type");
    }

    public static byte fromObjectType(Object object) {
        if (object instanceof Integer) {
            return 2;
        }
        if (object instanceof Long) {
            return 4;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof Boolean) {
            return 16;
        }
        return 1;
    }
}

