/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.compiler.BinaryOps;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.compiler.SourceMap;
import com.oracle.graal.python.compiler.UnaryOps;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class BytecodeCodeUnit
extends CodeUnit {
    private static final int DISASSEMBLY_NUM_COLUMNS = 8;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] code;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] srcOffsetTable;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final long[] primitiveConstants;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] exceptionHandlerRanges;
    public final int stacksize;
    public final int conditionProfileCount;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] outputCanQuicken;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final byte[] variableShouldUnbox;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[][] generalizeInputsMap;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[][] generalizeVarsMap;
    @CompilerDirectives.CompilationFinal
    SourceMap sourceMap;
    public static final int LINE_TO_BCI_LINE_AFTER_CODEBLOCK = -1;
    public static final int LINE_TO_BCI_LINE_BEFORE_CODEBLOCK = -2;

    public BytecodeCodeUnit(TruffleString name, TruffleString qualname, int argCount, int kwOnlyArgCount, int positionalOnlyArgCount, int flags, TruffleString[] names, TruffleString[] varnames, TruffleString[] cellvars, TruffleString[] freevars, int[] cell2arg, Object[] constants, int startLine, int startColumn, int endLine, int endColumn, byte[] code, byte[] linetable, long[] primitiveConstants, int[] exceptionHandlerRanges, int stacksize, int conditionProfileCount, byte[] outputCanQuicken, byte[] variableShouldUnbox, int[][] generalizeInputsMap, int[][] generalizeVarsMap) {
        super(name, qualname, argCount, kwOnlyArgCount, positionalOnlyArgCount, flags, names, varnames, cellvars, freevars, cell2arg, constants, startLine, startColumn, endLine, endColumn);
        this.code = code;
        this.srcOffsetTable = linetable;
        this.primitiveConstants = primitiveConstants;
        this.exceptionHandlerRanges = exceptionHandlerRanges;
        this.stacksize = stacksize;
        this.conditionProfileCount = conditionProfileCount;
        this.outputCanQuicken = outputCanQuicken;
        this.variableShouldUnbox = variableShouldUnbox;
        this.generalizeInputsMap = generalizeInputsMap;
        this.generalizeVarsMap = generalizeVarsMap;
    }

    public SourceMap getSourceMap() {
        if (this.sourceMap == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.sourceMap = new SourceMap(this.code, this.srcOffsetTable, this.startLine, this.startColumn);
        }
        return this.sourceMap;
    }

    public int bciToLine(int bci) {
        if (bci < 0 || bci >= this.code.length) {
            return -1;
        }
        return this.getSourceMap().startLineMap[bci];
    }

    public int bciToColumn(int bci) {
        if (bci < 0 || bci >= this.code.length) {
            return -1;
        }
        return this.getSourceMap().startColumnMap[bci];
    }

    @Override
    protected void dumpBytecode(StringBuilder sb, boolean quickened) {
        int bci = 0;
        int oparg = 0;
        SourceMap map = this.getSourceMap();
        HashMap<Integer, String[]> lines = new HashMap<Integer, String[]>();
        while (bci < this.code.length) {
            int bcBCI = bci;
            OpCodes opcode = OpCodes.fromOpCode(this.code[bci++]);
            if (!quickened) {
                opcode = BytecodeCodeUnit.unquicken(opcode);
            }
            String[] line = lines.computeIfAbsent(bcBCI, k -> new String[8]);
            line[0] = String.format("%3d:%-3d - %3d:%-3d", map.startLineMap[bcBCI], map.startColumnMap[bcBCI], map.endLineMap[bcBCI], map.endColumnMap[bcBCI]);
            if (line[1] == null) {
                line[1] = "";
            }
            line[2] = String.valueOf(bcBCI);
            line[3] = opcode.toString();
            byte[] followingArgs = PythonUtils.EMPTY_BYTE_ARRAY;
            if (!opcode.hasArg()) {
                line[4] = "";
            } else {
                oparg |= Byte.toUnsignedInt(this.code[bci++]);
                if (opcode.argLength > 1) {
                    followingArgs = new byte[opcode.argLength - 1];
                    for (int i = 0; i < opcode.argLength - 1; ++i) {
                        followingArgs[i] = this.code[bci++];
                    }
                }
                line[4] = String.format("% 2d", oparg);
            }
            block29: while (true) {
                switch (opcode) {
                    case EXTENDED_ARG: {
                        line[4] = "";
                        break block29;
                    }
                    case LOAD_BYTE: {
                        line[4] = String.format("% 2d", (byte)oparg);
                        break block29;
                    }
                    case LOAD_CONST: 
                    case LOAD_BIGINT: 
                    case LOAD_STRING: 
                    case LOAD_BYTES: 
                    case LOAD_CONST_COLLECTION: 
                    case MAKE_KEYWORD: {
                        Object constant = this.constants[oparg];
                        if (constant instanceof CodeUnit) {
                            line[5] = ((CodeUnit)constant).qualname.toJavaStringUncached();
                        } else if (constant instanceof TruffleString) {
                            line[5] = StringNodes.StringReprNode.getUncached().execute((TruffleString)constant).toJavaStringUncached();
                        } else if (constant instanceof byte[]) {
                            byte[] bytes = (byte[])constant;
                            line[5] = BytesUtils.bytesRepr(bytes, bytes.length);
                        } else {
                            line[5] = constant instanceof int[] ? Arrays.toString((int[])constant) : (constant instanceof long[] ? Arrays.toString((long[])constant) : (constant instanceof boolean[] ? Arrays.toString((boolean[])constant) : (constant instanceof double[] ? Arrays.toString((double[])constant) : (constant instanceof Object[] ? Arrays.toString((Object[])constant) : Objects.toString(constant)))));
                        }
                        if (opcode != OpCodes.LOAD_CONST_COLLECTION) break block29;
                        line[5] = line[5] + " type " + BytecodeCodeUnit.collectionTypeToString(followingArgs[0]) + " into " + BytecodeCodeUnit.collectionKindToString(followingArgs[0]);
                        break block29;
                    }
                    case MAKE_FUNCTION: {
                        line[4] = String.format("% 2d", followingArgs[0]);
                        CodeUnit codeUnit = (CodeUnit)this.constants[oparg];
                        line[5] = codeUnit.qualname.toJavaStringUncached();
                        break block29;
                    }
                    case MAKE_TYPE_PARAM: {
                        line[4] = String.format("% 2d", oparg);
                        break block29;
                    }
                    case LOAD_INT: 
                    case LOAD_LONG: {
                        line[5] = Objects.toString(this.primitiveConstants[oparg]);
                        break block29;
                    }
                    case LOAD_DOUBLE: {
                        line[5] = Objects.toString(Double.longBitsToDouble(this.primitiveConstants[oparg]));
                        break block29;
                    }
                    case LOAD_COMPLEX: {
                        double[] num = (double[])this.constants[oparg];
                        if (num[0] == 0.0) {
                            line[5] = String.format("%gj", num[1]);
                            break block29;
                        }
                        line[5] = String.format("%g%+gj", num[0], num[1]);
                        break block29;
                    }
                    case LOAD_CLOSURE: 
                    case LOAD_DEREF: 
                    case STORE_DEREF: 
                    case DELETE_DEREF: 
                    case LOAD_FROM_DICT_OR_DEREF: {
                        if (oparg >= this.cellvars.length) {
                            line[5] = this.freevars[oparg - this.cellvars.length].toJavaStringUncached();
                            break block29;
                        }
                        line[5] = this.cellvars[oparg].toJavaStringUncached();
                        break block29;
                    }
                    case LOAD_FAST: 
                    case STORE_FAST: 
                    case DELETE_FAST: {
                        line[5] = this.varnames[oparg].toJavaStringUncached();
                        break block29;
                    }
                    case LOAD_NAME: 
                    case LOAD_METHOD: 
                    case STORE_NAME: 
                    case DELETE_NAME: 
                    case IMPORT_NAME: 
                    case IMPORT_FROM: 
                    case LOAD_GLOBAL: 
                    case STORE_GLOBAL: 
                    case DELETE_GLOBAL: 
                    case LOAD_ATTR: 
                    case STORE_ATTR: 
                    case DELETE_ATTR: 
                    case LOAD_FROM_DICT_OR_GLOBALS: {
                        line[5] = this.names[oparg].toJavaStringUncached();
                        break block29;
                    }
                    case FORMAT_VALUE: {
                        int type = oparg & 3;
                        switch (type) {
                            case 1: {
                                line[5] = "STR";
                                break;
                            }
                            case 2: {
                                line[5] = "REPR";
                                break;
                            }
                            case 3: {
                                line[5] = "ASCII";
                                break;
                            }
                            case 0: {
                                line[5] = "NONE";
                            }
                        }
                        if ((oparg & 4) != 4) break block29;
                        line[5] = line[5] + " + SPEC";
                        break block29;
                    }
                    case CALL_METHOD: {
                        line[4] = String.format("% 2d", oparg);
                        break block29;
                    }
                    case UNARY_OP: {
                        line[5] = UnaryOps.values()[oparg].toString();
                        break block29;
                    }
                    case BINARY_OP: {
                        line[5] = BinaryOps.values()[oparg].toString();
                        break block29;
                    }
                    case COLLECTION_FROM_STACK: 
                    case COLLECTION_ADD_STACK: 
                    case COLLECTION_FROM_COLLECTION: 
                    case COLLECTION_ADD_COLLECTION: 
                    case ADD_TO_COLLECTION: {
                        line[4] = String.format("% 2d", OpCodes.CollectionBits.elementCount(oparg));
                        line[5] = BytecodeCodeUnit.collectionKindToString(oparg);
                        break block29;
                    }
                    case UNPACK_EX: {
                        line[5] = String.format("%d, %d", oparg, Byte.toUnsignedInt(followingArgs[0]));
                        break block29;
                    }
                    case JUMP_BACKWARD: {
                        lines.computeIfAbsent(Integer.valueOf((int)(bcBCI - oparg)), (Function<Integer, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$dumpBytecode$1(java.lang.Integer ), (Ljava/lang/Integer;)[Ljava/lang/String;)())[1] = ">>";
                        line[5] = String.format("to %d", bcBCI - oparg);
                        break block29;
                    }
                    case FOR_ITER: 
                    case JUMP_FORWARD: 
                    case POP_AND_JUMP_IF_FALSE: 
                    case POP_AND_JUMP_IF_TRUE: 
                    case JUMP_IF_FALSE_OR_POP: 
                    case JUMP_IF_TRUE_OR_POP: 
                    case MATCH_EXC_OR_JUMP: 
                    case SEND: 
                    case THROW: {
                        lines.computeIfAbsent(Integer.valueOf((int)(bcBCI + oparg)), (Function<Integer, String[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$dumpBytecode$2(java.lang.Integer ), (Ljava/lang/Integer;)[Ljava/lang/String;)())[1] = ">>";
                        line[5] = String.format("to %d", bcBCI + oparg);
                        break block29;
                    }
                    default: {
                        if (opcode.quickens == null) break block29;
                        opcode = opcode.quickens;
                        continue block29;
                    }
                }
                break;
            }
            if (opcode == OpCodes.EXTENDED_ARG) {
                oparg <<= 8;
                continue;
            }
            oparg = 0;
        }
        for (int i = 0; i < this.exceptionHandlerRanges.length; i += 4) {
            int start = this.exceptionHandlerRanges[i];
            int stop = this.exceptionHandlerRanges[i + 1];
            int handler = this.exceptionHandlerRanges[i + 2];
            int stackAtHandler = this.exceptionHandlerRanges[i + 3];
            String[] line = (String[])lines.get(handler);
            assert (line != null);
            String handlerStr = String.format("exc handler %d - %d; stack: %d", start, stop, stackAtHandler);
            line[6] = line[6] == null ? handlerStr : line[6] + " | " + handlerStr;
        }
        for (bci = 0; bci < this.code.length; ++bci) {
            String[] line = (String[])lines.get(bci);
            if (line == null) continue;
            line[5] = line[5] == null ? "" : String.format("(%s)", line[5]);
            line[6] = line[6] == null ? "" : String.format("(%s)", line[6]);
            line[7] = "";
            if (this.outputCanQuicken != null && (this.outputCanQuicken[bci] != 0 || this.generalizeInputsMap[bci] != null)) {
                StringBuilder quickenSb = new StringBuilder();
                if (this.outputCanQuicken[bci] != 0) {
                    quickenSb.append("can quicken");
                }
                if (this.generalizeInputsMap[bci] != null) {
                    if (quickenSb.length() > 0) {
                        quickenSb.append(", ");
                    }
                    quickenSb.append("generalizes: ");
                    for (int i = 0; i < this.generalizeInputsMap[bci].length; ++i) {
                        if (i > 0) {
                            quickenSb.append(", ");
                        }
                        quickenSb.append(this.generalizeInputsMap[bci][i]);
                    }
                }
                line[7] = quickenSb.toString();
            }
            String formatted = String.format("%-8s %2s %4s %-32s %-3s   %-32s %s %s", line);
            sb.append(formatted.stripTrailing());
            sb.append('\n');
        }
    }

    private static String collectionKindToString(int oparg) {
        switch (OpCodes.CollectionBits.collectionKind(oparg)) {
            case 32: {
                return "list";
            }
            case 64: {
                return "tuple";
            }
            case 96: {
                return "set";
            }
            case 128: {
                return "dict";
            }
            case 160: {
                return "PKeyword[]";
            }
            case 192: {
                return "Object[]";
            }
        }
        throw new IllegalStateException("Unknown kind");
    }

    private static String collectionTypeToString(int oparg) {
        switch (OpCodes.CollectionBits.elementType(oparg)) {
            case 3: {
                return "boolean";
            }
            case 1: {
                return "int";
            }
            case 2: {
                return "long";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "Object";
            }
        }
        throw new IllegalStateException("Unknown type");
    }

    public int lineToBci(int line) {
        if (this.startLine == line) {
            return 0;
        }
        if ((this.flags & 0x1000) != 0 && line < this.startLine) {
            return 0;
        }
        int[] map = this.getSourceMap().startLineMap;
        int bestBci = -1;
        int lineDiff = Integer.MAX_VALUE;
        boolean afterFirst = false;
        for (int bci = 0; bci < map.length; ++bci) {
            int lineDiff2;
            if (map[bci] >= line && (lineDiff2 = map[bci] - line) < lineDiff) {
                bestBci = bci;
                lineDiff = lineDiff2;
            }
            if (map[bci] <= 0 || map[bci] > line) continue;
            afterFirst = true;
        }
        return afterFirst ? bestBci : -2;
    }

    private void setNextStack(ArrayDeque<Integer> todo, List<ArrayList<StackItem>> stacks, int target, ArrayList<StackItem> value) {
        ArrayList<StackItem> blocksAtTarget = stacks.get(target);
        if (blocksAtTarget == null) {
            stacks.set(target, value);
            todo.addLast(target);
        } else assert (value.equals(blocksAtTarget)) : "found conflicting stacks depending on code path: " + String.valueOf(this.name) + "\t at " + target;
    }

    private static ArrayList<StackItem> popStack(ArrayList<StackItem> blocks) {
        assert (blocks != null) : "Pop from null stack";
        assert (blocks.size() >= 1) : "Pop from empty stack";
        return new ArrayList<StackItem>(blocks.subList(0, blocks.size() - 1));
    }

    public String checkJump(Node node, List<ArrayList<StackItem>> stackElems, int from, int to) {
        ArrayList<StackItem> blkFrom = stackElems.get(from);
        if (blkFrom == null) {
            throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.ValueError, ErrorMessages.LINE_D_COMES_BEFORE_THE_CURRENT_CODE_BLOCK, this.bciToLine(from));
        }
        ArrayList<StackItem> blkTo = stackElems.get(to);
        if (blkTo == null) {
            throw PRaiseNode.raiseStatic(node, PythonBuiltinClassType.ValueError, ErrorMessages.LINE_D_COMES_AFTER_THE_CURRENT_CODE_BLOCK, this.bciToLine(from));
        }
        if (blkTo.size() > blkFrom.size()) {
            return blkTo.get((int)(blkTo.size() - 1)).error;
        }
        for (int i = blkTo.size() - 1; i >= 0; --i) {
            if (blkTo.get(i) == blkFrom.get(i)) continue;
            return blkTo.get((int)i).error;
        }
        return null;
    }

    public List<ArrayList<StackItem>> computeStackElems() {
        ArrayList<Object> blocks = new ArrayList<Object>(Collections.nCopies(this.code.length + 1, null));
        blocks.set(0, new ArrayList());
        ArrayDeque<Integer> todo = new ArrayDeque<Integer>();
        todo.addFirst(0);
        while (!todo.isEmpty()) {
            int firstBci = (Integer)todo.removeLast();
            assert (blocks.get(firstBci) != null) : "Reached block without determining its stack state";
            BytecodeCodeUnit.opCodeAt(this.code, firstBci, (bci, op, oparg, followingArgs) -> {
                ArrayList<StackItem> next = (ArrayList<StackItem>)blocks.get(firstBci);
                if (firstBci != bci) {
                    blocks.set(bci, next);
                }
                for (int j = 0; j < this.exceptionHandlerRanges.length; j += 4) {
                    int start = this.exceptionHandlerRanges[j];
                    int handler = this.exceptionHandlerRanges[j + 2];
                    int stack = this.exceptionHandlerRanges[j + 3];
                    if (start != bci) continue;
                    ArrayList<StackItem> handlerStack = StackItem.Except.push(new ArrayList<StackItem>(((ArrayList)blocks.get(bci)).subList(0, stack)));
                    this.setNextStack(todo, blocks, handler, handlerStack);
                }
                switch (op) {
                    case GET_ITER: 
                    case GET_AITER: {
                        next = StackItem.Iterable.push(BytecodeCodeUnit.popStack((ArrayList)blocks.get(bci)));
                        this.setNextStack(todo, blocks, bci + 1, next);
                        break;
                    }
                    case FOR_ITER: {
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), StackItem.Object.push(next));
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, true), BytecodeCodeUnit.popStack(next));
                        break;
                    }
                    case PUSH_EXC_INFO: {
                        next = StackItem.Except.push(StackItem.Object.push(BytecodeCodeUnit.popStack((ArrayList)blocks.get(bci))));
                        this.setNextStack(todo, blocks, bci + 1, next);
                        break;
                    }
                    case MATCH_EXC_OR_JUMP: {
                        next = BytecodeCodeUnit.popStack(next);
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), next);
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, true), next);
                        break;
                    }
                    case SETUP_WITH: 
                    case SETUP_AWITH: {
                        next = StackItem.Object.push(StackItem.With.push((ArrayList)blocks.get(bci)));
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), next);
                        break;
                    }
                    case GET_AEXIT_CORO: {
                        next = StackItem.Object.push(StackItem.Except.push(BytecodeCodeUnit.popStack(BytecodeCodeUnit.popStack(BytecodeCodeUnit.popStack((ArrayList)blocks.get(bci))))));
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), next);
                        break;
                    }
                    case DUP_TOP: {
                        next = next.get(next.size() - 1).push(next);
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), next);
                        break;
                    }
                    case ROT_TWO: {
                        StackItem top = next.get(next.size() - 1);
                        StackItem belowTop = next.get(next.size() - 2);
                        next = belowTop.push(top.push(BytecodeCodeUnit.popStack(BytecodeCodeUnit.popStack(next))));
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), next);
                        break;
                    }
                    case ROT_THREE: {
                        StackItem top = next.get(next.size() - 1);
                        StackItem second = next.get(next.size() - 2);
                        StackItem third = next.get(next.size() - 3);
                        next = second.push(third.push(top.push(top.push(BytecodeCodeUnit.popStack(BytecodeCodeUnit.popStack(BytecodeCodeUnit.popStack(next)))))));
                        this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), next);
                        break;
                    }
                    case LOAD_NONE: {
                        BytecodeCodeUnit.opCodeAt(this.code, op.getNextBci(bci, oparg, false), (ignored, nextOp, ignored2, ignored3) -> {
                            if (nextOp != OpCodes.GET_AEXIT_CORO && nextOp != OpCodes.EXIT_WITH) {
                                this.setNextStack(todo, blocks, op.getNextBci(bci, oparg, false), StackItem.Object.push((ArrayList)blocks.get(bci)));
                            }
                        });
                        break;
                    }
                    default: {
                        int nextWJump = op.getNextBci(bci, oparg, true);
                        int nextWOJump = op.getNextBci(bci, oparg, false);
                        int stackLostWJump = op.getNumberOfConsumedStackItems(oparg, followingArgs, true);
                        int stackLostWOJump = op.getNumberOfConsumedStackItems(oparg, followingArgs, false);
                        int stackGainWJump = op.getNumberOfProducedStackItems(oparg, followingArgs, true);
                        int stackGainWOJump = op.getNumberOfProducedStackItems(oparg, followingArgs, false);
                        this.handleGeneralOp(blocks, todo, bci, nextWJump, stackLostWJump, stackGainWJump);
                        if (nextWJump == nextWOJump) break;
                        this.handleGeneralOp(blocks, todo, bci, nextWOJump, stackLostWOJump, stackGainWOJump);
                        break;
                    }
                }
            });
        }
        return blocks;
    }

    private void handleGeneralOp(List<ArrayList<StackItem>> blocks, ArrayDeque<Integer> todo, int bci, int next, int stackLost, int stackGain) {
        if (next >= 0) {
            int k;
            ArrayList<StackItem> blocksHere = new ArrayList<StackItem>((Collection)blocks.get(bci));
            for (k = 0; k < stackLost; ++k) {
                blocksHere.remove(blocksHere.size() - 1);
            }
            for (k = 0; k < stackGain; ++k) {
                blocksHere.add(StackItem.Object);
            }
            this.setNextStack(todo, blocks, next, blocksHere);
        }
    }

    private static int opCodeAt(byte[] bytecode, int bci, BytecodeAction action) {
        int oparg = 0;
        OpCodes op = OpCodes.fromOpCode(bytecode[bci]);
        while (op == OpCodes.EXTENDED_ARG) {
            oparg |= Byte.toUnsignedInt(bytecode[bci + 1]);
            oparg <<= 8;
            op = OpCodes.fromOpCode(bytecode[bci += 2]);
        }
        op = BytecodeCodeUnit.unquicken(op);
        byte[] followingArgs = null;
        if (op.argLength > 0) {
            oparg |= Byte.toUnsignedInt(bytecode[bci + 1]);
            if (op.argLength > 1) {
                followingArgs = new byte[op.argLength - 1];
                System.arraycopy(bytecode, bci + 2, followingArgs, 0, followingArgs.length);
            }
        }
        action.run(bci, op, oparg, followingArgs);
        return bci + op.length();
    }

    public static void iterateBytecode(byte[] bytecode, BytecodeAction action) {
        int bci = 0;
        while (bci < bytecode.length) {
            bci = BytecodeCodeUnit.opCodeAt(bytecode, bci, action);
        }
    }

    public void iterateBytecode(BytecodeAction action) {
        BytecodeCodeUnit.iterateBytecode(this.code, action);
    }

    public byte[] getBytecodeForSerialization() {
        OpCodes op;
        byte[] bytecode = Arrays.copyOf(this.code, this.code.length);
        for (int bci = 0; bci < bytecode.length; bci += op.length()) {
            op = OpCodes.fromOpCode(bytecode[bci]);
            bytecode[bci] = (byte)BytecodeCodeUnit.unquicken(op).ordinal();
        }
        return bytecode;
    }

    private static OpCodes unquicken(OpCodes op) {
        if (op.quickens == null) {
            return op;
        }
        return switch (op.quickens) {
            case OpCodes.LOAD_BYTE, OpCodes.LOAD_INT, OpCodes.LOAD_LONG, OpCodes.LOAD_DOUBLE, OpCodes.LOAD_TRUE, OpCodes.LOAD_FALSE -> op;
            default -> op.quickens;
        };
    }

    private static /* synthetic */ String[] lambda$dumpBytecode$2(Integer k) {
        return new String[8];
    }

    private static /* synthetic */ String[] lambda$dumpBytecode$1(Integer k) {
        return new String[8];
    }

    public static enum StackItem {
        With("the body of a with statement"),
        Iterable("the body of a for loop"),
        Except("an 'except' block as there's no exception"),
        Object("Incompatible stack");

        public final String error;

        private StackItem(String error) {
            this.error = error;
        }

        ArrayList<StackItem> push(ArrayList<StackItem> v) {
            ArrayList<StackItem> ret = v == null ? new ArrayList<StackItem>() : new ArrayList<StackItem>(v);
            ret.add(this);
            return ret;
        }
    }

    @FunctionalInterface
    public static interface BytecodeAction {
        public void run(int var1, OpCodes var2, int var3, byte[] var4);
    }
}

