/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItemFactory;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import java.util.Objects;

public final class TpSlotSqAssItem {
    private TpSlotSqAssItem() {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class CallManagedSlotSqAssItemNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, TpSlot.TpSlotManaged var3, Object var4, int var5, Object var6);

        @Specialization(guards={"slot == cachedSlot"}, limit="3")
        static void callCachedBuiltin(VirtualFrame frame, TpSlotSqAssItemBuiltin slot, Object self, int key, Object value, @Cached(value="slot") TpSlotSqAssItemBuiltin cachedSlot, @Cached(value="cachedSlot.createSlotNode()") SqAssItemBuiltinNode slotNode) {
            slotNode.executeIntKey(frame, self, key, value);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void callPythonSimpleSet(VirtualFrame frame, Node inliningTarget, TpSlotSqAssItemPython slot, Object self, int key, Object value, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached PythonDispatchers.TernaryPythonSlotDispatcherNode callPythonFun) {
            Object callable = slot.getSetitem();
            if (callable == null) {
                throw CallManagedSlotSqAssItemNode.raiseAttributeError(inliningTarget, raiseNode, SpecialMethodNames.T___SETITEM__);
            }
            callPythonFun.execute(frame, inliningTarget, callable, slot.getType(), self, key, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        @HostCompilerDirectives.InliningCutoff
        static void callPythonSimpleDel(VirtualFrame frame, Node inliningTarget, TpSlotSqAssItemPython slot, Object self, int key, Object value, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode callPythonFun) {
            Object callable = slot.getDelitem();
            if (callable == null) {
                throw CallManagedSlotSqAssItemNode.raiseAttributeError(inliningTarget, raiseNode, SpecialMethodNames.T___DELITEM__);
            }
            callPythonFun.execute(frame, inliningTarget, callable, slot.getType(), self, key);
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseAttributeError(Node inliningTarget, PRaiseNode raiseNode, TruffleString attrName) {
            return raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, attrName);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static void callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotSqAssItemBuiltin slot, Object self, int key, Object value, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, key);
            PArguments.setArgument(arguments, 2, value);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class CallNativeSlotSqAssItemNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "sq_ass_item");

        CallNativeSlotSqAssItemNode() {
        }

        abstract void execute(VirtualFrame var1, TpSlot.TpSlotNative var2, Object var3, long var4, Object var6);

        @Specialization
        static void callNative(VirtualFrame frame, TpSlot.TpSlotNative slot, Object self, long key, Object value, @Bind Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached CApiTransitions.PythonToNativeNode valueToNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached ExternalFunctionNodes.CheckInquiryResultNode checkResultNode) {
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___SETITEM__, slot.callable, selfToNativeNode.execute(self), key, valueToNativeNode.execute(value));
            checkResultNode.execute(threadState, SpecialMethodNames.T___SETITEM__, result);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotSqAssItemNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, int var5, Object var6);

        @Specialization
        static void callManagedSlot(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotManaged slot, Object self, int key, Object value, @Cached CallManagedSlotSqAssItemNode slotNode) {
            slotNode.execute(frame, inliningTarget, slot, self, key, value);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void callNative(VirtualFrame frame, TpSlot.TpSlotNative slot, Object self, int key, Object value, @Cached(inline=false) CallNativeSlotSqAssItemNode callNativeSlot) {
            callNativeSlot.execute(frame, slot, self, key, value);
        }
    }

    public static final class TpSlotSqAssItemPython
    extends TpSlot.TpSlotPython {
        private final TruffleWeakReference<Object> setitem;
        private final TruffleWeakReference<Object> delitem;
        private final TruffleWeakReference<Object> type;

        public TpSlotSqAssItemPython(Object setitem, Object delitem, Object type) {
            this.setitem = TpSlotSqAssItemPython.asWeakRef(setitem);
            this.delitem = TpSlotSqAssItemPython.asWeakRef(delitem);
            this.type = new TruffleWeakReference(type);
        }

        public static TpSlotSqAssItemPython create(Object[] callables, TruffleString[] callableNames, Object type) {
            assert (callables.length == 2);
            assert (callableNames == null || callableNames[0].equals((Object)SpecialMethodNames.T___SETITEM__) && callableNames[1].equals((Object)SpecialMethodNames.T___DELITEM__));
            return new TpSlotSqAssItemPython(callables[0], callables[1], type);
        }

        @Override
        public TpSlot.TpSlotPython forNewType(Object klass) {
            Object newSet = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___SETITEM__);
            Object newDel = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___DELITEM__);
            if (newSet != this.getSetitem() || newDel != this.getDelitem()) {
                return new TpSlotSqAssItemPython(newSet, newDel, this.getType());
            }
            return this;
        }

        public Object getSetitem() {
            return this.safeGet(this.setitem);
        }

        public Object getDelitem() {
            return this.safeGet(this.delitem);
        }

        public Object getType() {
            return this.safeGet(this.type);
        }
    }

    public static abstract class WrapSqDelItemBuiltinNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private SqAssItemBuiltinNode slotNode;
        @Node.Child
        private TpSlotSizeArgFun.FixNegativeIndex fixNegativeIndex;

        protected WrapSqDelItemBuiltinNode(SqAssItemBuiltinNode slotNode) {
            this.slotNode = slotNode;
        }

        @Specialization(guards={"index >= 0"})
        Object doIntIndex(VirtualFrame frame, Object self, int index) {
            this.slotNode.executeIntKey(frame, self, index, PNone.NO_VALUE);
            return PNone.NONE;
        }

        @Specialization(replaces={"doIntIndex"})
        Object doGeneric(VirtualFrame frame, Object self, Object index, @Bind Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            int size = asSizeNode.executeExact((Frame)frame, inliningTarget, index, PythonBuiltinClassType.OverflowError);
            if (size < 0) {
                if (this.fixNegativeIndex == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.fixNegativeIndex = (TpSlotSizeArgFun.FixNegativeIndex)this.insert(TpSlotSizeArgFun.FixNegativeIndex.create());
                }
                size = this.fixNegativeIndex.execute(frame, size, index);
            }
            this.slotNode.executeIntKey(frame, self, size, PNone.NO_VALUE);
            return PNone.NONE;
        }
    }

    public static abstract class WrapSqSetItemBuiltinNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private SqAssItemBuiltinNode slotNode;
        @Node.Child
        private TpSlotSizeArgFun.FixNegativeIndex fixNegativeIndex;

        protected WrapSqSetItemBuiltinNode(SqAssItemBuiltinNode slotNode) {
            this.slotNode = slotNode;
        }

        @Specialization(guards={"index >= 0"})
        Object doIntIndex(VirtualFrame frame, Object self, int index, Object value) {
            this.slotNode.executeIntKey(frame, self, index, value);
            return PNone.NONE;
        }

        @Specialization(replaces={"doIntIndex"})
        Object doGeneric(VirtualFrame frame, Object self, Object index, Object value, @Bind Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            int size = asSizeNode.executeExact((Frame)frame, inliningTarget, index, PythonBuiltinClassType.OverflowError);
            if (size < 0) {
                if (this.fixNegativeIndex == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.fixNegativeIndex = (TpSlotSizeArgFun.FixNegativeIndex)this.insert(TpSlotSizeArgFun.FixNegativeIndex.create());
                }
                size = this.fixNegativeIndex.execute(frame, size, index);
            }
            this.slotNode.executeIntKey(frame, self, size, value);
            return PNone.NONE;
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class SqAssItemBuiltinNode
    extends PythonTernaryBuiltinNode {
        public abstract void executeIntKey(VirtualFrame var1, Object var2, int var3, Object var4);

        @Override
        public final Object execute(VirtualFrame frame, Object obj, Object key, Object value) {
            this.executeIntKey(frame, obj, (Integer)key, value);
            return PNone.NONE;
        }
    }

    public static abstract class TpSlotSqAssItemBuiltin<T extends SqAssItemBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        public static final BuiltinSlotWrapperSignature SET_SIGNATURE = BuiltinSlotWrapperSignature.of(BuiltinSlotWrapperSignature.J_DOLLAR_SELF, "key", "value");
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotSqAssItemBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, BuiltinSlotWrapperSignature.BINARY, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC);
        }

        final SqAssItemBuiltinNode createSlotNode() {
            return (SqAssItemBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget target = TpSlotSqAssItemBuiltin.createSlotCallTarget(language, SET_SIGNATURE, this.getNodeFactory(), "__setitem__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, target);
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return switch (wrapper) {
                case ExternalFunctionNodes.PExternalFunctionWrapper.SETITEM -> this.createBuiltin(core, type, SpecialMethodNames.T___SETITEM__, SET_SIGNATURE, wrapper, NodeFactoryUtils.WrapperNodeFactory.wrap(this.getNodeFactory(), WrapSqSetItemBuiltinNode.class, TpSlotSqAssItemFactory.WrapSqSetItemBuiltinNodeGen::create));
                case ExternalFunctionNodes.PExternalFunctionWrapper.DELITEM -> this.createBuiltin(core, type, SpecialMethodNames.T___DELITEM__, BuiltinSlotWrapperSignature.BINARY, wrapper, NodeFactoryUtils.WrapperNodeFactory.wrap(this.getNodeFactory(), WrapSqDelItemBuiltinNode.class, TpSlotSqAssItemFactory.WrapSqDelItemBuiltinNodeGen::create));
                default -> throw new IllegalStateException(Objects.toString(wrapper));
            };
        }
    }
}

