/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.slice;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.ints.IntNodes;
import com.oracle.graal.python.builtins.objects.slice.PIntSlice;
import com.oracle.graal.python.builtins.objects.slice.PObjectSlice;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodesFactory;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.math.BigInteger;

public abstract class SliceNodes {

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class, PGuards.class})
    public static abstract class SliceLossyCastToLong
    extends Node {
        public abstract long execute(Node var1, Object var2);

        @Specialization(guards={"!isPNone(i)"})
        static long doGeneric(Node inliningTarget, Object i, @Cached PRaiseNode raise, @Cached PyIndexCheckNode indexCheckNode, @Cached(inline=false) IntNodes.PyLongSign signNode, @Cached PyLongAsLongAndOverflowNode asSizeNode) {
            if (indexCheckNode.execute(inliningTarget, i)) {
                try {
                    return asSizeNode.execute(null, inliningTarget, i);
                }
                catch (OverflowException e) {
                    if (signNode.execute(i) < 0) {
                        return Long.MIN_VALUE;
                    }
                    return Long.MAX_VALUE;
                }
            }
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SLICE_INDICES_MUST_BE_INT_NONE_HAVE_INDEX);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class, PGuards.class})
    public static abstract class SliceLossyCastToInt
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        @Specialization
        protected static Object doNone(PNone i) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(i)"})
        protected static Object doGeneric(Node inliningTarget, Object i, @Cached InlinedBranchProfile exceptionProfile, @Cached PRaiseNode raise, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode) {
            if (indexCheckNode.execute(inliningTarget, i)) {
                return asSizeNode.executeLossy(null, inliningTarget, i);
            }
            exceptionProfile.enter(inliningTarget);
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SLICE_INDICES_MUST_BE_INT_NONE_HAVE_INDEX);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class, PGuards.class})
    public static abstract class SliceExactCastToInt
    extends Node {
        public abstract Object execute(Frame var1, Node var2, Object var3);

        @Specialization
        protected static Object doNone(PNone i) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(i)"})
        protected static Object doGeneric(Node inliningTarget, Object i, @Cached PRaiseNode raise, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode) {
            if (indexCheckNode.execute(inliningTarget, i)) {
                return asSizeNode.executeExact(null, inliningTarget, i);
            }
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SLICE_INDICES_MUST_BE_INT_NONE_HAVE_INDEX);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class, PGuards.class})
    public static abstract class SliceCastToToBigInt
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        @Specialization
        protected static Object doNone(PNone i) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(i)"})
        protected static Object doGeneric(Node inliningTarget, Object i, @Cached InlinedBranchProfile exceptionProfile, @Cached PRaiseNode raise, @Cached CastToJavaBigIntegerNode cast) {
            try {
                return cast.execute(inliningTarget, i);
            }
            catch (PException e) {
                exceptionProfile.enter(inliningTarget);
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SLICE_INDICES_MUST_BE_INT_NONE_HAVE_INDEX);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SliceUnpackLong
    extends PNodeWithContext {
        public abstract PSlice.SliceInfoLong execute(Node var1, PSlice var2);

        @Specialization
        static PSlice.SliceInfoLong doSliceInt(Node inliningTarget, PIntSlice slice, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            long step = slice.getIntStep();
            if (step == 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
            }
            long start = slice.isStartNone() ? (slice.getIntStep() >= 0 ? 0L : Long.MAX_VALUE) : (long)slice.getIntStart();
            return new PSlice.SliceInfoLong(start, slice.getIntStop(), slice.getIntStep());
        }

        @Specialization
        static PSlice.SliceInfoLong doSliceObject(Node inliningTarget, PObjectSlice slice, @Cached SliceLossyCastToLong toInt, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            long step;
            if (slice.getStep() == PNone.NONE) {
                step = 1L;
            } else {
                step = toInt.execute(inliningTarget, slice.getStep());
                if (step == 0L) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
                }
                if (step < -9223372036854775807L) {
                    step = -9223372036854775807L;
                }
            }
            long start = slice.getStart() == PNone.NONE ? (step < 0L ? Long.MAX_VALUE : 0L) : toInt.execute(inliningTarget, slice.getStart());
            long stop = slice.getStop() == PNone.NONE ? (step < 0L ? Long.MIN_VALUE : Long.MAX_VALUE) : toInt.execute(inliningTarget, slice.getStop());
            return new PSlice.SliceInfoLong(start, stop, step);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SliceUnpack
    extends PNodeWithContext {
        public abstract PSlice.SliceInfo execute(Node var1, PSlice var2);

        @Specialization
        static PSlice.SliceInfo doSliceInt(PIntSlice slice) {
            int start = slice.getIntStart();
            if (slice.isStartNone()) {
                start = slice.getIntStep() >= 0 ? 0 : Integer.MAX_VALUE;
            }
            return new PSlice.SliceInfo(start, slice.getIntStop(), slice.getIntStep());
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static PSlice.SliceInfo doSliceObject(Node inliningTarget, PObjectSlice slice, @Cached SliceLossyCastToInt toInt, @Cached PRaiseNode raiseNode) {
            int step;
            if (slice.getStep() == PNone.NONE) {
                step = 1;
            } else {
                step = (Integer)toInt.execute(inliningTarget, slice.getStep());
                if (step == 0) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
                }
            }
            int start = slice.getStart() == PNone.NONE ? (step < 0 ? Integer.MAX_VALUE : 0) : (Integer)toInt.execute(inliningTarget, slice.getStart());
            int stop = slice.getStop() == PNone.NONE ? (step < 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE) : (Integer)toInt.execute(inliningTarget, slice.getStop());
            return new PSlice.SliceInfo(start, stop, step);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CoerceToIntSlice
    extends PNodeWithContext {
        public abstract PSlice execute(Node var1, PSlice var2);

        @Specialization
        static PSlice doSliceInt(PIntSlice slice) {
            return slice;
        }

        @Specialization
        static PSlice doSliceObject(Node inliningTarget, PObjectSlice slice, @Cached SliceLossyCastToInt start, @Cached SliceLossyCastToInt stop, @Cached SliceLossyCastToInt step, @Bind PythonLanguage language) {
            return PFactory.createObjectSlice(language, start.execute(inliningTarget, slice.getStart()), stop.execute(inliningTarget, slice.getStop()), step.execute(inliningTarget, slice.getStep()));
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CoerceToObjectSlice
    extends PNodeWithContext {
        public abstract PObjectSlice execute(PSlice var1);

        @Specialization
        PObjectSlice doSliceInt(PIntSlice slice, @Bind Node inliningTarget, @Cached.Shared @Cached SliceCastToToBigInt start, @Cached.Shared @Cached SliceCastToToBigInt stop, @Cached.Shared @Cached SliceCastToToBigInt step, @Bind PythonLanguage language) {
            return PFactory.createObjectSlice(language, start.execute(inliningTarget, slice.getStart()), stop.execute(inliningTarget, slice.getStop()), step.execute(inliningTarget, slice.getStep()));
        }

        protected static boolean isBigInt(PObjectSlice slice) {
            return slice.getStart() instanceof BigInteger && slice.getStop() instanceof BigInteger && slice.getStep() instanceof BigInteger;
        }

        @Specialization(guards={"isBigInt(slice)"})
        PObjectSlice doSliceObject(PObjectSlice slice) {
            return slice;
        }

        @Specialization
        PObjectSlice doSliceObject(PObjectSlice slice, @Bind Node inliningTarget, @Cached.Shared @Cached SliceCastToToBigInt start, @Cached.Shared @Cached SliceCastToToBigInt stop, @Cached.Shared @Cached SliceCastToToBigInt step, @Bind PythonLanguage language) {
            return PFactory.createObjectSlice(language, start.execute(inliningTarget, slice.getStart()), stop.execute(inliningTarget, slice.getStop()), step.execute(inliningTarget, slice.getStep()));
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ComputeIndices
    extends PNodeWithContext {
        public abstract PSlice.SliceInfo execute(Frame var1, PSlice var2, int var3);

        @Specialization(guards={"length >= 0"})
        PSlice.SliceInfo doSliceInt(PIntSlice slice, int length) {
            return slice.computeIndices(length);
        }

        @Specialization(guards={"length >= 0"})
        static PSlice.SliceInfo doSliceObject(VirtualFrame frame, PObjectSlice slice, int length, @Bind Node inliningTarget, @Cached SliceExactCastToInt castStartNode, @Cached SliceExactCastToInt castStopNode, @Cached SliceExactCastToInt castStepNode) {
            Object startIn = castStartNode.execute((Frame)frame, inliningTarget, slice.getStart());
            Object stopIn = castStopNode.execute((Frame)frame, inliningTarget, slice.getStop());
            Object stepIn = castStepNode.execute((Frame)frame, inliningTarget, slice.getStep());
            return PObjectSlice.computeIndices(startIn, stopIn, stepIn, length);
        }

        @Specialization(guards={"length < 0"})
        PSlice.SliceInfo doSliceInt(PSlice slice, int length, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.LENGTH_SHOULD_NOT_BE_NEG);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class AdjustIndices
    extends PNodeWithContext {
        public abstract PSlice.SliceInfo execute(Node var1, int var2, PSlice.SliceInfo var3);

        @Specialization
        static PSlice.SliceInfo calc(Node inliningTarget, int length, PSlice.SliceInfo slice, @Cached PRaiseNode raiseNode) {
            int start = slice.start;
            int stop = slice.stop;
            int step = slice.step;
            if (step == 0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
            }
            assert (step > Integer.MIN_VALUE) : "step must not be minimum integer value";
            int len = 0;
            if (start < 0) {
                if ((start += length) < 0) {
                    start = step < 0 ? -1 : 0;
                }
            } else if (start >= length) {
                int n = start = step < 0 ? length - 1 : length;
            }
            if (stop < 0) {
                if ((stop += length) < 0) {
                    stop = step < 0 ? -1 : 0;
                }
            } else if (stop >= length) {
                int n = stop = step < 0 ? length - 1 : length;
            }
            if (step < 0) {
                if (stop < start) {
                    len = (start - stop - 1) / -step + 1;
                }
            } else if (start < stop) {
                len = (stop - start - 1) / step + 1;
            }
            return new PSlice.SliceInfo(start, stop, step, len);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CreateSliceNode
    extends PNodeWithContext {
        public abstract PSlice execute(Object var1, Object var2, Object var3);

        static PSlice doInt(int start, int stop, PNone step, @Bind PythonLanguage language) {
            return PFactory.createIntSlice(language, start, stop, 1, false, true);
        }

        @Specialization
        static PSlice doInt(int start, int stop, int step, @Bind PythonLanguage language) {
            return PFactory.createIntSlice(language, start, stop, step);
        }

        @Specialization
        static PSlice doInt(PNone start, int stop, PNone step, @Bind PythonLanguage language) {
            return PFactory.createIntSlice(language, 0, stop, 1, true, true);
        }

        @Specialization
        static PSlice doInt(PNone start, int stop, int step, @Bind PythonLanguage language) {
            return PFactory.createIntSlice(language, 0, stop, step, true, false);
        }

        @Fallback
        static PSlice doGeneric(Object start, Object stop, Object step, @Bind PythonLanguage language) {
            return PFactory.createObjectSlice(language, start, stop, step);
        }

        @NeverDefault
        public static CreateSliceNode create() {
            return SliceNodesFactory.CreateSliceNodeGen.create();
        }

        public static CreateSliceNode getUncached() {
            return SliceNodesFactory.CreateSliceNodeGen.getUncached();
        }
    }
}

