/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.ArrayNodes;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.dict.PHashingStorageIterator;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.IteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.iterator.IteratorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.iterator.PArrayIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBaseSetIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBigRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PPrimitiveIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PStringIterator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PArrayIterator, PythonBuiltinClassType.PDictItemIterator, PythonBuiltinClassType.PDictReverseItemIterator, PythonBuiltinClassType.PDictKeyIterator, PythonBuiltinClassType.PDictReverseKeyIterator, PythonBuiltinClassType.PDictValueIterator, PythonBuiltinClassType.PDictReverseValueIterator})
public final class IteratorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = IteratorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object setstate(PBigRangeIterator self, Object index, @Bind Node inliningTarget, @Cached CastToJavaBigIntegerNode castToJavaBigIntegerNode) {
            BigInteger idx = castToJavaBigIntegerNode.execute(inliningTarget, index);
            if (idx.compareTo(BigInteger.ZERO) < 0) {
                idx = BigInteger.ZERO;
            }
            self.setLongIndex(idx);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPBigRangeIterator(self)"})
        static Object setstate(VirtualFrame frame, PBuiltinIterator self, Object index, @Bind Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            int idx = asSizeNode.executeExact((Frame)frame, inliningTarget, index);
            if (idx < 0) {
                idx = 0;
            }
            self.index = idx;
            return PNone.NONE;
        }

        @Fallback
        static Object other(Object self, Object index, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_REQUIRES_S_OBJ_RECEIVED_P, "iterator", self);
        }

        protected static boolean isPBigRangeIterator(Object obj) {
            return obj instanceof PBigRangeIterator;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(VirtualFrame frame, PArrayIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached InlinedConditionProfile exhaustedProfile, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            if (!exhaustedProfile.profile(inliningTarget, self.isExhausted())) {
                return ReduceNode.reduceInternal(frame, inliningTarget, self.array, self.getIndex(), context, getAttrNode);
            }
            return ReduceNode.reduceInternal(frame, inliningTarget, PFactory.createEmptyTuple(context.getLanguage(inliningTarget)), context, getAttrNode);
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PHashingStorageIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached SequenceStorageNodes.CreateStorageFromIteratorNode storageNode, @Cached.Shared @Cached InlinedConditionProfile exhaustedProfile, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            int index = self.index;
            boolean isExhausted = self.isExhausted();
            int state = self.getIterator().getState();
            PList list = PFactory.createList(context.getLanguage(inliningTarget), storageNode.execute(frame, self));
            self.getIterator().setState(state);
            self.setExhausted(isExhausted);
            self.index = index;
            return ReduceNode.reduceInternal(frame, inliningTarget, list, context, getAttrNode);
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PIntegerSequenceIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            if (self.isExhausted()) {
                return ReduceNode.reduceInternal(frame, inliningTarget, PFactory.createList(context.getLanguage(inliningTarget)), null, context, getAttrNode);
            }
            return ReduceNode.reduceInternal(frame, inliningTarget, self.getObject(), self.getIndex(), context, getAttrNode);
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PPrimitiveIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            if (self.isExhausted()) {
                return ReduceNode.reduceInternal(frame, inliningTarget, PFactory.createList(context.getLanguage(inliningTarget)), null, context, getAttrNode);
            }
            return ReduceNode.reduceInternal(frame, inliningTarget, self.getObject(), self.getIndex(), context, getAttrNode);
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PStringIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            if (self.isExhausted()) {
                return ReduceNode.reduceInternal(frame, inliningTarget, StringLiterals.T_EMPTY_STRING, null, context, getAttrNode);
            }
            return ReduceNode.reduceInternal(frame, inliningTarget, self.value, self.getIndex(), context, getAttrNode);
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PIntRangeIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            int start = self.getStart();
            int stop = self.getStop();
            int step = self.getStep();
            int len = self.getLen();
            PythonLanguage language = context.getLanguage(inliningTarget);
            return ReduceNode.reduceInternal(frame, inliningTarget, PFactory.createIntRange(language, start, stop, step, len), self.getIndex(), context, getAttrNode);
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PBigRangeIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            PInt start = self.getStart();
            PInt stop = self.getStop();
            PInt step = self.getStep();
            PInt len = self.getLen();
            PythonLanguage language = context.getLanguage(inliningTarget);
            return ReduceNode.reduceInternal(frame, inliningTarget, PFactory.createBigRange(language, start, stop, step, len), self.getLongIndex(language), context, getAttrNode);
        }

        @Specialization(guards={"self.isPSequence()"})
        static Object reduce(VirtualFrame frame, PSequenceIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            if (self.isExhausted()) {
                return ReduceNode.reduceInternal(frame, inliningTarget, PFactory.createTuple(context.getLanguage(inliningTarget), new Object[0]), null, context, getAttrNode);
            }
            return ReduceNode.reduceInternal(frame, inliningTarget, self.getPSequence(), self.getIndex(), context, getAttrNode);
        }

        @Specialization(guards={"!self.isPSequence()"})
        static Object reduceNonSeq(VirtualFrame frame, PSequenceIterator self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached.Shared @Cached PyObjectGetAttr getAttrNode) {
            if (!self.isExhausted()) {
                return ReduceNode.reduceInternal(frame, inliningTarget, self.getObject(), self.getIndex(), context, getAttrNode);
            }
            return ReduceNode.reduceInternal(frame, inliningTarget, PFactory.createTuple(context.getLanguage(inliningTarget), new Object[0]), null, context, getAttrNode);
        }

        @Fallback
        static int other(Object self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_REQUIRES_S_OBJ_RECEIVED_P, "iterator", self);
        }

        private static PTuple reduceInternal(VirtualFrame frame, Node inliningTarget, Object arg, PythonContext context, PyObjectGetAttr getAttrNode) {
            return ReduceNode.reduceInternal(frame, inliningTarget, arg, null, context, getAttrNode);
        }

        private static PTuple reduceInternal(VirtualFrame frame, Node inliningTarget, Object arg, Object state, PythonContext context, PyObjectGetAttr getAttrNode) {
            PythonModule builtins = context.getBuiltins();
            PythonLanguage language = context.getLanguage(inliningTarget);
            Object iter = getAttrNode.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_ITER);
            PTuple args = PFactory.createTuple(language, new Object[]{arg});
            if (state != null) {
                return PFactory.createTuple(language, new Object[]{iter, args, state});
            }
            return PFactory.createTuple(language, new Object[]{iter, args});
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isExhausted()"})
        static int exhausted(PBuiltinIterator self) {
            return 0;
        }

        @Specialization
        static int lengthHint(PArrayIterator self) {
            return self.array.getLength() - self.getIndex();
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(VirtualFrame frame, PDictView.PBaseDictIterator self, @Bind Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, self.checkSizeChanged(inliningTarget, lenNode))) {
                return 0;
            }
            return self.getSize() - self.getIndex();
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PIntegerSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PObjectSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PIntRangeIterator self) {
            return self.getRemainingLength();
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object lengthHint(PBigRangeIterator self, @Bind PythonLanguage language) {
            return PFactory.createInt(language, self.getRemainingLength());
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PDoubleSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PLongSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PBaseSetIterator self, @Bind Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached InlinedConditionProfile profile) {
            int size = self.getSize();
            int lenSet = lenNode.execute(inliningTarget, self.getHashingStorage());
            if (profile.profile(inliningTarget, lenSet != size)) {
                return 0;
            }
            int len = size - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        static int lengthHint(PStringIterator self, @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)self.value, PythonUtils.TS_ENCODING) - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()", "self.isPSequence()"})
        static int lengthHint(PSequenceIterator self, @Bind Node inliningTarget, @Cached SequenceNodes.LenNode lenNode) {
            int len = lenNode.execute(inliningTarget, self.getPSequence()) - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()", "!self.isPSequence()"})
        static int lengthHint(VirtualFrame frame, PSequenceIterator self, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            int len = sizeNode.execute((Frame)frame, inliningTarget, self.getObject()) - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, self)", "interop.isIterator(self)"}, limit="1")
        static int foreign(Object self, @Bind Node inliningTarget, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached GilNode gil) {
            gil.release(true);
            try {
                int n = interop.hasIteratorNextElement(self) ? 1 : 0;
                return n;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"iterator claimed to be iterator but wasn't");
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(Object self) {
            return self;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class NextHelperNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Node var2, Object var3);

        private static Object stopIteration(PBuiltinIterator self) {
            self.setExhausted();
            throw TpSlotIterNext.TpIterNextBuiltin.iteratorExhausted();
        }

        @Specialization(guards={"self.isExhausted()"})
        static Object exhausted(PBuiltinIterator self) {
            throw TpSlotIterNext.TpIterNextBuiltin.iteratorExhausted();
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(Node inliningTarget, PArrayIterator self, @Cached InlinedExactClassProfile itemTypeProfile, @Cached ArrayNodes.GetValueNode getValueNode) {
            PArray array = self.array;
            if (self.getIndex() < array.getLength()) {
                return itemTypeProfile.profile(inliningTarget, getValueNode.execute(inliningTarget, array, self.index++));
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(PIntegerSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getIntItemNormalized(self.index++);
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(PObjectSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getObjectItemNormalized(self.index++);
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(Node inliningTarget, PIntRangeIterator self, @Cached.Exclusive @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, self.hasNextInt())) {
                return self.nextInt();
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(PBigRangeIterator self, @Bind PythonLanguage language) {
            if (self.hasNextBigInt()) {
                return PFactory.createInt(language, self.nextBigInt());
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(PDoubleSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getDoubleItemNormalized(self.index++);
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(PLongSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getLongItemNormalized(self.index++);
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object next(PStringIterator self, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.SubstringNode substringNode) {
            if (self.getIndex() < codePointLengthNode.execute((AbstractTruffleString)self.value, PythonUtils.TS_ENCODING)) {
                return substringNode.execute((AbstractTruffleString)self.value, self.index++, 1, PythonUtils.TS_ENCODING, false);
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object nextHashingStorageIter(Node inliningTarget, PHashingStorageIterator self, @Cached.Exclusive @Cached InlinedConditionProfile sizeChanged, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageIteratorNext nextNode, @Cached PHashingStorageIteratorNextValue itValueNode, @Cached.Exclusive @Cached InlinedConditionProfile profile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            HashingStorageNodes.HashingStorageIterator it;
            HashingStorage storage = self.getHashingStorage();
            if (profile.profile(inliningTarget, nextNode.execute(inliningTarget, storage, it = self.getIterator()))) {
                if (sizeChanged.profile(inliningTarget, self.checkSizeChanged(inliningTarget, lenNode))) {
                    String name = PBaseSetIterator.isInstance(self) ? "Set" : "dictionary";
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CHANGED_SIZE_DURING_ITERATION, name);
                }
                ++self.index;
                return itValueNode.execute(inliningTarget, self, storage, it);
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()", "self.isPSequence()"})
        static Object next(Node inliningTarget, PSequenceIterator self, @Cached SequenceNodes.GetSequenceStorageNode getStorage, @Cached(value="createNotNormalized()", inline=false) SequenceStorageNodes.GetItemNode getItemNode) {
            SequenceStorage s = getStorage.execute(inliningTarget, self.getPSequence());
            if (self.getIndex() < s.length()) {
                return getItemNode.execute(s, self.index++);
            }
            return NextHelperNode.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()", "!self.isPSequence()"})
        static Object next(VirtualFrame frame, Node inliningTarget, PSequenceIterator self, @Cached(inline=false) PySequenceGetItemNode getItem, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
            try {
                return getItem.execute((Frame)frame, self.getObject(), self.index++);
            }
            catch (PException e) {
                e.expectIndexError(inliningTarget, profile);
                return NextHelperNode.stopIteration(self);
            }
        }

        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, self)", "interop.isIterator(self)"}, limit="1")
        static Object foreign(Node inliningTarget, Object self, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached(inline=false) GilNode gil, @Cached(inline=false) PForeignToPTypeNode toPythonNode) {
            Object element;
            gil.release(true);
            try {
                element = interop.getIteratorNextElement(self);
            }
            catch (StopIterationException e) {
                throw TpSlotIterNext.TpIterNextBuiltin.iteratorExhausted();
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"iterator claimed to be iterator but wasn't");
            }
            finally {
                gil.acquire();
            }
            return toPythonNode.executeConvert(element);
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class PHashingStorageIteratorNextValue
        extends Node {
            PHashingStorageIteratorNextValue() {
            }

            abstract Object execute(Node var1, PHashingStorageIterator var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4);

            @Specialization
            static Object doDictValue(Node inliningTarget, PDictView.PDictValueIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Cached.Shared(value="val") @Cached HashingStorageNodes.HashingStorageIteratorValue itValueNode) {
                return itValueNode.execute(inliningTarget, storage, it);
            }

            @Specialization
            static Object doDictKey(Node inliningTarget, PDictView.PDictKeyIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Cached.Shared(value="key") @Cached HashingStorageNodes.HashingStorageIteratorKey itKeyNode) {
                return itKeyNode.execute(inliningTarget, storage, it);
            }

            @Specialization
            static PTuple doDictItem(Node inliningTarget, PDictView.PDictItemIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Bind PythonLanguage language, @Cached.Shared(value="val") @Cached HashingStorageNodes.HashingStorageIteratorValue itValueNode, @Cached.Shared(value="key") @Cached HashingStorageNodes.HashingStorageIteratorKey itKeyNode) {
                return PFactory.createTuple(language, new Object[]{itKeyNode.execute(inliningTarget, storage, it), itValueNode.execute(inliningTarget, storage, it)});
            }

            @Specialization
            static Object doSetKey(Node inliningTarget, PBaseSetIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Cached.Shared(value="key") @Cached HashingStorageNodes.HashingStorageIteratorKey itKeyNode) {
                return itKeyNode.execute(inliningTarget, storage, it);
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object exhausted(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached NextHelperNode nextHelperNode) {
            return nextHelperNode.execute(frame, inliningTarget, self);
        }
    }
}

