/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;

public final class MemoTable {
    private static final int INITIAL_CAPACITY = 8;
    private static final int OCCUPANCY_EXPONENT = 1;
    private static final int CAPACITY_INC_EXPONENT = 2;
    private Object[] keys;
    private int[] values;
    private int mask;
    private int size;

    public MemoTable() {
        this.initArrays(8);
    }

    private MemoTable(MemoTable map) {
        this.keys = PythonUtils.arrayCopyOf(map.keys, map.keys.length);
        this.values = PythonUtils.arrayCopyOf(map.values, map.values.length);
        this.size = map.size;
        this.mask = map.mask;
    }

    public MemoTable copy() {
        return new MemoTable(this);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.initArrays(8);
        this.size = 0;
    }

    private void initArrays(int newLength) {
        this.keys = new Object[newLength];
        this.values = new int[newLength];
        assert (Integer.bitCount(newLength) == 1);
        this.mask = newLength - 1;
    }

    private int getIndex(Object key) {
        return System.identityHashCode(key) & this.mask;
    }

    public int get(Object key) {
        int index;
        int start = index = this.getIndex(key);
        do {
            if (CompilerDirectives.injectBranchProbability((double)0.75, (this.keys[index] == null ? 1 : 0) != 0)) {
                return -1;
            }
            if (!CompilerDirectives.injectBranchProbability((double)0.75, (this.keys[index] == key ? 1 : 0) != 0)) continue;
            return this.values[index];
        } while (!CompilerDirectives.injectBranchProbability((double)0.25, ((index = index + 1 & this.mask) == start ? 1 : 0) != 0));
        return -1;
    }

    private void setInternal(Object key, int value) {
        assert (key != null);
        assert (value >= 0);
        int index = this.getIndex(key);
        while (true) {
            if (CompilerDirectives.injectBranchProbability((double)0.75, (this.keys[index] == null ? 1 : 0) != 0)) {
                this.keys[index] = key;
                this.values[index] = value;
                return;
            }
            index = index + 1 & this.mask;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void resize() {
        int newLength = this.keys.length << 2;
        if (newLength <= this.keys.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic(null, PythonErrorType.PicklingError, ErrorMessages.STRUCT_SIZE_TOO_LONG);
        }
        MemoIterator iterator = this.iterator();
        this.initArrays(newLength);
        while (iterator.advance()) {
            this.setInternal(iterator.key(), iterator.value());
        }
    }

    public void set(Object key, int value) {
        this.setInternal(key, value);
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (++this.size > this.keys.length >> 1 ? 1 : 0) != 0)) {
            this.resize();
        }
    }

    public MemoIterator iterator() {
        return new MemoIterator(this);
    }

    public static final class MemoIterator {
        private int index;
        private final Object[] keys;
        private final int[] values;

        public MemoIterator(MemoTable table) {
            this.keys = table.keys;
            this.values = table.values;
            this.index = -1;
        }

        public boolean advance() {
            do {
                ++this.index;
                if (this.index < this.keys.length) continue;
                return false;
            } while (this.keys[this.index] == null);
            return true;
        }

        public Object key() {
            return this.keys[this.index];
        }

        public int value() {
            return this.values[this.index];
        }
    }
}

