/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.LazyPyCArrayTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

public final class LazyPyCArrayTypeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        throw CompilerDirectives.shouldNotReachHere((String)"Should not be part of initialization!");
    }

    @CompilerDirectives.TruffleBoundary
    protected static void createCharArrayGetSet(PythonLanguage language, Object type) {
        NodeFactory<CharArrayRawNode> rawFactory = LazyPyCArrayTypeBuiltinsFactory.CharArrayRawNodeFactory.getInstance();
        Builtin rawNodeBuiltin = CharArrayRawNode.class.getAnnotation(Builtin.class);
        LazyPyCArrayTypeBuiltins.createGetSet(language, type, rawFactory, rawNodeBuiltin);
        NodeFactory<CharArrayValueNode> valueFactory = LazyPyCArrayTypeBuiltinsFactory.CharArrayValueNodeFactory.getInstance();
        Builtin valueNodeBuiltin = CharArrayValueNode.class.getAnnotation(Builtin.class);
        LazyPyCArrayTypeBuiltins.createGetSet(language, type, valueFactory, valueNodeBuiltin);
    }

    @CompilerDirectives.TruffleBoundary
    protected static void createWCharArrayGetSet(PythonLanguage language, Object type) {
        NodeFactory<WCharArrayValueNode> valueFactory = LazyPyCArrayTypeBuiltinsFactory.WCharArrayValueNodeFactory.getInstance();
        Builtin valueNodeBuiltin = WCharArrayValueNode.class.getAnnotation(Builtin.class);
        LazyPyCArrayTypeBuiltins.createGetSet(language, type, valueFactory, valueNodeBuiltin);
    }

    @CompilerDirectives.TruffleBoundary
    private static void createGetSet(PythonLanguage language, Object type, NodeFactory<? extends PythonBuiltinBaseNode> factory, Builtin builtin) {
        TruffleString name = PythonUtils.toTruffleStringUncached(builtin.name());
        RootCallTarget rawCallTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, factory, true), (Class<? extends Node>)factory.getNodeClass(), builtin.name());
        int flags = PBuiltinFunction.getFlags(builtin, rawCallTarget);
        PBuiltinFunction getter = PFactory.createBuiltinFunction(language, name, type, 1, flags, rawCallTarget);
        GetSetDescriptor callable = PFactory.createGetSetDescriptor(language, getter, getter, name, type, false);
        callable.setAttribute(SpecialAttributeNames.T___DOC__, PythonUtils.toTruffleStringUncached(builtin.doc()));
        WriteAttributeToObjectNode.getUncached(true).execute(type, name, callable);
    }

    @Builtin(name="raw", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="value")
    @GenerateNodeFactory
    static abstract class CharArrayRawNode
    extends PythonBinaryBuiltinNode {
        CharArrayRawNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static PBytes doGet(CDataObject self, PNone value, @Bind PythonLanguage language, @Bind Node inliningTarget, @Cached PointerNodes.ReadBytesNode read) {
            return PFactory.createBytes(language, read.execute(inliningTarget, self.b_ptr, self.b_size));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object doSet(VirtualFrame frame, CDataObject self, Object value, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="value") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PointerNodes.WriteBytesNode writeBytesNode, @Cached PRaiseNode raiseNode) {
            Object buffer = acquireLib.acquire(value, 0, frame, indirectCallData);
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                if (len > self.b_size) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.BYTE_STRING_TOO_LONG);
                }
                writeBytesNode.execute(inliningTarget, self.b_ptr, bytes, 0, len);
                PNone pNone = PNone.NONE;
                return pNone;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="value", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="string value")
    @GenerateNodeFactory
    static abstract class CharArrayValueNode
    extends PythonBinaryBuiltinNode {
        CharArrayValueNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static PBytes doGet(CDataObject self, PNone value, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PointerNodes.StrLenNode strLenNode, @Cached PointerNodes.ReadBytesNode read) {
            return PFactory.createBytes(language, read.execute(inliningTarget, self.b_ptr, strLenNode.execute(inliningTarget, self.b_ptr)));
        }

        @Specialization
        static Object doSet(CDataObject self, PBytes value, @Bind Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached PointerNodes.WriteBytesNode writeBytesNode, @Cached PRaiseNode raiseNode) {
            SequenceStorage storage = value.getSequenceStorage();
            int len = storage.length();
            if (len > self.b_size) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.BYTE_STRING_TOO_LONG);
            }
            byte[] bytes = getBytes.execute(inliningTarget, storage);
            writeBytesNode.execute(inliningTarget, self.b_ptr, bytes, 0, len);
            return PNone.NONE;
        }

        @Fallback
        static Object error(Object self, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.BYTES_EXPECTED_INSTEAD_OF_P_INSTANCE, value);
        }
    }

    @Builtin(name="value", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="string value")
    @GenerateNodeFactory
    static abstract class WCharArrayValueNode
    extends PythonBinaryBuiltinNode {
        WCharArrayValueNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static TruffleString doGet(CDataObject self, PNone value, @Bind Node inliningTarget, @Cached PointerNodes.WCsLenNode wCsLenNode, @Cached PointerNodes.ReadBytesNode read, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            byte[] bytes = read.execute(inliningTarget, self.b_ptr, wCsLenNode.execute(inliningTarget, self.b_ptr) * CtypesNodes.WCHAR_T_SIZE);
            TruffleString s = fromByteArrayNode.execute(bytes, CtypesNodes.WCHAR_T_ENCODING);
            return switchEncodingNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"isString(value)"})
        static Object doSet(CDataObject self, Object value, @Bind Node inliningTarget, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached PointerNodes.WriteBytesNode writeBytesNode, @Cached PRaiseNode raiseNode) {
            TruffleString str = switchEncodingNode.execute((AbstractTruffleString)toTruffleStringNode.execute(inliningTarget, value), CtypesNodes.WCHAR_T_ENCODING);
            int len = str.byteLength(CtypesNodes.WCHAR_T_ENCODING);
            if (len > self.b_size) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.STRING_TOO_LONG);
            }
            InternalByteArray bytes = getInternalByteArrayNode.execute((AbstractTruffleString)str, CtypesNodes.WCHAR_T_ENCODING);
            writeBytesNode.execute(inliningTarget, self.b_ptr, bytes.getArray(), bytes.getOffset(), bytes.getLength());
            return PNone.NONE;
        }

        @Fallback
        static Object error(Object self, Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.UNICODE_STRING_EXPECTED_INSTEAD_OF_P_INSTANCE, value);
        }
    }
}

