/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.csv;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyDictDelItem;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_csv")
public final class CSVModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T__DIALECTS = PythonUtils.tsLiteral("_dialects");
    static final String J_ATTR_DELIMITER = "delimiter";
    static final String J__CSV = "_csv";
    static final TruffleString T__CSV = PythonUtils.tsLiteral("_csv");
    static final int NOT_SET_CODEPOINT = -1;
    long fieldLimit = 131072L;
    private static final String CSV_DOC = "CSV parsing and writing.\n\nThis module provides classes that assist in the reading and writing\nof Comma Separated Value (CSV) files, and implements the interface\ndescribed by PEP 305.  Although many CSV files are simple to parse,\nthe format is not formally defined by a stable specification and\nis subtle enough that parsing lines of a CSV file with something\nlike line.split(\",\") is bound to fail.  The module supports three\nbasic APIs: reading, writing, and registration of dialects.\n\n\nDIALECT REGISTRATION:\n\nReaders and writers support a dialect argument, which is a convenient\nhandle on a group of settings.  When the dialect argument is a string,\nit identifies one of the dialects previously registered with the module.\nIf it is a class or instance, the attributes of the argument are used as\nthe settings for the reader or writer:\n\n    class excel:\n        delimiter = ','\n        quotechar = '\"'\n        escapechar = None\n        doublequote = True\n        skipinitialspace = False\n        lineterminator = '\\r\\n'\n        quoting = QUOTE_MINIMAL\n\nSETTINGS:\n\n    * quotechar - specifies a one-character string to use as the\n        quoting character.  It defaults to '\"'.\n    * delimiter - specifies a one-character string to use as the\n        field separator.  It defaults to ','.\n    * skipinitialspace - specifies how to interpret whitespace which\n        immediately follows a delimiter.  It defaults to False, which\n        means that whitespace immediately following a delimiter is part\n        of the following field.\n    * lineterminator -  specifies the character sequence which should\n        terminate rows.\n    * quoting - controls when quotes should be generated by the writer.\n        It can take on any of the following module constants:\n\n        csv.QUOTE_MINIMAL means only when required, for example, when a\n            field contains either the quotechar or the delimiter\n        csv.QUOTE_ALL means that quotes are always placed around fields.\n        csv.QUOTE_NONNUMERIC means that quotes are always placed around\n            fields which do not parse as integers or floating point\n            numbers.\n        csv.QUOTE_STRINGS means that quotes are always placed around\n            fields which are strings.  Note that the Python value None\n            is not a string.\n        csv.QUOTE_NOTNULL means that quotes are only placed around fields\n            that are not the Python value None.\n        csv.QUOTE_NONE means that quotes are never placed around fields.\n    * escapechar - specifies a one-character string used to escape\n        the delimiter when quoting is set to QUOTE_NONE.\n    * doublequote - controls the handling of quotes inside fields.  When\n        True, two consecutive quotes are interpreted as one during read,\n        and when writing, each quote character embedded in the data is\n        written as two quotes\n";
    private static final String READER_DOC = "\ncsv_reader = reader(iterable [, dialect='excel']\n                    [optional keyword args])\nfor row in csv_reader:\nprocess(row)\n\nThe \"iterable\" argument can be any object that returns a line\nof input for each iteration, such as a file object or a list.  The\noptional \"dialect\" parameter is discussed below.  The function\nalso accepts optional keyword arguments which override settings\nprovided by the dialect.\n\nThe returned object is an iterator.  Each iteration returns a row\nof the CSV file (which can span multiple input lines)";
    private static final String WRITER_DOC = "    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    for row in sequence:\n        csv_writer.writerow(row)\n\n    [or]\n\n    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    csv_writer.writerows(rows)\n\nThe \"fileobj\" argument can be any object that supports the file API.\n";

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CSVModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)CSV_DOC);
        this.addBuiltinConstant("__version__", (Object)"1.0");
        this.addBuiltinConstant("QUOTE_MINIMAL", (Object)QuoteStyle.QUOTE_MINIMAL.ordinal());
        this.addBuiltinConstant("QUOTE_ALL", (Object)QuoteStyle.QUOTE_ALL.ordinal());
        this.addBuiltinConstant("QUOTE_NONNUMERIC", (Object)QuoteStyle.QUOTE_NONNUMERIC.ordinal());
        this.addBuiltinConstant("QUOTE_NONE", (Object)QuoteStyle.QUOTE_NONE.ordinal());
        this.addBuiltinConstant("QUOTE_STRINGS", (Object)QuoteStyle.QUOTE_STRINGS.ordinal());
        this.addBuiltinConstant("QUOTE_NOTNULL", (Object)QuoteStyle.QUOTE_NOTNULL.ordinal());
        this.addBuiltinConstant(T__DIALECTS, (Object)PFactory.createDict(core.getLanguage()));
        super.initialize(core);
    }

    @Builtin(name="field_size_limit", parameterNames={"$mod", "limit"}, declaresExplicitSelf=true, doc="Sets an upper limit on parsed fields.\ncsv.field_size_limit([limit])\n\nReturns old limit. If limit is not given, no new limit is set and\nthe old limit is returned")
    @GenerateNodeFactory
    public static abstract class CSVFieldSizeLimitNode
    extends PythonBuiltinNode {
        @Specialization
        static long getOrSetFieldSizeLimit(VirtualFrame frame, PythonModule self, Object newLimit, @Bind Node inliningTarget, @Cached PyLongCheckExactNode checkLongNode, @Cached PyLongAsLongNode castToLong, @Cached PRaiseNode raiseNode) {
            CSVModuleBuiltins csvModuleBuiltins = (CSVModuleBuiltins)self.getBuiltins();
            long oldLimit = csvModuleBuiltins.fieldLimit;
            if (newLimit != PNone.NO_VALUE) {
                if (!checkLongNode.execute(inliningTarget, newLimit)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_INTEGER, "limit");
                }
                csvModuleBuiltins.fieldLimit = castToLong.execute((Frame)frame, inliningTarget, newLimit);
            }
            return oldLimit;
        }
    }

    @Builtin(name="writer", doc="    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    for row in sequence:\n        csv_writer.writerow(row)\n\n    [or]\n\n    csv_writer = csv.writer(fileobj [, dialect='excel']\n                            [optional keyword args])\n    csv_writer.writerows(rows)\n\nThe \"fileobj\" argument can be any object that supports the file API.\n", parameterNames={"outputfile", "dialect"}, minNumOfPositionalArgs=1, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CSVWriterNode
    extends PythonBuiltinNode {
        @Specialization
        static Object createReader(VirtualFrame frame, Object outputFile, Object dialectObj, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached CallNode callNode, @Cached PyObjectLookupAttr lookupAttr, @Cached PyCallableCheckNode checkCallable, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            Object write = lookupAttr.execute((Frame)frame, inliningTarget, outputFile, IONodes.T_WRITE);
            if (write == PNone.NO_VALUE || !checkCallable.execute(inliningTarget, write)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_HAVE_WRITE_METHOD, "argument 1");
            }
            CSVDialect dialect = (CSVDialect)callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.CSVDialect, new Object[]{dialectObj}, kwargs);
            return PFactory.createCSVWriter(language, write, dialect);
        }
    }

    @Builtin(name="reader", doc="\ncsv_reader = reader(iterable [, dialect='excel']\n                    [optional keyword args])\nfor row in csv_reader:\nprocess(row)\n\nThe \"iterable\" argument can be any object that returns a line\nof input for each iteration, such as a file object or a list.  The\noptional \"dialect\" parameter is discussed below.  The function\nalso accepts optional keyword arguments which override settings\nprovided by the dialect.\n\nThe returned object is an iterator.  Each iteration returns a row\nof the CSV file (which can span multiple input lines)", parameterNames={"csvfile", "dialect"}, minNumOfPositionalArgs=1, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CSVReaderNode
    extends PythonBuiltinNode {
        @Specialization
        static Object createReader(VirtualFrame frame, Object csvfile, Object dialectObj, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached CallNode callNode, @Bind PythonLanguage language) {
            Object inputIter = getIter.execute((Frame)frame, inliningTarget, csvfile);
            CSVDialect dialect = (CSVDialect)callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.CSVDialect, new Object[]{dialectObj}, kwargs);
            return PFactory.createCSVReader(language, inputIter, dialect);
        }
    }

    @Builtin(name="list_dialects", parameterNames={"$mod"}, declaresExplicitSelf=true, doc="Return a list of all known dialect names.\nnames = csv.list_dialects()")
    @GenerateNodeFactory
    public static abstract class CSVListDialectsNode
    extends PythonBuiltinNode {
        @Specialization
        PList listDialects(VirtualFrame frame, PythonModule module, @Cached ReadAttributeFromObjectNode readNode, @Cached ListNodes.ConstructListNode constructListNode) {
            Object dialects = readNode.execute(module, T__DIALECTS);
            return constructListNode.execute((Frame)frame, dialects);
        }
    }

    @Builtin(name="get_dialect", parameterNames={"$mod", "name"}, minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="Return the dialect instance associated with name.\ndialect = csv.get_dialect(name)")
    @GenerateNodeFactory
    public static abstract class CSVGetDialectNode
    extends PythonBuiltinNode {
        public abstract CSVDialect execute(VirtualFrame var1, PythonModule var2, Object var3);

        @NeverDefault
        protected static CSVGetDialectNode create() {
            return CSVModuleBuiltinsFactory.CSVGetDialectNodeFactory.create(null);
        }

        @Specialization
        static CSVDialect get(VirtualFrame frame, PythonModule module, Object nameObj, @Bind Node inliningTarget, @Cached PyDictGetItem getItemNode, @Cached ReadAttributeFromObjectNode readNode, @Cached PRaiseNode raiseNode) {
            PDict dialects = (PDict)readNode.execute(module, T__DIALECTS);
            CSVDialect dialect = (CSVDialect)getItemNode.execute((Frame)frame, inliningTarget, dialects, nameObj);
            if (dialect == null) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.CSVError, ErrorMessages.UNKNOWN_DIALECT);
            }
            return dialect;
        }
    }

    @Builtin(name="unregister_dialect", parameterNames={"$mod", "name"}, minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="Delete the name/dialect mapping associated with a string name.\ncsv.unregister_dialect(name)")
    @GenerateNodeFactory
    public static abstract class CSVUnregisterDialectNode
    extends PythonBuiltinNode {
        @Specialization
        static PNone unregister(VirtualFrame frame, PythonModule module, Object nameObj, @Bind Node inliningTarget, @Cached ReadAttributeFromObjectNode readNode, @Cached PyDictDelItem delItem, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode raiseNode) {
            PDict dialects = (PDict)readNode.execute(module, T__DIALECTS);
            if (!getItem.hasKey((Frame)frame, inliningTarget, dialects.getDictStorage(), nameObj)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.CSVError, ErrorMessages.UNKNOWN_DIALECT);
            }
            delItem.execute((Frame)frame, inliningTarget, dialects, nameObj);
            return PNone.NONE;
        }
    }

    @Builtin(name="register_dialect", parameterNames={"$mod", "name", "dialect"}, minNumOfPositionalArgs=2, takesVarKeywordArgs=true, declaresExplicitSelf=true, doc="Create a mapping from a string name to a dialect class.\ndialect = csv.register_dialect(name, dialect)")
    @GenerateNodeFactory
    public static abstract class CSVRegisterDialectNode
    extends PythonBuiltinNode {
        @Specialization
        static PNone register(VirtualFrame frame, PythonModule module, Object nameObj, Object dialectObj, PKeyword[] keywords, @Bind Node inliningTarget, @Cached CastToTruffleStringNode nameNode, @Cached ReadAttributeFromObjectNode readNode, @Cached CallNode callNode, @Cached PyDictSetItem setItem, @Cached PRaiseNode raiseNode) {
            TruffleString name;
            try {
                name = nameNode.execute(inliningTarget, nameObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STRING, "dialect name");
            }
            Object result = callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.CSVDialect, new Object[]{dialectObj}, keywords);
            PDict dialects = (PDict)readNode.execute(module, T__DIALECTS);
            setItem.execute((Frame)frame, inliningTarget, dialects, name, result);
            return PNone.NONE;
        }
    }
}

