/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.integration.test.utility;

import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class InformixContainer
extends JdbcDatabaseContainer<InformixContainer> {
    private static final int INFORMIX_PORT = 9088;
    private static final String IFX_CONFIG_DIR = "/opt/ibm/config/";
    private String databaseName = "sysadmin";

    public InformixContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDriverClassName() {
        return "com.informix.jdbc.IfxDriver";
    }

    public Integer getJdbcPort() {
        return this.getMappedPort(9088);
    }

    public String getJdbcUrl() {
        return "jdbc:informix-sqli://%s:%d/%s".formatted(this.getHost(), this.getJdbcPort(), this.databaseName);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Collections.singleton(this.getJdbcPort());
    }

    public String getPassword() {
        return "in4mix";
    }

    public String getUsername() {
        return "informix";
    }

    public InformixContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (InformixContainer)this.self();
    }

    public InformixContainer withInitFile(MountableFile mountableFile) {
        this.setEnvAndCopyFile(mountableFile, FileType.INIT_FILE);
        return (InformixContainer)this.self();
    }

    public InformixContainer withPassword(String password) {
        throw new UnsupportedOperationException();
    }

    public InformixContainer withPostInitFile(MountableFile mountableFile) {
        this.setEnvAndCopyFile(mountableFile, FileType.RUN_FILE_POST_INIT);
        return (InformixContainer)this.self();
    }

    public InformixContainer withUrlParam(String paramName, String paramValue) {
        throw new UnsupportedOperationException();
    }

    public InformixContainer withUsername(String username) {
        throw new UnsupportedOperationException();
    }

    protected void configure() {
        super.configure();
        this.addExposedPort(9088);
        this.addEnv("LICENSE", "accept");
        ((InformixContainer)this.withPrivilegedMode(true)).waitingFor(new LogMessageWaitStrategy().withRegEx(".*Maximum server connections 1.*").withTimes(1).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS)));
    }

    protected String getTestQueryString() {
        return "select today from systables where tabid = 1";
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }

    private void setEnvAndCopyFile(MountableFile mountableFile, FileType fileType) {
        this.addEnv(fileType.toString(), Path.of(mountableFile.getFilesystemPath(), new String[0]).getFileName().toString());
        this.withCopyFileToContainer(mountableFile, IFX_CONFIG_DIR);
    }

    private static enum FileType {
        INIT_FILE,
        RUN_FILE_POST_INIT;

    }
}

