/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.integration.test.utility;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.cassandra.CassandraContainer;
import org.testcontainers.cassandra.delegate.CassandraDatabaseDelegate;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public final class CassandraTestUtility {
    public static CassandraContainer newCassandraContainer() {
        return CassandraTestUtility.newCassandraContainer("5.0.4");
    }

    private static CassandraContainer newCassandraContainer(String version) {
        DockerImageName imageName = DockerImageName.parse((String)"cassandra");
        class CassandraInitContainer
        extends CassandraContainer {
            private String containerInitScriptPath;

            public CassandraInitContainer(DockerImageName dockerImageName) {
                super(dockerImageName);
            }

            public CassandraInitContainer withContainerInitScript(String containerInitScriptPath) {
                this.containerInitScriptPath = containerInitScriptPath;
                return this;
            }

            protected void containerIsStarted(InspectContainerResponse containerInfo) {
                if (this.containerInitScriptPath == null) {
                    return;
                }
                try {
                    new CassandraDatabaseDelegate((ContainerState)this).execute(null, this.containerInitScriptPath, -1, false, false);
                }
                catch (ScriptUtils.ScriptStatementFailedException e) {
                    this.logger().error("Error while executing init script: {}", (Object)this.containerInitScriptPath, (Object)e);
                    throw new ScriptUtils.UncategorizedScriptException("Error while executing init script: " + this.containerInitScriptPath, (Exception)((Object)e));
                }
            }
        }
        CassandraContainer dbContainer = (CassandraContainer)((CassandraContainer)((CassandraContainer)((CassandraContainer)new CassandraInitContainer(imageName.withTag(version)).withContainerInitScript("cassandra.create-database.cql").withCopyFileToContainer(MountableFile.forClasspathResource((String)"cassandra.create-database.cql"), "cassandra.create-database.cql")).withCopyFileToContainer(MountableFile.forClasspathResource((String)"cassandra.yaml"), "/etc/cassandra/cassandra.yaml")).withCopyFileToContainer(MountableFile.forClasspathResource((String)"cassandra.keystore"), "/security/cassandra.keystore")).withCopyFileToContainer(MountableFile.forClasspathResource((String)"cassandra.truststore"), "/security/cassandra.truststore");
        return dbContainer;
    }

    private CassandraTestUtility() {
    }
}

