/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Notified;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseManager {
    private static AtomicInteger dbIDCounter = new AtomicInteger();
    static final HashMap<String, Database> memDatabaseMap = new HashMap();
    static final HashMap<String, Database> fileDatabaseMap = new HashMap();
    static final HashMap<String, Database> resDatabaseMap = new HashMap();
    static final IntKeyHashMap<Database> databaseIDMap = new IntKeyHashMap();
    static final HashMap<Notified, HashSet<Database>> serverMap = new HashMap();
    private static final HsqlTimer timer = new HsqlTimer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HsqlArrayList<String> getDatabaseURIs() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        IntKeyHashMap<Database> intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator<Database> iterator = databaseIDMap.values().iterator();
            while (iterator.hasNext()) {
                Database database = iterator.next();
                hsqlArrayList.add(database.getURI());
            }
        }
        return hsqlArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabases(int n) {
        IntKeyHashMap<Database> intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            Iterator<Database> iterator = databaseIDMap.values().iterator();
            while (iterator.hasNext()) {
                Database database = iterator.next();
                try {
                    database.close(n);
                }
                catch (HsqlException hsqlException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session newSession(int n, String string, String string2, String string3) {
        Database database;
        Object object = databaseIDMap;
        synchronized (object) {
            database = databaseIDMap.get(n);
        }
        if (database == null) {
            return null;
        }
        object = database.connect(string, string2, TimeZone.getTimeZone(string3));
        ((Session)object).isNetwork = true;
        return object;
    }

    public static Session newSession(String string, String string2, String string3, String string4, HsqlProperties hsqlProperties, TimeZone timeZone) {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        return database.connect(string3, string4, timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(int n, long l) {
        Database database;
        IntKeyHashMap<Database> intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            database = databaseIDMap.get(n);
        }
        return database == null ? null : database.sessionManager.getSession(l);
    }

    public static int getDatabase(String string, String string2, Notified notified, HsqlProperties hsqlProperties) {
        Database database = DatabaseManager.getDatabase(string, string2, hsqlProperties);
        DatabaseManager.registerServer(notified, database);
        return database.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(int n) {
        IntKeyHashMap<Database> intKeyHashMap = databaseIDMap;
        synchronized (intKeyHashMap) {
            return databaseIDMap.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDatabases(Notified notified, int n) {
        Database[] databaseArray;
        HashMap<Notified, HashSet<Database>> hashMap = serverMap;
        synchronized (hashMap) {
            HashSet<Database> hashSet = serverMap.get((Object)notified);
            if (hashSet == null) {
                databaseArray = new Database[]{};
            } else {
                databaseArray = new Database[hashSet.size()];
                hashSet.toArray(databaseArray);
            }
        }
        for (int i = 0; i < databaseArray.length; ++i) {
            databaseArray[i].close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String string, String string2, HsqlProperties hsqlProperties) {
        Database database;
        DatabaseType databaseType = DatabaseType.get(string);
        Database database2 = database = DatabaseManager.getDatabaseObject(databaseType, string2, hsqlProperties);
        synchronized (database2) {
            switch (database.getState()) {
                case 1: {
                    break;
                }
                case 4: {
                    if (DatabaseManager.lookupDatabaseObject(databaseType, string2) == null) {
                        DatabaseManager.addDatabaseObject(databaseType, string2, database);
                    }
                    database.open();
                    break;
                }
                case 2: 
                case 3: {
                    throw Error.error(451, 23);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Database getDatabaseObject(DatabaseType databaseType, String string, HsqlProperties hsqlProperties) {
        Database database;
        BaseHashMap baseHashMap;
        HashMap<String, Database> hashMap;
        String string2 = string;
        switch (databaseType) {
            case DB_FILE: {
                hashMap = fileDatabaseMap;
                string2 = DatabaseManager.filePathToKey(string);
                baseHashMap = hashMap;
                synchronized (baseHashMap) {
                    database = hashMap.get((Object)string2);
                    if (database == null && hashMap.size() > 0) {
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string3 = (String)iterator.next();
                            if (!string2.equalsIgnoreCase(string3)) continue;
                            string2 = string3;
                            break;
                        }
                    }
                    break;
                }
            }
            case DB_RES: {
                hashMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                hashMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        baseHashMap = hashMap;
        synchronized (baseHashMap) {
            database = hashMap.get((Object)string2);
        }
        if (database == null) {
            database = new Database(databaseType, string, string2, hsqlProperties);
            database.databaseID = dbIDCounter.getAndIncrement();
            baseHashMap = databaseIDMap;
            synchronized (baseHashMap) {
                databaseIDMap.put(database.databaseID, database);
            }
            baseHashMap = hashMap;
            synchronized (baseHashMap) {
                hashMap.put(string2, database);
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Database lookupDatabaseObject(DatabaseType databaseType, String string) {
        HashMap<String, Database> hashMap;
        String string2 = string;
        switch (databaseType) {
            case DB_FILE: {
                hashMap = fileDatabaseMap;
                string2 = DatabaseManager.filePathToKey(string);
                break;
            }
            case DB_RES: {
                hashMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                hashMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        HashMap<String, Database> hashMap2 = hashMap;
        synchronized (hashMap2) {
            return hashMap.get((Object)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addDatabaseObject(DatabaseType databaseType, String string, Database database) {
        HashMap<String, Database> hashMap;
        String string2 = string;
        switch (databaseType) {
            case DB_FILE: {
                hashMap = fileDatabaseMap;
                string2 = DatabaseManager.filePathToKey(string);
                break;
            }
            case DB_RES: {
                hashMap = resDatabaseMap;
                break;
            }
            case DB_MEM: {
                hashMap = memDatabaseMap;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DatabaseManager");
            }
        }
        BaseHashMap baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.put(database.databaseID, database);
        }
        baseHashMap = hashMap;
        synchronized (baseHashMap) {
            hashMap.put(string2, database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDatabase(Database database) {
        boolean bl;
        HashMap<String, Database> hashMap;
        String string;
        int n = database.databaseID;
        DatabaseType databaseType = database.getType();
        String string2 = string = database.getPath();
        DatabaseManager.notifyServers(database);
        if (databaseType == DatabaseType.DB_FILE) {
            hashMap = fileDatabaseMap;
            string2 = DatabaseManager.filePathToKey(string);
        } else if (databaseType == DatabaseType.DB_RES) {
            hashMap = resDatabaseMap;
        } else if (databaseType == DatabaseType.DB_MEM) {
            hashMap = memDatabaseMap;
        } else {
            throw Error.runtimeError(201, "DatabaseManager");
        }
        BaseHashMap baseHashMap = databaseIDMap;
        synchronized (baseHashMap) {
            databaseIDMap.remove(n);
            bl = databaseIDMap.isEmpty();
        }
        baseHashMap = hashMap;
        synchronized (baseHashMap) {
            hashMap.remove(string2);
        }
        if (bl) {
            ValuePool.resetPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deRegisterServer(Notified notified) {
        HashMap<Notified, HashSet<Database>> hashMap = serverMap;
        synchronized (hashMap) {
            serverMap.remove(notified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerServer(Notified notified, Database database) {
        HashMap<Notified, HashSet<Database>> hashMap = serverMap;
        synchronized (hashMap) {
            if (!serverMap.containsKey(notified)) {
                serverMap.put(notified, new HashSet());
            }
            HashSet<Database> hashSet = serverMap.get((Object)notified);
            hashSet.add(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyServers(Database database) {
        Notified[] notifiedArray;
        HashMap<Notified, HashSet<Database>> hashMap = serverMap;
        synchronized (hashMap) {
            notifiedArray = new Notified[serverMap.size()];
            serverMap.keysToArray(notifiedArray);
        }
        for (int i = 0; i < notifiedArray.length; ++i) {
            HashSet<Database> hashSet;
            Notified notified = notifiedArray[i];
            boolean bl = false;
            BaseHashMap baseHashMap = serverMap;
            synchronized (baseHashMap) {
                hashSet = serverMap.get((Object)notified);
            }
            if (hashSet != null) {
                baseHashMap = hashSet;
                synchronized (baseHashMap) {
                    bl = hashSet.remove(database);
                }
            }
            if (!bl) continue;
            notified.notify(database.databaseID);
        }
    }

    static boolean isServerDB(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Notified notified = (Notified)iterator.next();
            HashSet<Database> hashSet = serverMap.get((Object)notified);
            if (!hashSet.contains(database)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String string) {
        try {
            return FileUtil.getFileUtil().canonicalPath(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

