/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.io.IOException;
import java.io.Writer;
import java.sql.DriverManager;
import java.util.logging.Level;
import java.util.logging.Logger;

class DriverManagerLogWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger(DriverManager.class.getName());
    private static final Level LOG_LEVEL = Level.CONFIG;
    private final boolean shouldLog = LOGGER.isLoggable(LOG_LEVEL);
    private final StringBuilder buffer = new StringBuilder();

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        if (!this.shouldLog) {
            return;
        }
        if (this.buffer.length() > 0) {
            LOGGER.log(LOG_LEVEL, this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.shouldLog) {
            return;
        }
        for (int i = off; i < off + len; ++i) {
            char c = cbuf[i];
            if (c == '\n') {
                this.flush();
                continue;
            }
            this.buffer.append(c);
        }
    }
}

