/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.datasource.DatabaseServerType;

public final class SchemaRetrievalOptions
implements Options {
    private final DatabaseServerType dbServerType;
    private final String identifierQuoteString;
    private final Identifiers identifiers;
    private final InformationSchemaViews informationSchemaViews;
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;
    private final TypeMap typeMap;
    private final TableTypes tableTypes;
    private final EnumDataTypeHelper enumDataTypeHelper;
    private final EnumMap<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy> metadataRetrievalStrategyMap;
    private final Consumer<Connection> connectionInitializer;

    protected SchemaRetrievalOptions(SchemaRetrievalOptionsBuilder builder) {
        SchemaRetrievalOptionsBuilder bldr = builder == null ? SchemaRetrievalOptionsBuilder.builder() : builder;
        this.dbServerType = bldr.dbServerType;
        this.supportsCatalogs = bldr.overridesSupportsCatalogs.orElse(bldr.supportsCatalogs);
        this.supportsSchemas = bldr.overridesSupportsSchemas.orElse(bldr.supportsSchemas);
        this.identifierQuoteString = bldr.identifierQuoteString;
        this.informationSchemaViews = bldr.informationSchemaViews;
        this.identifiers = bldr.identifiers;
        this.typeMap = bldr.overridesTypeMap.orElse(new TypeMap());
        this.tableTypes = bldr.tableTypes;
        this.enumDataTypeHelper = bldr.enumDataTypeHelper;
        this.metadataRetrievalStrategyMap = new EnumMap<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy>(bldr.metadataRetrievalStrategyMap);
        this.connectionInitializer = bldr.connectionInitializer;
    }

    public MetadataRetrievalStrategy get(SchemaInfoMetadataRetrievalStrategy schemaInfoMetadataRetrievalStrategy) {
        Objects.requireNonNull(schemaInfoMetadataRetrievalStrategy, "No schema info metadata retrieval strategy provided");
        return this.metadataRetrievalStrategyMap.get((Object)schemaInfoMetadataRetrievalStrategy);
    }

    public Consumer<Connection> getConnectionInitializer() {
        return this.connectionInitializer;
    }

    public DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public EnumDataTypeHelper getEnumDataTypeHelper() {
        return this.enumDataTypeHelper;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    public TableTypes getTableTypes() {
        return this.tableTypes;
    }

    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    public boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    Map<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy> getMetadataRetrievalStrategyMap() {
        return new EnumMap<SchemaInfoMetadataRetrievalStrategy, MetadataRetrievalStrategy>(this.metadataRetrievalStrategyMap);
    }
}

