/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableFunctionParameter;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaSetter;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.FunctionParameter;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.ParameterModeType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class FunctionParameterRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(FunctionParameterRetriever.class.getName());

    FunctionParameterRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        super(retrieverConnection, catalog, options);
    }

    void retrieveFunctionParameters(NamedObjectList<MutableRoutine> allRoutines, InclusionRule parameterInclusionRule) throws SQLException {
        Objects.requireNonNull(allRoutines, "No functions provided");
        InclusionRuleFilter<FunctionParameter> parameterFilter = new InclusionRuleFilter<FunctionParameter>(parameterInclusionRule, true);
        if (parameterFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving function parameters, since this was not requested");
            return;
        }
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.functionParametersRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving function parameters, using fast data dictionary retrieval");
                this.retrieveFunctionParametersFromDataDictionary(allRoutines, parameterFilter);
                break;
            }
            case data_dictionary_over_schemas: {
                LOGGER.log(Level.INFO, "Retrieving function parameters, using fast data dictionary retrieval over schemas");
                this.retrieveFunctionParametersOverSchemas(allRoutines, parameterFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving function parameters");
                this.retrieveFunctionParametersFromMetadata(allRoutines, parameterFilter);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving function parameters");
            }
        }
    }

    private boolean createFunctionParameter(MetadataResultSet results, NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionParameter> parameterFilter) {
        String columnCatalogName = this.normalizeCatalogName(results.getString("FUNCTION_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("FUNCTION_SCHEM"));
        String functionName = results.getString("FUNCTION_NAME");
        String columnName = results.getString("COLUMN_NAME");
        String specificName = results.getString("SPECIFIC_NAME");
        ParameterModeType parameterMode = this.getFunctionParameterMode(results.getInt("COLUMN_TYPE", 0));
        LOGGER.log(Level.FINE, new StringFormat("Retrieving function parameter <%s.%s.%s.%s.%s>", columnCatalogName, schemaName, functionName, specificName, columnName));
        if (Utility.isBlank(columnName) && parameterMode == ParameterModeType.result) {
            columnName = "<return value>";
        }
        if (Utility.isBlank(columnName)) {
            return false;
        }
        Optional<MutableRoutine> optionalRoutine = allRoutines.lookup(new NamedObjectKey(columnCatalogName, schemaName, functionName, specificName));
        if (optionalRoutine.isEmpty()) {
            return false;
        }
        MutableRoutine routine = optionalRoutine.get();
        if (routine.getRoutineType() != RoutineType.function) {
            return false;
        }
        MutableFunction function = (MutableFunction)routine;
        MutableFunctionParameter parameter = this.lookupOrCreateFunctionParameter(function, columnName);
        parameter.withQuoting(this.getRetrieverConnection().getIdentifiers());
        if (parameterFilter.test(parameter) && this.belongsToSchema(function, columnCatalogName, schemaName)) {
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int length = results.getInt("LENGTH", 0);
            int precision = results.getInt("PRECISION", 0);
            boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
            String remarks = results.getString("REMARKS");
            parameter.setOrdinalPosition(ordinalPosition);
            parameter.setParameterMode(parameterMode);
            parameter.setColumnDataType(this.lookupOrCreateColumnDataType(DataTypeType.user_defined, function.getSchema(), dataType, typeName));
            parameter.setSize(length);
            parameter.setPrecision(precision);
            parameter.setNullable(isNullable);
            parameter.setRemarks(remarks);
            parameter.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, new StringFormat("Adding parameter to function <%s>", parameter));
            function.addParameter(parameter);
            return true;
        }
        return false;
    }

    private ParameterModeType getFunctionParameterMode(int columnType) {
        switch (columnType) {
            case 1: {
                return ParameterModeType.in;
            }
            case 2: {
                return ParameterModeType.inOut;
            }
            case 3: {
                return ParameterModeType.out;
            }
            case 5: {
                return ParameterModeType.result;
            }
            case 4: {
                return ParameterModeType.returnValue;
            }
        }
        return ParameterModeType.unknown;
    }

    private MutableFunctionParameter lookupOrCreateFunctionParameter(MutableFunction function, String columnName) {
        Optional<MutableFunctionParameter> parameterOptional = function.lookupParameter(columnName);
        return parameterOptional.orElseGet(() -> new MutableFunctionParameter(function, columnName));
    }

    private void retrieveFunctionParametersFromDataDictionary(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionParameter> parameterFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FUNCTION_COLUMNS)) {
            throw new ExecutionRuntimeException("No function parameters SQL provided");
        }
        String name = "function parameters from data dictionary";
        RetrievalCounts retrievalCounts = new RetrievalCounts("function parameters from data dictionary");
        Query functionColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.FUNCTION_COLUMNS);
        try (Connection connection = this.getRetrieverConnection().getConnection("function parameters from data dictionary");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(functionColumnsSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                boolean added = this.createFunctionParameter(results, allRoutines, parameterFilter);
                retrievalCounts.countIfIncluded(added);
            }
        }
        retrievalCounts.log();
    }

    private void retrieveFunctionParametersFromMetadata(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionParameter> parameterFilter) {
        String name = "function parameters from metadata";
        RetrievalCounts retrievalCounts = new RetrievalCounts("function parameters from metadata");
        for (MutableRoutine routine : allRoutines) {
            if (routine.getRoutineType() != RoutineType.function) continue;
            LOGGER.log(Level.INFO, new StringFormat("Retrieving %s for %s", "function parameters from metadata", routine.key()));
            MutableFunction function = (MutableFunction)routine;
            try {
                Connection connection = this.getRetrieverConnection().getConnection("function parameters from metadata");
                try (MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getFunctionColumns(function.getSchema().getCatalogName(), function.getSchema().getName(), function.getName(), null), "DatabaseMetaData::getFunctionColumns");){
                    while (results.next()) {
                        retrievalCounts.count();
                        boolean added = this.createFunctionParameter(results, allRoutines, parameterFilter);
                        retrievalCounts.countIfIncluded(added);
                    }
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (AbstractMethodError e) {
                this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve parameters for function %s", function), e);
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve parameters for function %s", function), e);
            }
        }
        retrievalCounts.log();
    }

    private void retrieveFunctionParametersOverSchemas(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionParameter> parameterFilter) throws SQLException {
        Collection<Schema> schemas = this.catalog.getSchemas();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FUNCTION_COLUMNS)) {
            throw new ExecutionRuntimeException("No function parameters SQL provided");
        }
        Query functionColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.FUNCTION_COLUMNS);
        String name = "function parameters from data dictionary over schemas";
        RetrievalCounts retrievalCounts = new RetrievalCounts("function parameters from data dictionary over schemas");
        for (Schema schema : schemas) {
            if (this.catalog.getRoutines(schema).isEmpty()) continue;
            try (Connection connection = this.getRetrieverConnection().getConnection("function parameters from data dictionary over schemas");
                 SchemaSetter schemaSetter = new SchemaSetter(connection, schema);
                 Statement statement = connection.createStatement();
                 MetadataResultSet results = new MetadataResultSet(functionColumnsSql, statement, this.getLimitMap(schema));){
                while (results.next()) {
                    retrievalCounts.count(schema.key());
                    boolean added = this.createFunctionParameter(results, allRoutines, parameterFilter);
                    retrievalCounts.countIfIncluded(schema.key(), added);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, new StringFormat("Could not retrieve function parameters for schema <%s>", schema));
            }
            retrievalCounts.log(schema.key());
        }
        retrievalCounts.log();
    }
}

