/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;

public final class ObjectSequenceStorage
extends ArrayBasedSequenceStorage {
    private Object[] values;

    public ObjectSequenceStorage(Object[] elements) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = elements.length;
        TruffleStringMigrationHelpers.assertContainsNoJavaString(elements);
    }

    public ObjectSequenceStorage(Object[] elements, int length) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = length;
        TruffleStringMigrationHelpers.assertContainsNoJavaString(elements);
    }

    public ObjectSequenceStorage(int capacity) {
        this.values = new Object[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    public Object getObjectItemNormalized(int idx) {
        return this.values[idx];
    }

    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                Object temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    public void setObjectItemNormalized(int idx, Object value) {
        this.values[idx] = TruffleStringMigrationHelpers.assertNoJavaString(value);
    }

    @Override
    public ArrayBasedSequenceStorage createEmpty(int newCapacity) {
        return new ObjectSequenceStorage(newCapacity);
    }

    public Object[] getInternalObjectArray() {
        return this.values;
    }

    public Object[] getCopyOfInternalArray() {
        return PythonUtils.arrayCopyOf(this.values, this.length);
    }

    public void insertItem(int idx, Object value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = TruffleStringMigrationHelpers.assertNoJavaString(value);
        this.incLength();
    }

    public void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = PythonUtils.arrayCopyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    public void ensureCapacity(int newCapacity) throws ArithmeticException {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (newCapacity > this.capacity ? 1 : 0) != 0)) {
            this.increaseCapacityExactWithCopy(ObjectSequenceStorage.capacityFor(newCapacity));
        }
    }

    @Override
    public Object getIndicativeValue() {
        return null;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (Object[])arrayObject;
        this.capacity = this.values.length;
        TruffleStringMigrationHelpers.assertContainsNoJavaString(this.values);
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Generic;
    }
}

